/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.run.actions.ResetFlowReceivers;
import com.excentis.products.byteblower.run.actions.StartMulticastListening;
import com.excentis.products.byteblower.run.actions.StartTraffic;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.map.MultiValueMap;

public final class StartScenario
extends ConcreteAction<Listener> {
    public static final int WORK = 1;
    private final RuntimeScenario rtScenario;

    static AbstractAction create(Context context, RuntimeScenario rtScenario) {
        return context.decorate(new StartScenario(context, rtScenario));
    }

    private StartScenario(Context context, RuntimeScenario rtScenario) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
    }

    @Override
    public String getDescription() {
        return "Start scenario";
    }

    @Override
    public void invokeImpl() {
        ResetFlowReceivers.create(this.getContext(), this.rtScenario).invoke();
        this.startWirelessEndpoints();
        StartMulticastListening.create(this.getContext(), this.rtScenario).invoke();
        StartTraffic.create(this.getContext(), this.rtScenario).invoke();
        ((Listener)this.getListener()).onScenarioStarted(this.rtScenario);
    }

    private void startWirelessEndpoints() {
        MultiValueMap toStart = MultiValueMap.decorate(new HashMap());
        for (RuntimePort port : this.rtScenario.getRuntimePortsForSynchronousStart()) {
            WirelessEndpoint device = port.getMobilePort();
            if (device == null) continue;
            toStart.put((Object)port.getRuntimeServer(), (Object)port);
        }
        ByteBlowerProjectReader reader = this.rtScenario.getModelScenarioReader().getProjectReader();
        long scenarioHeartBeatInterval = reader.hasScenarioHeartbeat() ? reader.getScenarioHeartbeatInterval() : 0L;
        for (RuntimeServer server : toStart.keySet()) {
            Collection endpoints = toStart.getCollection((Object)server);
            for (RuntimePort endpoint : endpoints) {
                if (!endpoint.getMobilePort().CapabilityIsSupported("Scenario.Stop")) continue;
                endpoint.getMobilePort().ScenarioHeartbeatIntervalSet(scenarioHeartBeatInterval);
            }
        }
        long waitToStart = 0L;
        for (RuntimeServer server : toStart.keySet()) {
            Collection endpoints = toStart.getCollection((Object)server);
            long timeDifferenceWithServer = this.timeOffset(server);
            waitToStart = server.startAll(endpoints) - timeDifferenceWithServer;
        }
        long nowNanos = 0L;
        while ((nowNanos = System.nanoTime()) < waitToStart && !this.getContext().isCancelled()) {
            try {
                long subWait = Math.min(128000000L, waitToStart - nowNanos);
                TimeUnit.NANOSECONDS.sleep(subWait);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private long timeOffset(RuntimeServer server) {
        BigInteger difference = BigInteger.ZERO;
        long attempts = 4L;
        int timeCtr = 0;
        while ((long)timeCtr < attempts) {
            long start = System.nanoTime();
            long stamp = server.now();
            long end = System.nanoTime();
            difference = difference.add(BigInteger.valueOf(stamp - (start + (end - start) / 2L)));
            ++timeCtr;
        }
        difference = difference.divide(BigInteger.valueOf(attempts));
        return difference.longValue();
    }

    public static interface Listener {
        public void onScenarioStarted(RuntimeScenario var1);
    }
}

