/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.ResponseTimeout;
import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StopWirelessEndpoints
extends ConcreteAction<Listener> {
    private static final Logger LOGGER = Logger.getGlobal();
    private final RuntimeScenario runtimeScenario;

    public static AbstractAction create(Context context, RuntimeScenario rtScenario) {
        return context.decorate(new StopWirelessEndpoints(context, rtScenario));
    }

    private StopWirelessEndpoints(Context context, RuntimeScenario rtScenario) {
        super(context, Listener.class);
        this.runtimeScenario = rtScenario;
    }

    @Override
    public String getDescription() {
        return "Cleanup scenario";
    }

    @Override
    public void invokeImpl() {
        try {
            this.stopWirelessEndpoints();
        }
        catch (Exception exception) {}
    }

    private void stopWirelessEndpoints() {
        for (RuntimePort port : this.runtimeScenario.getRuntimePortsInvolved()) {
            long interval;
            WirelessEndpoint device = port.getMobilePort();
            if (device == null || !device.CapabilityIsSupported("Scenario.Stop") || (interval = device.ScenarioHeartbeatIntervalGet()) == 0L) continue;
            device.StopAsync();
        }
        String failedStopsInfo = "";
        HashSet<RuntimePort> unreachable = new HashSet<RuntimePort>();
        for (RuntimePort port : this.runtimeScenario.getRuntimePortsInvolved()) {
            long interval;
            WirelessEndpoint device = port.getMobilePort();
            if (device == null || (interval = device.ScenarioHeartbeatIntervalGet()) == 0L) continue;
            try {
                device.Stop();
            }
            catch (ResponseTimeout ex) {
                LOGGER.log(Level.WARNING, "Failed to stop WEP device", ex);
                unreachable.add(port);
                if (failedStopsInfo.isEmpty()) {
                    failedStopsInfo = String.valueOf(failedStopsInfo) + ", ";
                }
                failedStopsInfo = String.valueOf(failedStopsInfo) + device.DeviceInfoGet().GivenNameGet();
            }
        }
        Collection<RuntimePort> involvedPorts = this.runtimeScenario.getRuntimePortsInvolved();
        involvedPorts.removeAll(unreachable);
        this.waitUntilStopped(involvedPorts);
    }

    private void waitUntilStopped(Collection<RuntimePort> reachablePorts) {
        block2: while (!reachablePorts.isEmpty()) {
            for (RuntimePort port : reachablePorts) {
                WirelessEndpoint device = port.getMobilePort();
                if (device == null || !device.CapabilityIsSupported("Scenario.Stop")) {
                    reachablePorts.remove(port);
                    continue block2;
                }
                DeviceStatus status = device.StatusGet();
                if (DeviceStatus.Reserved == status || DeviceStatus.Unavailable == status) {
                    reachablePorts.remove(port);
                    continue block2;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static interface Listener {
    }
}

