/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ConfigError;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.run.actions.ConfigureFlowTrafficFb;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.osgi.framework.Version;

final class VerifyMobileFBFlow
extends ConcreteAction<ConfigureFlowTrafficFb.Listener> {
    private final RuntimeFbFlow rtFbFlow;
    private final RuntimeMobileDevice rtMobileDevice;

    private VerifyMobileFBFlow(Context context, RuntimeFbFlow rtFbFlow, RuntimeMobileDevice device) {
        super(context, ConfigureFlowTrafficFb.Listener.class);
        this.rtMobileDevice = device;
        this.rtFbFlow = rtFbFlow;
    }

    public static AbstractAction create(Context context, RuntimeFbFlow rtFbFlow, RuntimeMobileDevice device) {
        return context.decorate(new VerifyMobileFBFlow(context, rtFbFlow, device));
    }

    @Override
    public String getDescription() {
        return "Verifying mobile flow '" + this.rtFbFlow.name() + "'";
    }

    @Override
    public void invokeImpl() {
        Version version = this.rtMobileDevice.apiVersion();
        ArrayList<String> forbiddenFeatures = new ArrayList<String>();
        FrameBlastingFlow flowTemplate = this.rtFbFlow.getModelFbFlowTemplate();
        if (flowTemplate.getFrameModifier() != null) {
            forbiddenFeatures.add("frame size modifiers");
        }
        if (flowTemplate.getFrameModifier() != null) {
            forbiddenFeatures.add("timing modifiers");
        }
        if (this.rtFbFlow.hasLatencyDistributionMeasurement() && !this.rtMobileDevice.allowLatencyDistribution()) {
            for (RuntimePort port : this.rtFbFlow.getDestinationRuntimePorts()) {
                if (!port.isMobile()) continue;
                forbiddenFeatures.add("Latency Histogram measurement");
                break;
            }
        }
        if (this.rtFbFlow.hasLatencyMeasurement() && !this.rtMobileDevice.allowLatency()) {
            forbiddenFeatures.add("Latency measurement");
        }
        if (this.rtFbFlow.hasOutOfSequenceDetection()) {
            forbiddenFeatures.add("Out of sequence measurement");
        }
        if (!forbiddenFeatures.isEmpty()) {
            String errorDesc = this.buildErrorString(forbiddenFeatures, this.rtFbFlow, this.rtMobileDevice);
            ((ConfigureFlowTrafficFb.Listener)this.getListener()).onFbFlowConfigurationWarning(this.rtFbFlow, errorDesc);
        }
        this.rtFbFlow.allowOutOfOrder(false);
        EList frameList = flowTemplate.getFrameBlastingFrames();
        if (this.rtFbFlow.getSourceRuntimePort().isMobile() && frameList.size() > 1) {
            String errorMsg = String.format("Only a single frame is supported in version %s. FrameBlasting flow '%s' has %d frames.", version.toString(), this.rtFbFlow.name(), frameList.size());
            throw new ConfigError(errorMsg);
        }
    }

    private String buildErrorString(List<String> forbiddenFeatures, RuntimeFbFlow rtFbFlow2, RuntimeMobileDevice rtMobileDevice2) {
        Version version = this.rtMobileDevice.apiVersion();
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("Mobile device '").append(this.rtMobileDevice.getName()).append("'");
        errorMsg.append("( v").append(version.toString()).append(" )");
        errorMsg.append(" has no support for ");
        int ctr = 0;
        while (ctr < forbiddenFeatures.size()) {
            if (ctr != 0) {
                if (ctr == forbiddenFeatures.size() - 1) {
                    errorMsg.append(" and ");
                } else {
                    errorMsg.append(", ");
                }
            }
            errorMsg.append(forbiddenFeatures.get(ctr));
            ++ctr;
        }
        errorMsg.append(". ");
        if (forbiddenFeatures.size() == 1) {
            errorMsg.append("This feature is ");
        } else {
            errorMsg.append("These features are ");
        }
        errorMsg.append("disabled in flow '").append(this.rtFbFlow.name()).append("'");
        return errorMsg.toString();
    }
}

