/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameL3Type;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.UniqueFieldModifier;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.CreateFrame;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;

final class VerifyMobileFrame
extends ConcreteAction<CreateFrame.Listener> {
    private final RuntimeFbFlow rtFbFlow;
    private final RuntimeFrame mFbFrame;

    private VerifyMobileFrame(Context context, RuntimeFbFlow rtFbFlow, RuntimeFrame frame) {
        super(context, CreateFrame.Listener.class);
        this.rtFbFlow = rtFbFlow;
        this.mFbFrame = frame;
    }

    public static AbstractAction create(Context context, RuntimeFbFlow rtFbFlow, RuntimeFrame mFbFrameReader) {
        return context.decorate(new VerifyMobileFrame(context, rtFbFlow, mFbFrameReader));
    }

    @Override
    public String getDescription() {
        return "Verifying mobile frame '" + this.mFbFrame.name() + "' for flow '" + this.rtFbFlow.name() + "'";
    }

    @Override
    public void invokeImpl() {
        Frame frame = this.mFbFrame.getModelFbFrame();
        FrameReader frameReader = this.mFbFrame.getModelFbFrameReader();
        FrameL3Type l3Type = frameReader.getEthernetType();
        FrameReader.Layer4Type l4Type = frameReader.getLayer4Type();
        if (!frame.getL2AutoDestMac().booleanValue() || !frame.getL2AutoSourceMac().booleanValue()) {
            String errorDesc = String.format("Configuring manual MAC addresses is not supported for Mobile frames\nFrame '%s' in flow '%s' will fill in the L2 MAC address automatically.", this.mFbFrame.name(), this.rtFbFlow.name());
            ((CreateFrame.Listener)this.getListener()).onFrameCreationFailed(this.mFbFrame, errorDesc);
        } else {
            if (!FrameL3Type.IPV4_LITERAL.equals((Object)l3Type) && !FrameL3Type.IPV6_LITERAL.equals((Object)l3Type)) {
                String errorDesc = String.format("Mobile devices solely support IPv4 and IPv6 frames. Frame '%s' in flow '%s' is configured for %s", this.mFbFrame.name(), this.rtFbFlow.name(), l3Type.getName());
                ((CreateFrame.Listener)this.getListener()).onFrameCreationFailed(this.mFbFrame, errorDesc);
                throw new IllegalStateException(errorDesc);
            }
            if (!frame.getL3AutoSourceIp().booleanValue()) {
                String errorDesc = String.format("Configuring manual IPv4 addresses is not supported for Mobile frames\nFrame '%s' in flow '%s' will fill in the IP addresses automatically.", this.mFbFrame.name(), this.rtFbFlow.name());
                ((CreateFrame.Listener)this.getListener()).onFrameCreationFailed(this.mFbFrame, errorDesc);
            } else if (!frame.getL3AutoTotLen().booleanValue()) {
                String errorDesc = String.format("Mobile devices only transmit frames with valid length fields.\nThe IPv4 length length of Frame '%s' in flow '%s' will be corrected automatically.", this.mFbFrame.name(), this.rtFbFlow.name());
                ((CreateFrame.Listener)this.getListener()).onFrameCreationFailed(this.mFbFrame, errorDesc);
            } else if (!frame.getL3AutoHeaderCheck().booleanValue()) {
                String errorDesc = String.format("Mobile devices only transmit frames with valid checksums.\nThe checksum of Frame '%s' in flow '%s' will be calculated.", this.mFbFrame.name(), this.rtFbFlow.name());
                ((CreateFrame.Listener)this.getListener()).onFrameCreationFailed(this.mFbFrame, errorDesc);
            } else {
                if (!FrameReader.Layer4Type.UDP.equals((Object)l4Type)) {
                    String errorDesc = String.format("Mobile devices solely support UDP frames. Frame '%s' in flow '%s' is configured for %s", this.mFbFrame.name(), this.rtFbFlow.name(), l4Type.name());
                    ((CreateFrame.Listener)this.getListener()).onFrameCreationFailed(this.mFbFrame, errorDesc);
                    throw new IllegalStateException(errorDesc);
                }
                if (!frame.getL4AutoUdpChecksum().booleanValue()) {
                    String errorDesc = String.format("Mobile devices only transmit frames with valid checksums.\nThe UDP checksum of Frame '%s' in flow '%s' will be calculated.", this.mFbFrame.name(), this.rtFbFlow.name());
                    ((CreateFrame.Listener)this.getListener()).onFrameCreationFailed(this.mFbFrame, errorDesc);
                } else if (!frame.getL4AutoTotLen().booleanValue()) {
                    String errorDesc = String.format("Mobile devices only transmit frames with valid length fields.\nThe UDP length length of Frame '%s' in flow '%s' will be corrected automatically.", this.mFbFrame.name(), this.rtFbFlow.name());
                    ((CreateFrame.Listener)this.getListener()).onFrameCreationFailed(this.mFbFrame, errorDesc);
                } else if (!frame.getModifiers().isEmpty()) {
                    boolean anyUnsupported = false;
                    for (FrameModifier modifier : frame.getModifiers()) {
                        boolean bl = anyUnsupported = anyUnsupported || !(modifier instanceof UniqueFieldModifier);
                    }
                    if (anyUnsupported) {
                        String errorDesc = String.format("Mobile devices don't support frame modifiers. No modifier will be applied to '%s' from '%s'.", this.mFbFrame.name(), this.rtFbFlow.name());
                        ((CreateFrame.Listener)this.getListener()).onFrameCreationFailed(this.mFbFrame, errorDesc);
                    }
                }
            }
        }
    }
}

