/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.run.RuntimePreferences;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.utils.Sleep;
import java.util.concurrent.TimeUnit;

public final class Wait
extends ConcreteAction<Listener> {
    private long waitTimeMs;
    private final String description;

    static AbstractAction create(Context context, long waitTimeMs, String description) {
        return context.decorate(new Wait(context, waitTimeMs, description));
    }

    public static AbstractAction create(Context context, String description) {
        return context.decorate(new Wait(context, 0L, description));
    }

    private Wait(Context context, long waitTimeMs, String description) {
        super(context, Listener.class);
        this.waitTimeMs = waitTimeMs;
        this.description = description;
    }

    public void sleep(long duration, TimeUnit unit) {
        this.waitTimeMs = unit.toMillis(duration);
        this.invoke();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void invokeImpl() {
        long startWait;
        long MAXSLEEP = RuntimePreferences.getResponsiveWait();
        long now = startWait = System.currentTimeMillis();
        long remaining = this.waitTimeMs;
        Context context = this.getContext();
        while (0L < remaining && !context.isCancelled()) {
            long currentSleep = Math.min(remaining, MAXSLEEP);
            Sleep.sleep((long)currentSleep);
            now = System.currentTimeMillis();
            remaining = this.waitTimeMs - (now - startWait);
        }
        ((Listener)this.getListener()).onWaitedDone();
    }

    public static interface Listener {
        public void onWaitedDone();
    }
}

