/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.natdiscovery;

import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.TCPPacket;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.natdiscovery.EndPoint;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV4;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV6;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkPath;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkProbe;
import com.excentis.products.byteblower.run.actions.natdiscovery.NATCache;
import com.excentis.products.byteblower.run.actions.natdiscovery.TCP;
import com.excentis.products.byteblower.run.actions.natdiscovery.UDP;
import com.excentis.products.byteblower.run.actions.natdiscovery.VLAN;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DumbCache
implements NATCache {
    private Map<LinkPath, LinkPath> paths = new HashMap<LinkPath, LinkPath>();

    @Override
    public boolean isResolved(LinkPath path) {
        return this.paths.containsKey(path);
    }

    @Override
    public LinkPath result(LinkPath path) {
        return this.paths.get(path);
    }

    @Override
    public LinkProbe createProbe(LinkPath path, RuntimePort src, RuntimePort dest, FrameReader base) {
        if (base == null) {
            return null;
        }
        return LinkProbe.createProbe(path, src, dest, base);
    }

    LinkProbe createProbe(LinkPath path, RuntimePort src, RuntimePort dest) {
        return LinkProbe.createProbe(path, src, dest);
    }

    @Override
    public String createFilter(LinkPath path) {
        LinkPath.FilterVisitor visit = new LinkPath.FilterVisitor();
        EndPoint dest = path.getDestinationEnd();
        dest.visit(visit);
        return visit.filter;
    }

    @Override
    public boolean resolve(LinkPath origLink, LinkProbe probe, byte[] probeResult) {
        LinkPath newLink = new LinkPath(origLink);
        EndPoint src = newLink.getSourceEnd();
        EndPoint dest = newLink.getDestinationEnd();
        ProbeResolver visit = new ProbeResolver(src, probeResult, probe);
        dest.visit(visit);
        if (visit.wasSuccesful()) {
            this.paths.put(origLink, newLink);
        }
        return visit.wasSuccesful();
    }

    @Override
    public NatDiscovery.NatDiscoveryParameters parameters(LinkPath origLink) {
        return new NatDiscovery.NatDiscoveryParameters(NatDiscovery.IpType.AUTOMATIC_PUBLIC_IP_DISCOVERY, NatDiscovery.PortType.AUTOMATIC_PUBLIC_PORT_DISCOVERY, origLink.protocol());
    }

    private static class ProbeResolver
    implements EndPoint.EndVisitor {
        private final EndPoint src;
        private final byte[] probeResult;
        private final LinkProbe probe;
        private int ipv4ByteOffset = 14;
        private int ipv6ByteOffset = 14;
        private Ipv4Packet ipv4;
        private Ipv6Packet ipv6;
        private boolean success;

        private ProbeResolver(EndPoint src, byte[] probeResult, LinkProbe probe) {
            this.src = src;
            this.probeResult = probeResult;
            this.probe = probe;
            this.success = false;
        }

        @Override
        public void call(TCP t) {
            int l4ByteOffset;
            if (this.ipv4 != null) {
                l4ByteOffset = this.ipv4ByteOffset + this.ipv4.getIHL() * 4;
            } else if (this.ipv6 != null) {
                l4ByteOffset = this.ipv6ByteOffset + 40;
            } else {
                return;
            }
            int tcpPacketLen = this.probeResult.length - l4ByteOffset;
            if (tcpPacketLen <= 0) {
                return;
            }
            TCPPacket tcp = new TCPPacket(tcpPacketLen * 8, this.probeResult, l4ByteOffset * 8);
            this.src.setPort(tcp.getSource());
            ProtocolField rawPayload = tcp.getPayload();
            byte[] payload = new byte[rawPayload.getSize() / 8];
            rawPayload.dump(payload, 0);
            this.success = Arrays.equals(payload, this.probe.unique.getBytes());
        }

        @Override
        public void call(UDP u) {
            int l4ByteOffset;
            if (this.ipv4 != null) {
                l4ByteOffset = this.ipv4ByteOffset + this.ipv4.getIHL() * 4;
            } else if (this.ipv6 != null) {
                l4ByteOffset = this.ipv6ByteOffset + 40;
            } else {
                return;
            }
            int udpPacketLen = this.probeResult.length - l4ByteOffset;
            if (udpPacketLen <= 0) {
                return;
            }
            UDPPacket udp = new UDPPacket(udpPacketLen * 8, this.probeResult, l4ByteOffset * 8);
            udp.calcSize();
            int initialCheckSum = udp.getCheckSum();
            udp.doCheckSum();
            if (initialCheckSum != udp.getCheckSum()) {
                return;
            }
            this.src.setPort(udp.getSource());
            ProtocolField rawPayload = udp.getPayload();
            byte[] payload = new byte[rawPayload.getSize() / 8];
            rawPayload.dump(payload, 0);
            this.success = Arrays.equals(payload, this.probe.unique.getBytes());
        }

        @Override
        public void call(IPV4 i) {
            int iPv4PacketLen = this.probeResult.length - this.ipv4ByteOffset;
            if (iPv4PacketLen <= 0) {
                return;
            }
            this.ipv4 = new Ipv4Packet(iPv4PacketLen * 8, this.probeResult, this.ipv4ByteOffset * 8);
            int initialChecksum = this.ipv4.getCheckSum();
            this.ipv4.doCheckSum();
            if (initialChecksum != this.ipv4.getCheckSum()) {
                this.ipv4 = null;
            } else {
                this.src.setIP4Address(this.ipv4.getSourceAddress());
            }
        }

        @Override
        public void call(IPV6 i) {
            int iPv6PacketLen = this.probeResult.length - this.ipv6ByteOffset;
            if (iPv6PacketLen <= 0) {
                return;
            }
            this.ipv6 = new Ipv6Packet(iPv6PacketLen * 8, this.probeResult, this.ipv6ByteOffset * 8);
            this.src.setIP4Address(this.ipv6.getSourceAddress());
        }

        @Override
        public void call(VLAN v) {
            this.ipv4ByteOffset += v.getOverhead();
        }

        public boolean wasSuccesful() {
            return this.success;
        }
    }
}

