/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.natdiscovery;

import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.natdiscovery.Direction;
import com.excentis.products.byteblower.run.actions.natdiscovery.EndPoint;
import com.excentis.products.byteblower.run.actions.natdiscovery.TransportLayer;
import com.excentis.products.byteblower.run.objects.RuntimePort;

class IPV4
extends EndPoint {
    private String address;
    private TransportLayer payload;

    IPV4(RuntimePort port, FrameReader baseFrame, Direction dir) {
        EthernetPacket packetEthernet = baseFrame.getEthernet();
        if (packetEthernet.getType() != 2048) {
            throw new IllegalStateException("NAT Discovery only for IPv4 packets");
        }
        if (!port.isRuntimeLayer2Ethernet()) {
            throw new IllegalStateException("Unsupported layer2 type " + port.getRuntimeLayer2Configuration().getClass().getSimpleName());
        }
        this.address = port.getIPAddress();
        this.payload = TransportLayer.createFromIPV4(baseFrame, dir);
    }

    private IPV4(String address, TransportLayer payload) {
        this.address = address;
        this.payload = payload;
    }

    IPV4(RuntimePort port, NatDiscovery.L4Protocol protocol, int l4Port) {
        if (!port.isRuntimeLayer3Ipv4()) {
            throw new IllegalStateException("NAT Discovery only for IPv4 packets");
        }
        if (!port.isRuntimeLayer2Ethernet()) {
            throw new IllegalStateException("Unsupported layer2 type " + port.getRuntimeLayer2Configuration().getClass().getSimpleName());
        }
        this.address = port.getIPAddress();
        this.payload = TransportLayer.create(protocol, l4Port);
    }

    @Override
    public void setPort(int source) {
        this.payload.setPort(source);
    }

    @Override
    public boolean equals(Object e) {
        if (e != null && e instanceof IPV4) {
            IPV4 oth = (IPV4)e;
            return this.address.equals(oth.address) && this.payload.equals(oth.payload);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.address.hashCode() + this.payload.hashCode();
    }

    @Override
    public String getSource() {
        return this.address;
    }

    @Override
    public NatDiscovery.L4Protocol protocol() {
        return this.payload.getProtocol();
    }

    @Override
    public int getPort() {
        return this.payload.getPort();
    }

    @Override
    public IPV4 deepCopy() {
        return new IPV4(this.address, this.payload.deepCopy());
    }

    @Override
    public void setIP4Address(String sourceAddress) {
        this.address = sourceAddress;
    }

    @Override
    public NatDiscovery.L4Protocol getProtocol() {
        return this.payload.getProtocol();
    }

    protected void setPayload(TransportLayer explicitPayload) {
        this.payload = explicitPayload;
    }

    @Override
    public void visit(EndPoint.EndVisitor v, boolean startBottom) {
        if (startBottom) {
            v.call(this);
        }
        this.payload.visit(v);
        if (!startBottom) {
            v.call(this);
        }
    }
}

