/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters;

import com.excentis.products.byteblower.run.filters.FrameContentFilter;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;

public class EthernetEthertypeFilter
extends FrameContentFilter {
    private static final int OFFSET = 12;
    private static final int LENGTH = 2;
    private final int type;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$run$filters$core$BPFFilter$Proto = EthernetEthertypeFilter.$SWITCH_TABLE$com$excentis$products$byteblower$run$filters$core$BPFFilter$Proto();
    }

    public static EthernetEthertypeFilter createEthernetEthertypeFilter(int extraOffset, int type) {
        return new EthernetEthertypeFilter(extraOffset, type);
    }

    private EthernetEthertypeFilter(int type) {
        super(BPFFilter.Proto.ETHERNET, 12, EthernetEthertypeFilter.int2hex(type, 2));
        this.type = type;
    }

    private EthernetEthertypeFilter(int extraOffset, int type) {
        super(BPFFilter.Proto.ETHERNET, 12 + extraOffset, EthernetEthertypeFilter.int2hex(type, 2));
        this.type = type;
    }

    @Override
    protected boolean excludesBPFFilterImpl(Filter other) {
        if (other instanceof BPFFilter) {
            BPFFilter rhs = (BPFFilter)other;
            BPFFilter.Proto otherProto = rhs.getProtocol();
            switch (otherProto) {
                case ARP: {
                    return this.type != 2054;
                }
                case IPv4: {
                    return this.type != 2048;
                }
                case IPv6: {
                    return this.type != 34525;
                }
                case VLAN: {
                    return this.type != 33024 && this.type != 34984 && this.type != 37120;
                }
            }
        }
        return super.excludesBPFFilterImpl(other);
    }
}

