/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters;

import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;
import java.util.StringTokenizer;

public class FrameContentFilter
extends BPFFilter {
    private int offset;
    private String hexValue;

    static String int2hex(int value, int fieldLengthInBytes) {
        String result = Integer.toHexString(value);
        while (result.length() < 2 * fieldLengthInBytes) {
            result = String.valueOf('0') + result;
        }
        return result;
    }

    public static String ip2hex(String ipAddress) {
        StringBuilder result = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(ipAddress, ".");
        while (tokenizer.hasMoreTokens()) {
            String hexByte = Integer.toHexString(Integer.parseInt(tokenizer.nextToken()));
            if (hexByte.length() == 1) {
                hexByte = String.valueOf('0') + hexByte;
            }
            result.append(hexByte);
        }
        return result.toString();
    }

    public FrameContentFilter(BPFFilter.Proto protocol, int offset, String hexValue) {
        super(protocol);
        this.offset = offset;
        this.hexValue = hexValue;
    }

    public String toString() {
        return String.format("%s[%d:%d]=0x%s", this.getProtocol().toString(), this.offset, this.hexValue.length() / 2, this.hexValue);
    }

    @Override
    protected boolean excludesBPFFilterImpl(Filter filter) {
        if (filter instanceof FrameContentFilter) {
            FrameContentFilter rhs = (FrameContentFilter)filter;
            if (this.offset != rhs.offset) {
                return false;
            }
            return !this.hexValue.equals(rhs.hexValue);
        }
        return false;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

