/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters;

import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;

public final class IPAddressFilter
extends BPFFilter {
    private String address;

    public static IPAddressFilter createIPv4SourceFilter(String address) {
        return new IPAddressFilter(BPFFilter.Proto.IPv4, BPFFilter.Dir.SRC, address);
    }

    public static IPAddressFilter createIPv4DestinationFilter(String address) {
        return new IPAddressFilter(BPFFilter.Proto.IPv4, BPFFilter.Dir.DST, address);
    }

    public static IPAddressFilter createIPv6SourceFilter(String address) {
        return new IPAddressFilter(BPFFilter.Proto.IPv6, BPFFilter.Dir.SRC, address);
    }

    public static IPAddressFilter createIPv6DestinationFilter(String address) {
        return new IPAddressFilter(BPFFilter.Proto.IPv6, BPFFilter.Dir.DST, address);
    }

    private IPAddressFilter(BPFFilter.Proto l3Protocol, BPFFilter.Dir direction, String address) {
        super(l3Protocol, direction);
        this.address = address;
    }

    public String toString() {
        return String.format("%s %s %s", this.getProtocol().toString(), this.getDirection().toString(), this.address);
    }

    @Override
    protected boolean excludesBPFFilterImpl(Filter filter) {
        if (filter instanceof IPAddressFilter) {
            IPAddressFilter rhs = (IPAddressFilter)filter;
            return !this.address.equals(rhs.address);
        }
        return false;
    }
}

