/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters.core;

import com.excentis.products.byteblower.run.filters.core.Expression;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.run.filters.core.Leaf;
import com.excentis.products.byteblower.run.filters.core.NotExpression;

abstract class BinaryExpression
extends Expression {
    private Filter left;
    private Filter right;

    protected BinaryExpression(Expression.Type type, Filter left, Filter right) {
        super(type);
        this.left = left;
        this.right = right;
    }

    public Filter min() {
        if (this.left.compareTo(this.right) <= 0) {
            return this.left;
        }
        return this.right;
    }

    public Filter max() {
        if (this.left.compareTo(this.right) <= 0) {
            return this.right;
        }
        return this.left;
    }

    public Filter setLeft(Filter filter) {
        Filter prev = this.left;
        this.left = filter;
        return prev;
    }

    public Filter getLeft() {
        return this.left;
    }

    public Filter setRight(Filter filter) {
        Filter prev = this.right;
        this.right = filter;
        return prev;
    }

    public Filter getRight() {
        return this.right;
    }

    @Override
    protected int compareImpl(Filter filter) {
        if (filter instanceof Leaf) {
            return -1 * filter.compareTo(this);
        }
        if (filter instanceof NotExpression) {
            return -1 * filter.compareTo(this);
        }
        if (filter instanceof BinaryExpression) {
            BinaryExpression rhs = (BinaryExpression)filter;
            int r = this.min().compareTo(rhs.min());
            if (r != 0) {
                return r;
            }
            return this.max().compareTo(rhs.max());
        }
        throw new IllegalStateException();
    }

    public String toString() {
        String leftString = this.left.toString();
        if (!this.getClass().equals(this.left.getClass()) && this.left instanceof BinaryExpression) {
            leftString = BinaryExpression.group(leftString);
        }
        String rightString = this.right.toString();
        if (!this.getClass().equals(this.right.getClass()) && this.right instanceof BinaryExpression) {
            rightString = BinaryExpression.group(rightString);
        }
        return BinaryExpression.join(leftString, this.getKeyword(), rightString);
    }
}

