/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters.core;

import com.excentis.products.byteblower.run.filters.core.AndExpression;
import com.excentis.products.byteblower.run.filters.core.NotExpression;
import com.excentis.products.byteblower.run.filters.core.OrExpression;

public abstract class Filter
implements Comparable<Filter>,
Cloneable {
    @Override
    public final int compareTo(Filter filter) {
        return this.compareImpl(filter);
    }

    public boolean equals(Object other) {
        if (other instanceof Filter) {
            Filter rhs = (Filter)other;
            return this.compareTo(rhs) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public final boolean excludes(Filter filter) {
        return this.excludesImpl(filter);
    }

    public static Filter and(Filter left, Filter right) {
        return new AndExpression(left, right);
    }

    public static Filter and(Filter ... filters) {
        Filter result = filters[0];
        int i = 1;
        while (i < filters.length) {
            result = Filter.and(result, filters[i]);
            ++i;
        }
        return result;
    }

    public static Filter or(Filter left, Filter right) {
        return new OrExpression(left, right);
    }

    public static Filter or(Filter ... filters) {
        Filter result = filters[0];
        int i = 1;
        while (i < filters.length) {
            result = Filter.or(result, filters[i]);
            ++i;
        }
        return result;
    }

    public static Filter not(Filter filter) {
        return new NotExpression(filter);
    }

    public static boolean overlap(Filter lhs, Filter rhs) {
        return !lhs.excludes(rhs);
    }

    protected abstract int compareImpl(Filter var1);

    protected abstract boolean excludesImpl(Filter var1);

    public Filter clone() throws CloneNotSupportedException {
        return (Filter)super.clone();
    }
}

