/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters.test;

import com.excentis.products.byteblower.run.actions.ImproveFilters;
import com.excentis.products.byteblower.run.filters.ARPOperationFilter;
import com.excentis.products.byteblower.run.filters.ARPSenderProtocolAddressFilter;
import com.excentis.products.byteblower.run.filters.ARPTargetProtocolAddressFilter;
import com.excentis.products.byteblower.run.filters.FrameLengthFilter;
import com.excentis.products.byteblower.run.filters.IPAddressFilter;
import com.excentis.products.byteblower.run.filters.IPv4TotalLengthFilter;
import com.excentis.products.byteblower.run.filters.PortNumberFilter;
import com.excentis.products.byteblower.run.filters.ProtocolFilter;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.utils.Interval;
import com.excentis.products.byteblower.utils.SubSetIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FilterTest {
    @Test
    public void testSubSetIterator() {
        SubSetIterator it = new SubSetIterator(new Interval(Integer.valueOf(0), Integer.valueOf(9)), 3);
        Assert.assertTrue((boolean)it.getValues().toString().equals("[0, 1, 2]"));
        while (it.hasNext()) {
            it.next();
        }
        Assert.assertTrue((boolean)it.getValues().toString().equals("[7, 8, 9]"));
    }

    @Test
    public void testFindIndentifyingSubSet() {
        byte[] byArray = new byte[10];
        byArray[0] = 1;
        byte[] buffer0 = byArray;
        byte[] byArray2 = new byte[10];
        byArray2[0] = 1;
        byArray2[2] = 1;
        byte[] buffer1 = byArray2;
        byte[] byArray3 = new byte[10];
        byArray3[0] = 1;
        byArray3[9] = 1;
        byte[] buffer2 = byArray3;
        byte[] byArray4 = new byte[10];
        byArray4[2] = 1;
        byte[] buffer3 = byArray4;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        buffers.add(ByteBuffer.wrap(buffer0));
        buffers.add(ByteBuffer.wrap(buffer1));
        buffers.add(ByteBuffer.wrap(buffer2));
        buffers.add(ByteBuffer.wrap(buffer3));
        Assert.assertTrue((ImproveFilters.findIndentifyingSubSet(buffers, 1, 2000L) == null ? 1 : 0) != 0);
        Assert.assertTrue((ImproveFilters.findIndentifyingSubSet(buffers, 2, 2000L) == null ? 1 : 0) != 0);
        List<Integer> indexes = ImproveFilters.findIndentifyingSubSet(buffers, 3, 2000L);
        Assert.assertTrue((indexes.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((indexes.get(0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((indexes.get(1) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((indexes.get(2) == 9 ? 1 : 0) != 0);
    }

    @Test
    public void testJumboFrame() {
        byte[] buffer0 = new byte[10000];
        buffer0[9999] = 0;
        byte[] buffer1 = new byte[10000];
        buffer1[9999] = 1;
        byte[] buffer2 = new byte[10000];
        buffer2[9999] = 2;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        buffers.add(ByteBuffer.wrap(buffer0));
        buffers.add(ByteBuffer.wrap(buffer1));
        buffers.add(ByteBuffer.wrap(buffer2));
        List<Integer> indexes = ImproveFilters.findIndentifyingSubSet(buffers, 1, 10000L);
        Assert.assertTrue((indexes.get(0) == 9999 ? 1 : 0) != 0);
    }

    @Test
    public void testTimeout() {
        byte[] buffer0 = new byte[1000];
        buffer0[800] = 1;
        buffer0[900] = 0;
        buffer0[999] = 0;
        byte[] buffer1 = new byte[1000];
        buffer1[800] = 1;
        buffer1[900] = 1;
        buffer1[999] = 0;
        byte[] buffer2 = new byte[1000];
        buffer2[800] = 1;
        buffer2[900] = 0;
        buffer2[999] = 1;
        byte[] buffer3 = new byte[1000];
        buffer3[800] = 0;
        buffer3[900] = 1;
        buffer3[999] = 0;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        buffers.add(ByteBuffer.wrap(buffer0));
        buffers.add(ByteBuffer.wrap(buffer1));
        buffers.add(ByteBuffer.wrap(buffer2));
        buffers.add(ByteBuffer.wrap(buffer3));
        long startTime = System.currentTimeMillis();
        List<Integer> indexes = ImproveFilters.findIndentifyingSubSet(buffers, 3, 1000L);
        Assert.assertTrue((indexes == null ? 1 : 0) != 0);
        long duration = System.currentTimeMillis() - startTime;
        Assert.assertTrue((duration >= 1000L && duration < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testProtocolFilter() {
        ProtocolFilter ipv4 = new ProtocolFilter(BPFFilter.Proto.IPv4);
        ProtocolFilter ipv6 = new ProtocolFilter(BPFFilter.Proto.IPv6);
        Assert.assertTrue((boolean)Filter.overlap(ipv4, new ProtocolFilter(BPFFilter.Proto.IPv4)));
        Assert.assertTrue((boolean)Filter.overlap(ipv6, new ProtocolFilter(BPFFilter.Proto.IPv6)));
        Assert.assertFalse((boolean)Filter.overlap(ipv4, ipv6));
    }

    @Test
    public void testIPSrcAndDstFilters() {
        Assert.assertTrue((boolean)IPAddressFilter.createIPv4SourceFilter("1.2.3.4").toString().equals("ip src 1.2.3.4"));
        Assert.assertTrue((boolean)IPAddressFilter.createIPv4DestinationFilter("1.2.3.4").toString().equals("ip dst 1.2.3.4"));
        Assert.assertTrue((boolean)Filter.overlap(IPAddressFilter.createIPv4SourceFilter("10.0.0.1"), IPAddressFilter.createIPv4SourceFilter("10.0.0.1")));
        Assert.assertFalse((boolean)Filter.overlap(IPAddressFilter.createIPv4SourceFilter("10.0.0.1"), IPAddressFilter.createIPv4SourceFilter("10.0.0.2")));
        Assert.assertTrue((boolean)Filter.overlap(IPAddressFilter.createIPv4DestinationFilter("10.0.0.1"), IPAddressFilter.createIPv4DestinationFilter("10.0.0.1")));
        Assert.assertFalse((boolean)Filter.overlap(IPAddressFilter.createIPv4DestinationFilter("10.0.0.1"), IPAddressFilter.createIPv4DestinationFilter("10.0.0.2")));
        Assert.assertTrue((boolean)Filter.overlap(IPAddressFilter.createIPv4SourceFilter("10.0.0.1"), IPAddressFilter.createIPv4DestinationFilter("10.0.0.2")));
    }

    @Test
    public void testIPHeaderLength() {
        Assert.assertTrue((boolean)IPv4TotalLengthFilter.createIPv4TotalLengthFilter(60).toString().equals("ip[2:2]=0x003c"));
        Assert.assertTrue((boolean)IPv4TotalLengthFilter.createIPv4TotalLengthFilter(905).toString().equals("ip[2:2]=0x0389"));
        Assert.assertTrue((boolean)Filter.overlap(IPv4TotalLengthFilter.createIPv4TotalLengthFilter(400), IPv4TotalLengthFilter.createIPv4TotalLengthFilter(400)));
        Assert.assertFalse((boolean)Filter.overlap(IPv4TotalLengthFilter.createIPv4TotalLengthFilter(400), IPv4TotalLengthFilter.createIPv4TotalLengthFilter(401)));
        Assert.assertTrue((boolean)Filter.overlap(IPv4TotalLengthFilter.createIPv4TotalLengthFilter(400), IPAddressFilter.createIPv4SourceFilter("1.2.3.4")));
        Assert.assertTrue((boolean)Filter.overlap(IPv4TotalLengthFilter.createIPv4TotalLengthFilter(400), PortNumberFilter.createTCPDestinationPortFilter(2)));
        Assert.assertFalse((boolean)Filter.overlap(IPv4TotalLengthFilter.createIPv4TotalLengthFilter(400), ARPOperationFilter.createARPReplyFilter()));
    }

    @Test
    public void testTCPAndUDPFilters() {
        Assert.assertTrue((boolean)PortNumberFilter.createUDPSourcePortFilter(1000).toString().equals("udp src port 1000"));
        Assert.assertTrue((boolean)PortNumberFilter.createUDPDestinationPortFilter(1000).toString().equals("udp dst port 1000"));
        Assert.assertTrue((boolean)PortNumberFilter.createTCPSourcePortFilter(1000).toString().equals("tcp src port 1000"));
        Assert.assertTrue((boolean)PortNumberFilter.createTCPDestinationPortFilter(1000).toString().equals("tcp dst port 1000"));
        Assert.assertTrue((boolean)Filter.overlap(PortNumberFilter.createUDPSourcePortFilter(1000), PortNumberFilter.createUDPSourcePortFilter(1000)));
        Assert.assertFalse((boolean)Filter.overlap(PortNumberFilter.createTCPSourcePortFilter(1000), PortNumberFilter.createTCPSourcePortFilter(2000)));
        Assert.assertFalse((boolean)Filter.overlap(PortNumberFilter.createUDPSourcePortFilter(1000), PortNumberFilter.createTCPSourcePortFilter(1000)));
        Assert.assertFalse((boolean)Filter.overlap(PortNumberFilter.createUDPSourcePortFilter(1000), PortNumberFilter.createTCPSourcePortFilter(2000)));
        Assert.assertFalse((boolean)Filter.overlap(Filter.and((Filter)PortNumberFilter.createUDPSourcePortFilter(1000), (Filter)PortNumberFilter.createUDPDestinationPortFilter(2000)), PortNumberFilter.createUDPSourcePortFilter(1001)));
        Assert.assertTrue((boolean)Filter.overlap(Filter.or((Filter)PortNumberFilter.createUDPSourcePortFilter(1), (Filter)PortNumberFilter.createUDPDestinationPortFilter(2)), PortNumberFilter.createUDPSourcePortFilter(1)));
        Assert.assertFalse((boolean)Filter.overlap(Filter.or((Filter)PortNumberFilter.createUDPSourcePortFilter(1), (Filter)PortNumberFilter.createUDPSourcePortFilter(2)), PortNumberFilter.createUDPSourcePortFilter(3)));
        Assert.assertFalse((boolean)Filter.overlap(PortNumberFilter.createTCPSourcePortFilter(1001), Filter.and((Filter)PortNumberFilter.createTCPSourcePortFilter(1000), (Filter)PortNumberFilter.createTCPDestinationPortFilter(2000))));
        Assert.assertFalse((boolean)Filter.overlap(Filter.and((Filter)PortNumberFilter.createUDPSourcePortFilter(1000), (Filter)PortNumberFilter.createUDPDestinationPortFilter(1000)), Filter.and((Filter)PortNumberFilter.createUDPSourcePortFilter(1001), (Filter)PortNumberFilter.createUDPDestinationPortFilter(1001))));
        Assert.assertFalse((boolean)Filter.overlap(PortNumberFilter.createUDPSourcePortFilter(1000), Filter.not(PortNumberFilter.createUDPSourcePortFilter(1000))));
        Assert.assertFalse((boolean)Filter.overlap(Filter.and((Filter)PortNumberFilter.createUDPSourcePortFilter(1000), (Filter)PortNumberFilter.createUDPDestinationPortFilter(1000)), Filter.and((Filter)PortNumberFilter.createUDPSourcePortFilter(1000), Filter.not(PortNumberFilter.createUDPDestinationPortFilter(1000)))));
        Assert.assertTrue((boolean)Filter.overlap(Filter.and((Filter)PortNumberFilter.createUDPSourcePortFilter(1000), (Filter)PortNumberFilter.createUDPDestinationPortFilter(1000)), Filter.or(Filter.and((Filter)PortNumberFilter.createUDPSourcePortFilter(1001), (Filter)PortNumberFilter.createUDPDestinationPortFilter(1001)), (Filter)IPAddressFilter.createIPv4DestinationFilter("10.0.0.1"))));
    }

    @Test
    public void testARPFilter() {
        Assert.assertTrue((boolean)ARPOperationFilter.createARPRequestFilter().toString().equals("arp[6:2]=0x0001"));
        Assert.assertTrue((boolean)Filter.overlap(ARPOperationFilter.createARPRequestFilter(), ARPOperationFilter.createARPRequestFilter()));
        Assert.assertTrue((boolean)ARPOperationFilter.createARPReplyFilter().toString().equals("arp[6:2]=0x0002"));
        Assert.assertFalse((boolean)Filter.overlap(ARPOperationFilter.createARPRequestFilter(), ARPOperationFilter.createARPReplyFilter()));
        Assert.assertTrue((boolean)ARPSenderProtocolAddressFilter.createARPSPAFilter("24.166.172.1").toString().equals("arp[14:4]=0x18a6ac01"));
        Assert.assertFalse((boolean)ARPSenderProtocolAddressFilter.createARPSPAFilter("10.0.0.1").excludes(ARPSenderProtocolAddressFilter.createARPSPAFilter("10.0.0.1")));
        Assert.assertTrue((boolean)ARPSenderProtocolAddressFilter.createARPSPAFilter("10.0.0.1").excludes(ARPSenderProtocolAddressFilter.createARPSPAFilter("10.0.0.2")));
        Assert.assertTrue((boolean)ARPTargetProtocolAddressFilter.createARPTPAFilter("24.166.172.1").toString().equals("arp[24:4]=0x18a6ac01"));
        Assert.assertFalse((boolean)ARPTargetProtocolAddressFilter.createARPTPAFilter("10.0.0.1").excludes(ARPTargetProtocolAddressFilter.createARPTPAFilter("10.0.0.1")));
        Assert.assertTrue((boolean)ARPTargetProtocolAddressFilter.createARPTPAFilter("10.0.0.1").excludes(ARPTargetProtocolAddressFilter.createARPTPAFilter("10.0.0.2")));
        Assert.assertFalse((boolean)ARPSenderProtocolAddressFilter.createARPSPAFilter("10.0.0.1").excludes(ARPTargetProtocolAddressFilter.createARPTPAFilter("10.0.0.2")));
        Assert.assertFalse((boolean)ARPTargetProtocolAddressFilter.createARPTPAFilter("10.0.0.1").excludes(ARPSenderProtocolAddressFilter.createARPSPAFilter("10.0.0.2")));
        Assert.assertFalse((boolean)Filter.overlap(ARPOperationFilter.createARPRequestFilter(), IPAddressFilter.createIPv4DestinationFilter("10.0.0.1")));
        Assert.assertFalse((boolean)Filter.overlap(ARPOperationFilter.createARPReplyFilter(), IPAddressFilter.createIPv6DestinationFilter("10.0.0.1")));
        Assert.assertFalse((boolean)Filter.overlap(ARPSenderProtocolAddressFilter.createARPSPAFilter("24.166.172.1"), PortNumberFilter.createUDPDestinationPortFilter(2000)));
        Assert.assertFalse((boolean)Filter.overlap(ARPTargetProtocolAddressFilter.createARPTPAFilter("24.166.172.1"), PortNumberFilter.createTCPSourcePortFilter(2000)));
    }

    @Test
    public void testFrameLengthFilter() {
        Assert.assertTrue((boolean)FrameLengthFilter.createLengthBetweenFilter(100, 200).toString().equals("len >= 100 and len <= 200"));
        Assert.assertTrue((boolean)FrameLengthFilter.createLengthLessThanOrEqualToFilter(100).toString().equals("len <= 100"));
        Assert.assertTrue((boolean)FrameLengthFilter.createLengthGreaterThanOrEqualToFilter(100).toString().equals("len >= 100"));
        Assert.assertTrue((boolean)Filter.overlap(FrameLengthFilter.createLengthLessThanOrEqualToFilter(100), FrameLengthFilter.createLengthLessThanOrEqualToFilter(200)));
        Assert.assertTrue((boolean)Filter.overlap(FrameLengthFilter.createLengthGreaterThanOrEqualToFilter(100), FrameLengthFilter.createLengthLessThanOrEqualToFilter(200)));
        Assert.assertFalse((boolean)Filter.overlap(FrameLengthFilter.createLengthLessThanOrEqualToFilter(100), FrameLengthFilter.createLengthGreaterThanOrEqualToFilter(200)));
        Assert.assertTrue((boolean)Filter.overlap(FrameLengthFilter.createLengthBetweenFilter(100, 300), FrameLengthFilter.createLengthBetweenFilter(200, 400)));
        Assert.assertTrue((boolean)Filter.overlap(FrameLengthFilter.createLengthBetweenFilter(100, 200), FrameLengthFilter.createLengthBetweenFilter(125, 175)));
        Assert.assertFalse((boolean)Filter.overlap(FrameLengthFilter.createLengthBetweenFilter(100, 300), FrameLengthFilter.createLengthGreaterThanOrEqualToFilter(400)));
        Assert.assertTrue((boolean)Filter.overlap(IPAddressFilter.createIPv4SourceFilter("1.2.3.4"), FrameLengthFilter.createLengthBetweenFilter(100, 200)));
    }
}

