/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects.RFC2544;

import com.excentis.products.byteblower.communication.api.Frame;
import com.excentis.products.byteblower.communication.api.Stream;
import com.excentis.products.byteblower.communication.api.StreamRuntimeStatus;
import com.excentis.products.byteblower.run.objects.RFC2544.StreamAlgo;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public class BBStreamAlgo
implements StreamAlgo {
    private final RuntimePort source;
    private final long iterationDuration;
    private final String packetData;
    private Stream stream;
    private long started = -1L;
    private long byteCount;
    private long packetCount;
    private boolean isOK = true;

    public BBStreamAlgo(RuntimePort source, long iterationDuration, RuntimeFrameTx outgoing) {
        this.source = source;
        this.iterationDuration = iterationDuration;
        this.packetData = outgoing.getByteHexString();
        this.stream = null;
    }

    @Override
    public void prepare(long ifg) {
        Stream apiStream;
        this.packetCount = this.iterationDuration / ifg;
        this.stream = apiStream = this.source.getApiPort().TxStreamAdd();
        apiStream.InterFrameGapSet(ifg);
        apiStream.NumberOfFramesSet(this.packetCount);
        Frame frame = apiStream.FrameAdd();
        frame.BytesSet(this.packetData);
        this.byteCount = this.packetCount * (long)(this.packetData.length() / 2);
    }

    @Override
    public void start() {
        this.started = System.nanoTime();
        this.stream.Start();
    }

    @Override
    public boolean isDone() {
        boolean timeOk;
        this.isOK = this.stream.StatusGet().ErrorStatusGet() == StreamRuntimeStatus.transmit_error_status.NONE;
        boolean bl = timeOk = this.started + this.iterationDuration + 2000000000L < System.nanoTime();
        return timeOk || !this.isOK;
    }

    @Override
    public long bytes() {
        return this.byteCount;
    }

    @Override
    public long packets() {
        return this.packetCount;
    }

    @Override
    public void cleanup() {
        if (this.stream != null) {
            this.stream.Stop();
            this.stream.PortGet().TxStreamRemove(this.stream);
            this.stream = null;
        }
    }

    @Override
    public long packetSize() {
        return this.packetData.length() / 2;
    }

    @Override
    public boolean isOk() {
        return this.isOK;
    }
}

