/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects.RFC2544;

import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.ResponseTimeout;
import com.excentis.products.byteblower.communication.api.TriggerBasicMobile;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultData;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultDataList;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultHistory;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.objects.RFC2544.TestResult;
import com.excentis.products.byteblower.run.objects.RFC2544.TriggerAlgo;
import com.excentis.products.byteblower.run.objects.RuntimeFrameRx;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MobileTriggerAlgo
implements TriggerAlgo {
    private static final Logger LOGGER = Logger.getGlobal();
    private final RuntimeMobileDevice dest;
    private TriggerBasicMobile trigger;
    private final long iterationDuration;
    private final RuntimeFrameRx rxFrame;

    public MobileTriggerAlgo(RuntimePort dest, RuntimeFrameRx rx, long iterationDuration) {
        this.dest = (RuntimeMobileDevice)dest;
        this.iterationDuration = iterationDuration;
        this.rxFrame = rx;
    }

    private void waitUntilWepReadyForTraffic() {
        long maxWaitTime = TimeUnit.SECONDS.toMillis(30L);
        long startMoment = System.currentTimeMillis();
        DeviceStatus wepState = this.dest.getMobilePort().StatusGet();
        while (wepState != DeviceStatus.Reserved && System.currentTimeMillis() - startMoment < maxWaitTime) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.INFO, "RFC2544 Wait being interrupted");
                Thread.currentThread().interrupt();
            }
            wepState = this.dest.getMobilePort().StatusGet();
        }
        if (wepState != DeviceStatus.Reserved) {
            float secondsWaited = (float)(System.currentTimeMillis() - startMoment) / 1000.0f;
            String msg = String.format("Endpoint is not ready for receiving traffic. Waited for %.2f seconds, WEP still in state=%s", Float.valueOf(secondsWaited), wepState);
            LOGGER.warning(msg);
        } else {
            LOGGER.log(Level.INFO, "Endpoint is ready to receive traffic, state={0}", wepState);
        }
    }

    @Override
    public void start() {
        this.waitUntilWepReadyForTraffic();
        this.trigger = this.dest.getMobilePort().RxTriggerBasicAdd();
        String ipv4Src = this.rxFrame.getSourceIpAddress();
        UDPPacket udp = (UDPPacket)this.rxFrame.getLayer(BPFFilter.Proto.UDP);
        int udpSrc = udp.getSource();
        int udpDest = udp.getDestination();
        this.trigger.FilterUdpDestinationPortSet(udpDest);
        this.trigger.FilterUdpSourcePortSet(udpSrc);
        this.trigger.FilterSourceAddressSet(ipv4Src);
        assert (this.iterationDuration > -5000000000L);
        this.trigger.DurationSet(this.iterationDuration + 5000000000L);
        LOGGER.info(() -> String.format("RFC2544 Rx WEP (status=%s) for %f seconds", this.dest.getMobilePort().StatusGet(), (double)this.trigger.DurationGet() / 1.0E9));
        this.dest.getMobilePort().Prepare();
        long startmoment = this.dest.getMobilePort().Start();
        LOGGER.log(Level.INFO, "Starting WEP trigger in {0} seconds", (double)(startmoment - this.dest.getMobilePort().MeetingPointGet().TimestampGet()) / 1.0E9);
        while (this.dest.getMobilePort().StatusGet() != DeviceStatus.Running && this.dest.getMobilePort().StatusGet() != DeviceStatus.Starting) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.INFO, "RFC2544 Wait being interrupted");
                Thread.currentThread().interrupt();
            }
        }
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.INFO, "RFC2544 Wait being interrupted");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public TestResult calcResult(long ifg, long packetSize, long txPackets, long txBytes) {
        TriggerBasicResultData rxSnap;
        long durationNanosecond = 1L;
        long rxBytes = 0L;
        long rxPackets = 0L;
        this.getWEPResults();
        TriggerBasicResultHistory rxHistory = this.trigger.ResultHistoryGet();
        rxHistory.Refresh();
        TriggerBasicResultDataList rxCumul = rxHistory.CumulativeGet();
        if (!rxCumul.isEmpty() && (rxSnap = rxCumul.get(rxCumul.size() - 1)).PacketCountGet() > 1L) {
            durationNanosecond = rxSnap.TimestampLastGet() - rxSnap.TimestampFirstGet();
            rxBytes = rxSnap.ByteCountGet();
            rxPackets = rxSnap.PacketCountGet();
        }
        return new TestResult(ifg, txBytes, rxBytes, durationNanosecond, txPackets, rxPackets, packetSize);
    }

    private void getWEPResults() {
        try {
            this.dest.getMobilePort().ResultGet();
        }
        catch (ResponseTimeout responseTimeout) {
            LOGGER.warning("Retry collecting results from WEP (RFC2544)");
            this.dest.getMobilePort().ResultGet();
        }
    }

    @Override
    public void cleanup() {
        if (this.trigger != null) {
            this.dest.getMobilePort().RxTriggerBasicRemove(this.trigger);
            this.trigger = null;
        }
    }

    @Override
    public boolean isDone() {
        DeviceStatus current = this.dest.getMobilePort().StatusGet();
        return current != DeviceStatus.Running && current != DeviceStatus.Starting;
    }
}

