/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.HTTPClient;
import com.excentis.products.byteblower.communication.api.HTTPRequestMethod;
import com.excentis.products.byteblower.communication.api.HTTPRequestStatus;
import com.excentis.products.byteblower.communication.api.HTTPResultData;
import com.excentis.products.byteblower.communication.api.HTTPResultHistory;
import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.communication.api.TCPResultHistory;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.utils.LocalHttpResultData;
import com.excentis.products.byteblower.run.utils.LocalTcpResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class RuntimeBBHttpClient
extends RuntimeHttpClient {
    private HTTPClient apiHttpClient;
    private final List<RuntimeHttpClient.RestartEvent> restartEvents;
    private final RestartConfig restartConfig;
    private final FlowTracker tracker;
    private static final long RESTART_INTERVAL = 20000L;
    private LocalHttpResultData cumulHttp;
    private LocalTcpResultData cumulTcp;
    private boolean firstRefresh = true;
    private Object lastRefreshKey = RefreshableSet.notRefreshedYet();

    RuntimeBBHttpClient(RuntimePort rtPort, HTTPClient apiHttpClient, RuntimeHttpFlow rtHttpFlow) {
        super(rtPort, rtHttpFlow);
        this.apiHttpClient = apiHttpClient;
        this.restartEvents = new ArrayList<RuntimeHttpClient.RestartEvent>();
        this.restartConfig = apiHttpClient.RequestSizeGet() == 0L ? new RestartDuration(apiHttpClient) : new RestartSize(apiHttpClient);
        this.tracker = new FlowTracker();
        this.cumulHttp = new LocalHttpResultData();
        this.cumulTcp = new LocalTcpResultData();
    }

    private HTTPClient getApiHttpClient() {
        return this.apiHttpClient;
    }

    @Override
    public int getApiLocalPortNumber() {
        return this.getApiHttpClient().LocalPortGet();
    }

    @Override
    public String getServerClientId() {
        return this.apiHttpClient.ServerClientIdGet();
    }

    @Override
    public List<RuntimeHttpClient.RestartEvent> restarts() {
        ArrayList<RuntimeHttpClient.RestartEvent> res = new ArrayList<RuntimeHttpClient.RestartEvent>(this.restartEvents);
        this.restartEvents.clear();
        return res;
    }

    @Override
    public boolean isFinished() {
        HTTPRequestStatus status = this.apiHttpClient.RequestStatusGet();
        boolean apisays = HTTPRequestStatus.Finished.equals(status);
        boolean cangiveup = this.restartConfig.canGiveUp();
        boolean result = apisays || cangiveup;
        return result;
    }

    private void doRestart(String reason) {
        boolean shouldRestart = this.getRuntimeScenario().isTCPRestart();
        if (!shouldRestart) {
            return;
        }
        this.tracker.stillGood();
        this.cumulHttp = this.getCumulativeHTTPResultData();
        this.cumulTcp = this.getCumulativeTcpResultData();
        this.restartEvents.add(this.tracker.getEvent(reason));
        this.apiHttpClient.RequestStop();
        HTTPClient newHttpClient = this.rtPort.getApiPort().ProtocolHttpClientAdd();
        newHttpClient.RemoteAddressSet(this.apiHttpClient.RemoteAddressGet());
        newHttpClient.RemotePortSet(this.apiHttpClient.RemotePortGet());
        this.restartConfig.configureRestart(newHttpClient);
        newHttpClient.MaximumSegmentSizeSet(this.apiHttpClient.MaximumSegmentSizeGet());
        newHttpClient.ReceiveWindowInitialSizeSet(this.apiHttpClient.ReceiveWindowInitialSizeGet());
        newHttpClient.ReceiveWindowScalingEnable(this.apiHttpClient.ReceiveWindowScalingIsEnabled());
        newHttpClient.ReceiveWindowScalingValueSet(this.apiHttpClient.ReceiveWindowScalingValueGet());
        newHttpClient.TcpCongestionAvoidanceAlgorithmSet(this.apiHttpClient.TcpCongestionAvoidanceAlgorithmGet());
        try {
            newHttpClient.TcpPragueEnable(this.apiHttpClient.TcpPragueIsEnabled());
        }
        catch (Exception exception) {}
        newHttpClient.TypeOfServiceSet(this.apiHttpClient.TypeOfServiceGet());
        newHttpClient.SlowStartThresholdSet(this.apiHttpClient.SlowStartThresholdGet());
        newHttpClient.FlowLabelSet(this.apiHttpClient.FlowLabelGet());
        newHttpClient.RequestRateLimitSet(this.apiHttpClient.RequestRateLimitGet());
        newHttpClient.HttpMethodSet(this.apiHttpClient.HttpMethodGet());
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        newHttpClient.RequestStart();
        this.apiHttpClient = newHttpClient;
    }

    @Override
    public HTTPRequestMethod getRequestedMethod() {
        return this.apiHttpClient.HttpMethodGet();
    }

    @Override
    public HTTPRequestStatus RequestStatusGet() {
        return this.apiHttpClient.RequestStatusGet();
    }

    @Override
    public HTTPSessionInfo getHTTPSessionInfo() {
        return this.apiHttpClient.HttpSessionInfoGet();
    }

    @Override
    public boolean hasSession() {
        boolean result = this.apiHttpClient.HasSession();
        return result;
    }

    @Override
    public LocalHttpResultData getCumulativeHTTPResultData() {
        return super.getCumulativeHTTPResultData().add(this.cumulHttp);
    }

    @Override
    public LocalTcpResultData getCumulativeTcpResultData() {
        return super.getCumulativeTcpResultData().add(this.cumulTcp);
    }

    @Override
    public void resultsToRefresh(RefreshableSet toRefresh) {
        if (toRefresh.isSameCycle(this.lastRefreshKey)) {
            return;
        }
        boolean doRefreshResults = true;
        this.restartConfig.track(this.apiHttpClient);
        boolean shouldRestart = this.getRuntimeScenario().isTCPRestart();
        if (shouldRestart && this.tracker.shouldRestart(this.apiHttpClient)) {
            String reason = HTTPRequestStatus.Connecting.equals(this.RequestStatusGet()) ? "Failed to connect." : "Stalled TCP flow detected.";
            this.doRestart(reason);
            doRefreshResults = false;
        }
        if (doRefreshResults && this.hasSession()) {
            HTTPSessionInfo clientSession = this.getHTTPSessionInfo();
            this.fillRefreshableResults(clientSession, toRefresh);
        }
    }

    private void fillRefreshableResults(HTTPSessionInfo session, RefreshableSet toRefresh) {
        HTTPResultHistory httpHistory = session.ResultHistoryGet();
        TCPResultHistory tcpHistory = session.TcpSessionInfoGet().ResultHistoryGet();
        if (!this.firstRefresh) {
            httpHistory.Clear();
            tcpHistory.Clear();
        }
        this.firstRefresh = false;
        this.lastRefreshKey = toRefresh.add(new AbstractRefreshableResult[]{httpHistory, tcpHistory});
    }

    private static class FlowTracker {
        long bytes;
        long duration;
        long lastGoodMoment = 0L;
        String clientId = "";

        private FlowTracker() {
        }

        private void stillGood() {
            this.lastGoodMoment = System.currentTimeMillis();
        }

        private void track(HTTPClient apiHttpClient) {
            HTTPRequestStatus status = apiHttpClient.RequestStatusGet();
            this.clientId = apiHttpClient.ServerClientIdGet();
            if (this.lastGoodMoment == 0L) {
                this.stillGood();
            }
            if (HTTPRequestStatus.Scheduled.equals(status) || HTTPRequestStatus.Configuration.equals(status) || HTTPRequestStatus.Finished.equals(status)) {
                this.stillGood();
            }
            long oldTrafficCount = this.bytes;
            if (apiHttpClient.HasSession() && apiHttpClient.ResultHistoryGet().CumulativeLengthGet() > 0L) {
                HTTPResultData last = apiHttpClient.ResultHistoryGet().CumulativeLatestGet();
                this.bytes = Math.max(last.RxByteCountTotalGet(), last.TxByteCountTotalGet());
                long firstPacket = Long.MAX_VALUE;
                long mostRecentPacket = 0L;
                if (last.RxByteCountTotalGet() > 0L) {
                    firstPacket = Math.min(firstPacket, last.RxTimestampFirstGet());
                    mostRecentPacket = Math.max(mostRecentPacket, last.RxTimestampLastGet());
                }
                if (last.TxByteCountTotalGet() > 0L) {
                    firstPacket = Math.min(firstPacket, last.TxTimestampFirstGet());
                    mostRecentPacket = Math.max(mostRecentPacket, last.TxTimestampLastGet());
                }
                if (mostRecentPacket > 0L && firstPacket < Long.MAX_VALUE) {
                    this.duration = mostRecentPacket - firstPacket;
                }
            }
            if (this.bytes > oldTrafficCount) {
                this.lastGoodMoment = System.currentTimeMillis();
            }
        }

        boolean shouldRestart(HTTPClient apiHttpClient) {
            this.track(apiHttpClient);
            return System.currentTimeMillis() - this.lastGoodMoment > 20000L;
        }

        RuntimeHttpClient.RestartEvent getEvent(String reason) {
            long oldBytes = this.bytes;
            long oldDuration = this.duration;
            this.bytes = 0L;
            this.duration = 0L;
            return new RuntimeHttpClient.RestartEvent(this.clientId, reason, oldDuration, oldBytes);
        }
    }

    private static interface RestartConfig {
        public void track(HTTPClient var1);

        public void configureRestart(HTTPClient var1);

        public boolean canGiveUp();
    }

    private class RestartDuration
    implements RestartConfig {
        private final long EXTRA_WAIT = TimeUnit.SECONDS.toMillis(2L);
        private final long configDuration;
        private long startMoment;

        public RestartDuration(HTTPClient client) {
            this.configDuration = client.RequestDurationGet();
            this.startMoment = 0L;
        }

        @Override
        public void track(HTTPClient apiHttpClient) {
            HTTPRequestStatus status = apiHttpClient.RequestStatusGet();
            if (HTTPRequestStatus.Scheduled.equals(status) || HTTPRequestStatus.Configuration.equals(status)) {
                return;
            }
            if (0L == this.startMoment) {
                this.startMoment = System.currentTimeMillis();
            }
        }

        @Override
        public void configureRestart(HTTPClient newHttpClient) {
            long duration = this.configDuration;
            if (0L != this.startMoment) {
                duration = Math.max(1L, this.configDuration - 1000000L * (System.currentTimeMillis() - this.startMoment));
            }
            newHttpClient.RequestDurationSet(duration);
        }

        @Override
        public boolean canGiveUp() {
            if (0L == this.startMoment) {
                return false;
            }
            long now = System.currentTimeMillis();
            return now - this.startMoment > TimeUnit.NANOSECONDS.toMillis(this.configDuration) + this.EXTRA_WAIT;
        }
    }

    private class RestartSize
    implements RestartConfig {
        private long configSize;
        private long remainingSize;

        public RestartSize(HTTPClient client) {
            this.remainingSize = this.configSize = client.RequestSizeGet();
        }

        @Override
        public void track(HTTPClient apiHttpClient) {
            if (apiHttpClient.HasSession() && apiHttpClient.ResultHistoryGet().CumulativeLengthGet() > 0L) {
                HTTPResultData last = apiHttpClient.ResultHistoryGet().CumulativeLatestGet();
                long current = Math.max(last.RxByteCountTotalGet(), last.TxByteCountTotalGet());
                this.remainingSize = this.configSize - current;
            }
        }

        @Override
        public void configureRestart(HTTPClient newHttpClient) {
            this.configSize = this.remainingSize;
            newHttpClient.RequestSizeSet(Math.max(this.remainingSize, 1000L));
        }

        @Override
        public boolean canGiveUp() {
            return false;
        }
    }
}

