/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.ByteBlower;
import com.excentis.products.byteblower.communication.api.ByteBlowerServer;
import com.excentis.products.byteblower.communication.api.MeetingPoint;
import com.excentis.products.byteblower.run.RuntimeScenarioRunner;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeMeetingPoint;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import com.excentis.products.byteblower.run.utils.DebugInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class RuntimeByteBlower
extends RuntimeObject {
    private static final Logger LOGGER = Logger.getGlobal();
    private final RuntimeScenarioRunner rtScenarioRunner;
    private final ByteBlower apiByteblower;
    private final List<RuntimeServer> rtServers = new ArrayList<RuntimeServer>();
    private final HashMap<String, RuntimeBBServer> addressedServers = new HashMap();
    private final HashMap<String, RuntimeMeetingPoint> addressedMeetingPoints = new HashMap();

    public RuntimeByteBlower(RuntimeScenarioRunner rtScenarioRunner, ByteBlower apiByteblower) {
        this.rtScenarioRunner = rtScenarioRunner;
        this.apiByteblower = apiByteblower;
        String versionText = String.format("Running version %s of the ByteBlower API", apiByteblower.APIVersionGet());
        LOGGER.info(versionText);
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.rtScenarioRunner.getRuntimeScenario();
    }

    public ByteBlower getApiByteBlower() {
        return this.apiByteblower;
    }

    public List<RuntimeBBServer> bbServers() {
        ArrayList<RuntimeBBServer> servers = new ArrayList<RuntimeBBServer>();
        for (RuntimeServer server : this.rtServers) {
            if (!(server instanceof RuntimeBBServer)) continue;
            servers.add((RuntimeBBServer)server);
        }
        return servers;
    }

    public RuntimeMeetingPoint addMeetingPoint(MeetingPoint apiDevice) {
        if (this.findServer(apiDevice.ServiceInfoGet().ServiceIDGet()) != null) {
            throw new IllegalStateException("RuntimeServer was already created for server " + apiDevice.DescriptionGet());
        }
        RuntimeMeetingPoint rtResult = new RuntimeMeetingPoint(this, apiDevice);
        this.rtServers.add(rtResult);
        return rtResult;
    }

    private RuntimeBBServer addServer(ByteBlowerServer apiServer) {
        RuntimeServer existing = this.findServer(apiServer.ServiceInfoGet().ServiceIDGet());
        if (existing != null) {
            LOGGER.info("Same server, multplie FQDNs");
            return (RuntimeBBServer)existing;
        }
        RuntimeBBServer rtResult = new RuntimeBBServer(this, apiServer);
        this.rtServers.add(rtResult);
        return rtResult;
    }

    public int serverCount() {
        return this.rtServers.size();
    }

    private RuntimeServer findServer(String uuid) {
        for (RuntimeServer server : this.rtServers) {
            if (!uuid.equals(server.getUUID())) continue;
            return server;
        }
        return null;
    }

    public RuntimeMeetingPoint findRuntimeMeetingPointOnURL(String url) {
        return this.addressedMeetingPoints.getOrDefault(url, null);
    }

    public RuntimeBBServer findRuntimeBBServerOnURL(String url) {
        return this.addressedServers.getOrDefault(url, null);
    }

    public void cleanup() {
        for (RuntimePort port : this.rtScenarioRunner.getRuntimeScenario().getRuntimePortsInvolved()) {
            port.release();
        }
        for (RuntimeServer rtServer : this.rtServers) {
            rtServer.cleanup(this.apiByteblower);
        }
    }

    public String getDescription() {
        return this.apiByteblower.DescriptionGet();
    }

    private RuntimeBBServer checkOtherServers(String serverUrl) {
        ByteBlowerServer apiServer = this.apiByteblower.ServerAdd(serverUrl);
        RuntimeBBServer rtServerToAdd = new RuntimeBBServer(this, apiServer);
        for (RuntimeServer existingServer : this.rtServers) {
            if (!rtServerToAdd.equals(existingServer)) continue;
            rtServerToAdd.cleanup(this.apiByteblower);
            return (RuntimeBBServer)existingServer;
        }
        this.rtServers.add(rtServerToAdd);
        return rtServerToAdd;
    }

    public RuntimeBBServer addBBServer(String serverUrl) {
        return this.addressedServers.computeIfAbsent(serverUrl, this::checkOtherServers);
    }

    private RuntimeMeetingPoint checkOtherMeetingPoints(String serverUrl) {
        MeetingPoint apiServer = this.apiByteblower.MeetingPointAdd(serverUrl);
        RuntimeMeetingPoint rtMeetingPointToAdd = new RuntimeMeetingPoint(this, apiServer);
        for (RuntimeServer existingServer : this.rtServers) {
            if (!rtMeetingPointToAdd.equals(existingServer)) continue;
            rtMeetingPointToAdd.cleanup(this.apiByteblower);
            return (RuntimeMeetingPoint)existingServer;
        }
        this.rtServers.add(rtMeetingPointToAdd);
        return rtMeetingPointToAdd;
    }

    public RuntimeMeetingPoint addMeetingPoint(String serverUrl) {
        return this.addressedMeetingPoints.computeIfAbsent(serverUrl, this::checkOtherMeetingPoints);
    }

    public List<DebugInfo> collectDebugInfo() {
        ArrayList<DebugInfo> result = new ArrayList<DebugInfo>();
        for (RuntimeServer gg : this.rtServers) {
            result.addAll(gg.collectDebugInfo());
        }
        return result;
    }
}

