/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.FrameTagTx;
import com.excentis.products.byteblower.communication.api.IGMPMemberSession;
import com.excentis.products.byteblower.communication.api.IGMPv1MemberSession;
import com.excentis.products.byteblower.communication.api.MLDMulticastListenerSession;
import com.excentis.products.byteblower.communication.api.MLDv1MulticastListenerSession;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.Broadcast;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.IgmpVersion;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4MulticastMemberPort;
import com.excentis.products.byteblower.model.Ipv6MulticastMemberPort;
import com.excentis.products.byteblower.model.MldVersion;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.Unicast;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.IpAddressReaderImpl;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.objects.RuntimeFixedDestination;
import com.excentis.products.byteblower.run.objects.RuntimeFlowDestination;
import com.excentis.products.byteblower.run.objects.RuntimeFlowSource;
import com.excentis.products.byteblower.run.objects.RuntimeIPv4Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeIPv6Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeMulticastDestination;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimePortDestination;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;

public abstract class RuntimeFlow
extends RuntimeObject {
    private final Type type;
    private State state;
    protected final RuntimeScenario rtScenario;
    protected final FlowReader mFlowReader;
    protected final FlowMeasurementReader mFlowInstanceReader;
    private RuntimeFlowSource rtFlowSource;
    protected RuntimeFlowDestination rtFlowDestination;
    protected final List<RuntimePortDestination> rtEavesdroppers = new ArrayList<RuntimePortDestination>();
    private final List<AbstractAction> mobileConfig = new ArrayList<AbstractAction>();

    protected RuntimeFlow(RuntimeScenario rtScenario, FlowMeasurement mFlowInstance, Type type) {
        this.rtScenario = rtScenario;
        this.mFlowInstanceReader = ReaderFactory.create((FlowMeasurement)mFlowInstance);
        this.mFlowReader = ReaderFactory.create((Flow)mFlowInstance.getFlow());
        this.type = type;
        this.state = State.CREATED;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.rtScenario;
    }

    public FlowReader getModelFlowReader() {
        return this.mFlowReader;
    }

    public FlowMeasurementReader getModelFlowInstanceReader() {
        return this.mFlowInstanceReader;
    }

    public FlowTemplate getModelFlowTemplate() {
        return this.mFlowReader.getFlowTemplate();
    }

    public String name() {
        return this.mFlowReader.getName();
    }

    public String description() {
        return this.name();
    }

    public String getFlowTemplateName() {
        return this.getModelFlowTemplate().getName();
    }

    public boolean hasOutOfSequenceDetection() {
        return false;
    }

    public boolean hasLatencyMeasurement() {
        return false;
    }

    public Collection<FrameTagTx> getFrameTags() {
        return Collections.emptyList();
    }

    public boolean isRuntimeFrameModifierConfigured() {
        return false;
    }

    public RuntimeFlowSource getRuntimeFlowSource() {
        return this.rtFlowSource;
    }

    public RuntimeFlowDestination getRuntimeFlowDestination() {
        return this.rtFlowDestination;
    }

    public List<RuntimePortDestination> getRuntimeEavesdroppers() {
        return this.rtEavesdroppers;
    }

    public RuntimePort getSourceRuntimePort() {
        return this.rtFlowSource.getRuntimePort();
    }

    public List<RuntimePort> getDestinationRuntimePorts() {
        return this.rtFlowDestination.getRuntimePorts();
    }

    public List<RuntimePort> getEavesdropperRuntimePorts() {
        ArrayList<RuntimePort> rtEavesdropperPorts = new ArrayList<RuntimePort>();
        for (RuntimePortDestination rtEavesdropper : this.getRuntimeEavesdroppers()) {
            rtEavesdropperPorts.add(rtEavesdropper.getRuntimePort());
        }
        return rtEavesdropperPorts;
    }

    public List<RuntimePort> getDestinationRuntimePortsConfigured() {
        ArrayList<RuntimePort> configuredRuntimePorts = new ArrayList<RuntimePort>();
        for (RuntimePort rtPort : this.getDestinationRuntimePorts()) {
            if (rtPort.getState() != RuntimePort.State.CONFIGURED) continue;
            configuredRuntimePorts.add(rtPort);
        }
        return configuredRuntimePorts;
    }

    public List<RuntimePort> getEavesdropperRuntimePortsConfigured() {
        ArrayList<RuntimePort> configuredRuntimePorts = new ArrayList<RuntimePort>();
        for (RuntimePort rtPort : this.getEavesdropperRuntimePorts()) {
            if (rtPort.getState() != RuntimePort.State.CONFIGURED) continue;
            configuredRuntimePorts.add(rtPort);
        }
        return configuredRuntimePorts;
    }

    public List<RuntimePort> getDestinationAndEavesdropperRuntimePorts() {
        ArrayList<RuntimePort> allReceiverPorts = new ArrayList<RuntimePort>();
        allReceiverPorts.addAll(this.getDestinationRuntimePorts());
        allReceiverPorts.addAll(this.getEavesdropperRuntimePorts());
        return allReceiverPorts;
    }

    public List<RuntimePort> getDestinationAndEavesdropperRuntimePortsConfigured() {
        ArrayList<RuntimePort> allConfiguredReceiverPorts = new ArrayList<RuntimePort>();
        allConfiguredReceiverPorts.addAll(this.getDestinationRuntimePortsConfigured());
        allConfiguredReceiverPorts.addAll(this.getEavesdropperRuntimePortsConfigured());
        return allConfiguredReceiverPorts;
    }

    public void addMobileConfig(AbstractAction config) {
        this.mobileConfig.add(config);
    }

    public void doMobileActions() {
        for (AbstractAction action : this.mobileConfig) {
            action.invoke();
        }
    }

    public abstract void resetResults();

    public abstract void resultsToRefresh(RefreshableSet var1);

    public boolean hasScheduledEnd() {
        return this.getModelFlowInstanceReader().hasFixedEndTime();
    }

    public long getDuration() {
        return this.getModelFlowInstanceReader().getDurationInNanoseconds();
    }

    public long getEnd() {
        Long endTime = this.getModelFlowInstanceReader().getStopTimeInNanoseconds();
        if (endTime == null) {
            return Long.MAX_VALUE;
        }
        return endTime;
    }

    public abstract boolean isDone();

    public void updateFilters() {
    }

    private void handleMulticastSession(RuntimePort rtPort, MulticastMemberPort mMcMemberPort) {
        String multicastIpString = IpAddressReaderImpl.getAddress((IpAddress)mMcMemberPort.getMulticastGroup().getMulticastIpAddress());
        if (rtPort.isRuntimeLayer3Ipv4() && mMcMemberPort instanceof Ipv4MulticastMemberPort) {
            IGMPv1MemberSession apiIgmpMemberSession;
            RuntimeIPv4Configuration rtIpv4Config = (RuntimeIPv4Configuration)rtPort.getRuntimeLayer3Configuration();
            if (rtIpv4Config.hasRuntimeMulticastSession(mMcMemberPort)) {
                return;
            }
            Ipv4MulticastMemberPort mIpv4McMemberPort = (Ipv4MulticastMemberPort)mMcMemberPort;
            IgmpVersion mIgmpVersion = mIpv4McMemberPort.getIgmpVersion();
            switch (mIgmpVersion) {
                case IGM_PV1_LITERAL: {
                    apiIgmpMemberSession = rtIpv4Config.getApiConfiguration().ProtocolIgmpGet().SessionV1Add(multicastIpString);
                    break;
                }
                case IGM_PV2_LITERAL: {
                    apiIgmpMemberSession = rtIpv4Config.getApiConfiguration().ProtocolIgmpGet().SessionV2Add(multicastIpString);
                    break;
                }
                case IGM_PV3_LITERAL: {
                    apiIgmpMemberSession = rtIpv4Config.getApiConfiguration().ProtocolIgmpGet().SessionV3Add(multicastIpString);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported IGMP protocol version");
                }
            }
            rtIpv4Config.addRuntimeIgmpSession(mIpv4McMemberPort, (IGMPMemberSession)apiIgmpMemberSession);
        } else if (rtPort.isRuntimeLayer3Ipv6() && mMcMemberPort instanceof Ipv6MulticastMemberPort) {
            MLDv1MulticastListenerSession apiMldMulticastListenerSession;
            RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)rtPort.getRuntimeLayer3Configuration();
            if (rtIpv6Config.hasRuntimeMulticastSession(mMcMemberPort)) {
                return;
            }
            Ipv6MulticastMemberPort mIpv6McMemberPort = (Ipv6MulticastMemberPort)mMcMemberPort;
            MldVersion mMldVersion = mIpv6McMemberPort.getMldVersion();
            switch (mMldVersion) {
                case ML_DV1_LITERAL: {
                    apiMldMulticastListenerSession = rtIpv6Config.getApiConfiguration().ProtocolMldGet().SessionV1Add(multicastIpString);
                    break;
                }
                case ML_DV2_LITERAL: {
                    apiMldMulticastListenerSession = rtIpv6Config.getApiConfiguration().ProtocolMldGet().SessionV2Add(multicastIpString);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported IGMP protocol version");
                }
            }
            rtIpv6Config.addRuntimeMldSession(mIpv6McMemberPort, (MLDMulticastListenerSession)apiMldMulticastListenerSession);
        }
    }

    protected AddressableDestination getDestination() {
        return this.mFlowInstanceReader.getFlow().getDestination();
    }

    protected AddressableSource getSource() {
        return this.mFlowInstanceReader.getFlow().getSource();
    }

    public void configureDestination() {
        HashSet<ByteBlowerGuiPort> mDestPorts = new HashSet<ByteBlowerGuiPort>();
        UniqueEList mEavesdroppers = new UniqueEList();
        AddressableDestination mDestination = this.getDestination();
        if (mDestination instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPort mPort = (ByteBlowerGuiPort)mDestination;
            RuntimePort rtPort = this.rtScenario.findRuntimePort(mPort);
            this.rtFlowDestination = new RuntimePortDestination(this, rtPort);
            mDestPorts.add(mPort);
        } else if (mDestination instanceof MulticastGroup) {
            MulticastGroup mMulticastGroup = (MulticastGroup)mDestination;
            ArrayList<RuntimePort> rtPorts = new ArrayList<RuntimePort>();
            for (MulticastMemberPort mMulticastMemberPort : mMulticastGroup.getMulticastMemberPort()) {
                RuntimePort rtPort = this.rtScenario.findRuntimePort(mMulticastMemberPort.getByteBlowerGuiPort());
                this.handleMulticastSession(rtPort, mMulticastMemberPort);
                rtPorts.add(rtPort);
                mDestPorts.add(mMulticastMemberPort.getByteBlowerGuiPort());
            }
            this.rtFlowDestination = new RuntimeMulticastDestination(this, this.rtScenario, mMulticastGroup, rtPorts);
        } else if (mDestination instanceof Unicast) {
            Unicast mUnicast = (Unicast)mDestination;
            this.rtFlowDestination = new RuntimeFixedDestination(this, mUnicast);
        } else if (mDestination instanceof Broadcast) {
            Broadcast mBroadcast = (Broadcast)mDestination;
            this.rtFlowDestination = new RuntimeFixedDestination(this, mBroadcast);
            mEavesdroppers.addAll((Collection)this.mFlowInstanceReader.getProjectReader().getDockedIPv4ByteBlowerGuiPorts());
        } else if (mDestination instanceof ByteBlowerPortGroup) {
            this.rtFlowDestination = new RuntimeFlowDestination(this){

                @Override
                public boolean isNatted() {
                    return false;
                }

                @Override
                public String getIPAddress() {
                    return null;
                }

                @Override
                public List<RuntimePort> getRuntimePorts() {
                    return Collections.emptyList();
                }
            };
        }
        mEavesdroppers.addAll((Collection)this.mFlowInstanceReader.getEavesdropperPorts());
        for (ByteBlowerGuiPort mPort : mEavesdroppers) {
            if (mDestPorts.contains(mPort)) continue;
            this.rtEavesdroppers.add(new RuntimePortDestination(this, this.rtScenario.findRuntimePort(mPort)));
        }
    }

    public RuntimeFlowSource configureSource() {
        AddressableSource mSource = this.getSource();
        if (mSource instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPort mPort = (ByteBlowerGuiPort)mSource;
            RuntimePort rtPort = this.rtScenario.findRuntimePort(mPort);
            this.rtFlowSource = new RuntimeFlowSource(this, rtPort);
            return this.rtFlowSource;
        }
        throw new IllegalStateException("Unsupported flow source type " + mSource.getClass().getSimpleName());
    }

    public Collection<? extends RuntimePort> getRuntimePortsForSynchronousStart() {
        HashSet<RuntimePort> rtPortSet = new HashSet<RuntimePort>();
        rtPortSet.add(this.getSourceRuntimePort());
        rtPortSet.addAll(this.getDestinationAndEavesdropperRuntimePortsConfigured());
        return rtPortSet;
    }

    public static enum State {
        CREATED,
        CONFIGURED,
        FAILED;

    }

    public static enum Type {
        FB,
        HTTP,
        UNKNOWN;

    }
}

