/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.frame.ARPPacket;
import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.TCPPacket;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.frame.VlanPacket;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameSizeModifier;
import com.excentis.products.byteblower.model.GrowingSizeModifier;
import com.excentis.products.byteblower.model.RandomSizeModifier;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeLayer25Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeVlanConfiguration;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import com.excentis.products.byteblower.utils.Utils;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class RuntimeFrame
extends RuntimeObject {
    private static final int OUT_OF_SEQUENCE_FIELD_LENGTH = 8;
    protected final RuntimeFlow rtFbFlow;
    protected final Frame mFbFrame;
    private FrameReader frameReader;
    protected EthernetPacket packetEthernet;
    private VlanPacket packetVlan;
    private int ethernetType;
    int nofInsertedVlans = 0;
    protected ARPPacket packetArp;
    protected Ipv4Packet packetIpv4;
    protected Ipv6Packet packetIpv6;
    protected TCPPacket packetTcp;
    protected UDPPacket packetUdp;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$run$filters$core$BPFFilter$Proto = RuntimeFrame.$SWITCH_TABLE$com$excentis$products$byteblower$run$filters$core$BPFFilter$Proto();
    }

    RuntimeFrame(RuntimeFlow rtFbFlow, Frame mFbFrame) {
        this.rtFbFlow = rtFbFlow;
        this.mFbFrame = mFbFrame;
        this.initializeLayers();
    }

    RuntimeFrame(RuntimeFrame rtFrame) {
        this.rtFbFlow = rtFrame.rtFbFlow;
        this.mFbFrame = rtFrame.mFbFrame;
        this.initializeLayers();
    }

    public String name() {
        return this.frameReader.getName();
    }

    private void initializeLayers() {
        this.frameReader = ReaderFactory.create((Frame)this.mFbFrame);
        this.packetEthernet = this.frameReader.getEthernet();
        if (this.packetEthernet.getSize() % 8 != 0) {
            throw new IllegalStateException("Ethernet frame size in bits is not divisible by 8");
        }
        this.ethernetType = this.packetEthernet.getType();
        if (this.ethernetType == 2054) {
            this.packetArp = this.frameReader.getArp();
            this.packetIpv4 = null;
            this.packetIpv6 = null;
            this.packetUdp = null;
            this.packetTcp = null;
        } else if (this.ethernetType == 2048) {
            this.packetIpv4 = this.frameReader.getIpv4();
            this.packetIpv6 = null;
            this.packetArp = null;
            if (this.packetIpv4.getProtocol() == 6) {
                this.packetTcp = this.frameReader.getCurrentTcp();
                this.packetUdp = null;
            } else if (this.packetIpv4.getProtocol() == 17) {
                this.packetUdp = this.frameReader.getCurrentUdp();
                this.packetTcp = null;
            } else {
                this.packetUdp = null;
                this.packetTcp = null;
            }
        } else if (this.ethernetType == 34525) {
            this.packetIpv6 = this.frameReader.getIpv6();
            this.packetIpv4 = null;
            this.packetArp = null;
            if (this.packetIpv6.getNextHeader() == 6) {
                this.packetTcp = this.frameReader.getCurrentTcp();
                this.packetUdp = null;
            } else if (this.packetIpv6.getNextHeader() == 17) {
                this.packetUdp = this.frameReader.getCurrentUdp();
                this.packetTcp = null;
            } else {
                this.packetUdp = null;
                this.packetTcp = null;
            }
        } else {
            this.packetArp = null;
            this.packetIpv4 = null;
            this.packetIpv6 = null;
            this.packetUdp = null;
            this.packetTcp = null;
        }
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.getRuntimeFlow().getRuntimeScenario();
    }

    public RuntimeFlow getRuntimeFlow() {
        return this.rtFbFlow;
    }

    public Frame getModelFbFrame() {
        return this.mFbFrame;
    }

    public FrameReader getModelFbFrameReader() {
        return this.frameReader;
    }

    public String getByteHexString() {
        byte[] buffer = new byte[this.packetEthernet.getSize() / 8];
        this.packetEthernet.dump(buffer, 0);
        return Utils.bufferToHexString((byte[])buffer, (int)(this.packetEthernet.getSize() / 8));
    }

    public void setByteHexString(String hexString) {
        byte[] bytes = Utils.hexStringToBuffer((String)hexString);
        this.packetEthernet.set(bytes.length * 8, bytes, 0);
    }

    public boolean hasFrameSizeModifier() {
        FrameBlastingFlow frameBlastingFlow;
        return this.rtFbFlow.getModelFlowTemplate() instanceof FrameBlastingFlow && (frameBlastingFlow = (FrameBlastingFlow)this.rtFbFlow.getModelFlowTemplate()).getFrameModifier() instanceof FrameSizeModifier;
    }

    public FrameSizeModifier getFrameSizeModifier() {
        if (!(this.rtFbFlow.getModelFlowTemplate() instanceof FrameBlastingFlow)) {
            throw new IllegalStateException("UDP flows does not have a frame size modifier.");
        }
        FrameBlastingFlow frameBlastingFlow = (FrameBlastingFlow)this.rtFbFlow.getModelFlowTemplate();
        if (!(frameBlastingFlow.getFrameModifier() instanceof FrameSizeModifier)) {
            throw new IllegalStateException("This flow does not have a frame size modifier.");
        }
        return (FrameSizeModifier)frameBlastingFlow.getFrameModifier();
    }

    public int getEthernetEthertypeValue() {
        return this.ethernetType;
    }

    boolean hasIPHeader() {
        return this.hasIPv4Header() || this.hasIPv6Header();
    }

    public boolean hasIPv4Header() {
        return this.packetIpv4 != null;
    }

    public boolean hasIPv6Header() {
        return this.packetIpv6 != null;
    }

    public boolean hasUDPHeader() {
        return this.packetUdp != null;
    }

    public boolean hasTCPHeader() {
        return this.packetTcp != null;
    }

    boolean hasEthernetHeader() {
        return this.packetEthernet != null;
    }

    public boolean hasARPHeader() {
        return this.packetArp != null;
    }

    public int getARPOperation() {
        if (!this.hasARPHeader()) {
            throw new IllegalStateException("RuntimeFrame.getARPOperation() failed because the frame does not contain an ARP header.");
        }
        return this.packetArp.getOperation();
    }

    public String getARPSenderProtocolAddress() {
        return this.packetArp.getSPA();
    }

    public String getARPTargetProtocolAddress() {
        return this.packetArp.getTPA();
    }

    public ProtocolLayer getLayer(BPFFilter.Proto protocol) {
        switch (protocol) {
            case ARP: {
                return this.packetArp;
            }
            case ETHERNET: {
                return this.packetEthernet;
            }
            case IPv4: {
                return this.packetIpv4;
            }
            case IPv6: {
                return this.packetIpv6;
            }
            case TCP: {
                return this.packetTcp;
            }
            case UDP: {
                return this.packetUdp;
            }
        }
        throw new IllegalStateException();
    }

    public BPFFilter.Proto getHighestProtocol() {
        if (this.hasTCPHeader()) {
            return BPFFilter.Proto.TCP;
        }
        if (this.hasUDPHeader()) {
            return BPFFilter.Proto.UDP;
        }
        if (this.hasIPv4Header()) {
            return BPFFilter.Proto.IPv4;
        }
        if (this.hasIPv6Header()) {
            return BPFFilter.Proto.IPv6;
        }
        if (this.hasARPHeader()) {
            return BPFFilter.Proto.ARP;
        }
        return BPFFilter.Proto.ETHERNET;
    }

    public byte[] getPayload(BPFFilter.Proto protocol) {
        ProtocolLayer protocolLayer = this.getLayer(protocol);
        ProtocolField payload = protocolLayer.getPayload();
        int size = payload.getSize();
        byte[] buffer = new byte[size / 8];
        payload.dump(buffer, 0);
        if (!this.rtFbFlow.hasOutOfSequenceDetection()) {
            return buffer;
        }
        byte[] bufferWithoutSequenceDetectionBytes = new byte[buffer.length - 8];
        int i = 0;
        while (i < bufferWithoutSequenceDetectionBytes.length) {
            bufferWithoutSequenceDetectionBytes[i] = buffer[i];
            ++i;
        }
        return bufferWithoutSequenceDetectionBytes;
    }

    public byte[] getPayload(BPFFilter.Proto protocol, FrameSizeModifier frameSizeModifier) {
        if (frameSizeModifier instanceof GrowingSizeModifier) {
            GrowingSizeModifier growingSizeModifier = (GrowingSizeModifier)frameSizeModifier;
            return this.getPayload(protocol, growingSizeModifier.getMinSize());
        }
        if (frameSizeModifier instanceof RandomSizeModifier) {
            RandomSizeModifier randomSizeModifier = (RandomSizeModifier)frameSizeModifier;
            return this.getPayload(protocol, randomSizeModifier.getMinSize());
        }
        return this.getPayload(protocol);
    }

    private byte[] getPayload(BPFFilter.Proto protocol, int minSize) {
        byte[] fullPayload = this.getFullPayload();
        int payloadOffset = this.getProtocolOffset(protocol) + this.getHeader(protocol).length;
        int payloadSize = Math.min(minSize, fullPayload.length) - payloadOffset;
        if (payloadSize <= 0) {
            return new byte[0];
        }
        byte[] result = new byte[payloadSize];
        assert (fullPayload.length == payloadSize);
        int i = 0;
        while (i < payloadSize) {
            result[i] = fullPayload[i + payloadOffset];
            ++i;
        }
        return result;
    }

    private BPFFilter.Proto getLowerLayer(BPFFilter.Proto protocol) {
        switch (protocol) {
            case ETHERNET: {
                throw new IllegalStateException("Ethernet frame doesn't have a lower layer frame.");
            }
            case ARP: 
            case IPv4: 
            case IPv6: {
                return BPFFilter.Proto.ETHERNET;
            }
            case UDP: 
            case TCP: {
                if (this.hasIPv4Header()) {
                    return BPFFilter.Proto.IPv4;
                }
                if (this.hasIPv6Header()) {
                    return BPFFilter.Proto.IPv6;
                }
                throw new IllegalStateException("Frame has neither a IPv4 nor IPv6 payload.");
            }
        }
        throw new RuntimeException();
    }

    public int getProtocolOffset(BPFFilter.Proto protocol) {
        if (protocol.equals((Object)BPFFilter.Proto.ETHERNET)) {
            return 0;
        }
        BPFFilter.Proto lowerLayer = this.getLowerLayer(protocol);
        return this.getProtocolOffset(lowerLayer) + this.getHeader(lowerLayer).length;
    }

    private byte[] getFullPayload() {
        byte[] header = this.getHeader(BPFFilter.Proto.ETHERNET);
        byte[] payload = this.getPayload(BPFFilter.Proto.ETHERNET);
        byte[] result = new byte[header.length + payload.length];
        ByteBuffer buffer = ByteBuffer.wrap(result);
        buffer.put(header);
        buffer.put(payload);
        return result;
    }

    byte[] getHeader(BPFFilter.Proto protocol) {
        int headerlength = (this.getLayer(protocol).getSize() - this.getLayer(protocol).getPayload().getSize()) / 8;
        byte[] buffer = new byte[headerlength];
        int offset = 0;
        List fields = this.getLayer(protocol).getFields();
        int i = 0;
        while (i < fields.size() - 1) {
            ProtocolField pf = (ProtocolField)fields.get(i);
            pf.dump(buffer, offset);
            offset += pf.getSize() / 8;
            ++i;
        }
        return buffer;
    }

    public int getFrameLength() {
        return this.frameReader.getByteSize(ThroughputType.FRAME_ONLY);
    }

    public void clearUDPChecksum() {
        if (this.packetUdp != null && this.packetIpv4 != null) {
            this.packetUdp.setCheckSum(0);
        }
    }

    int insertVlanStack(RuntimePort runtimePort) {
        Iterator<RuntimeLayer25Configuration> innerToOut = runtimePort.layer25ConfigurationInnerIterator();
        while (innerToOut.hasNext()) {
            RuntimeLayer25Configuration config = innerToOut.next();
            if (config instanceof RuntimeVlanConfiguration) {
                RuntimeVlanConfiguration mVlanConfig = (RuntimeVlanConfiguration)config;
                int etherType = this.packetEthernet.getType();
                this.packetVlan = new VlanPacket((ProtocolLayer)this.packetEthernet);
                this.packetVlan.setPayload(this.packetEthernet.getPayload());
                this.packetVlan.setProtocol(etherType);
                this.packetVlan.setVID(mVlanConfig.getVlanId());
                this.packetVlan.setDE(mVlanConfig.isDropEligible());
                this.packetVlan.setPCP(mVlanConfig.getPriority());
                this.packetEthernet.setType(mVlanConfig.getProtocolId());
                this.packetEthernet.setPayload((ProtocolField)this.packetVlan);
                ++this.nofInsertedVlans;
                continue;
            }
            throw new IllegalStateException("Runtime frame only supports vlan layer25 configuration");
        }
        return this.nofInsertedVlans;
    }

    public String getName() {
        return this.mFbFrame.getName();
    }
}

