/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.HTTPResultHistory;
import com.excentis.products.byteblower.communication.api.HTTPServer;
import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.communication.api.TCPResultHistory;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import com.excentis.products.byteblower.run.utils.LocalHttpResultData;
import com.excentis.products.byteblower.run.utils.LocalTcpResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RuntimeHttpServer
extends RuntimeObject {
    private final RuntimePort rtPort;
    private final TcpFlow mHttpFlowTemplate;
    private final TcpFlowReader mHttpFlowTemplateReader;
    private HTTPServer apiHttpServer;
    private HashSet<String> knownClients = new HashSet();
    private Object lastRefreshKey = RefreshableSet.notRefreshedYet();
    private Map<String, LocalHttpResultData> httpServerCumulData = new HashMap<String, LocalHttpResultData>();
    private Map<String, LocalHttpResultData> currentHttpServerCumulData = new HashMap<String, LocalHttpResultData>();
    private Map<String, LocalTcpResultData> tcpServerCumulData = new HashMap<String, LocalTcpResultData>();
    private Map<String, LocalTcpResultData> currentTcpServerCumulData = new HashMap<String, LocalTcpResultData>();

    RuntimeHttpServer(RuntimePort rtPort, HTTPServer apiHttpServer, TcpFlow mHttpFlowTemplate) {
        this.rtPort = rtPort;
        this.mHttpFlowTemplate = mHttpFlowTemplate;
        this.mHttpFlowTemplateReader = ReaderFactory.create((TcpFlow)mHttpFlowTemplate);
        this.apiHttpServer = apiHttpServer;
    }

    public RuntimePort getRuntimePort() {
        return this.rtPort;
    }

    public TcpFlow getModelHttpFlowTemplate() {
        return this.mHttpFlowTemplate;
    }

    public TcpFlowReader getModelHttpFlowTemplateReader() {
        return this.mHttpFlowTemplateReader;
    }

    public HTTPServer getApiHttpServer() {
        return this.apiHttpServer;
    }

    private int tryInt(String gg) {
        try {
            return Integer.parseInt(gg);
        }
        catch (Exception exception) {
            return Integer.MIN_VALUE;
        }
    }

    HTTPSessionInfo SessionInfoGet(String serverClientId) {
        int bestExample = Integer.MIN_VALUE;
        String bestIdentAtServer = "";
        for (String identAtServer : this.getIdentifiers()) {
            String[] splitted;
            if (identAtServer.equals(serverClientId)) {
                bestIdentAtServer = identAtServer;
                break;
            }
            if (!identAtServer.startsWith(serverClientId) || (splitted = identAtServer.split("-")).length != 2 || bestExample >= this.tryInt(splitted[1])) continue;
            bestExample = this.tryInt(splitted[1]);
            bestIdentAtServer = identAtServer;
        }
        if (bestIdentAtServer.isEmpty()) {
            return null;
        }
        return this.apiHttpServer.HttpSessionInfoGet(bestIdentAtServer);
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.rtPort.getRuntimeScenario();
    }

    public int getApiPortNumber() {
        return this.apiHttpServer.PortGet();
    }

    public String getIPAddress() {
        return this.rtPort.getIPAddress();
    }

    public Collection<String> getIdentifiers() {
        return this.apiHttpServer.ClientIdentifiersGet();
    }

    boolean hasSession(String identifier) {
        for (String identAtServer : this.getIdentifiers()) {
            if (!identAtServer.startsWith(identifier)) continue;
            return true;
        }
        return false;
    }

    public String portName() {
        return this.rtPort.getName();
    }

    public void resultsToRefresh(RefreshableSet toRefresh) {
        if (toRefresh.isSameCycle(this.lastRefreshKey)) {
            return;
        }
        HTTPServer apiHttpServer = this.getApiHttpServer();
        for (String clientId : apiHttpServer.ClientIdentifiersGet()) {
            HTTPSessionInfo serverClientSession = apiHttpServer.HttpSessionInfoGet(clientId);
            this.prepare(serverClientSession, toRefresh);
        }
    }

    private void prepare(HTTPSessionInfo session, RefreshableSet toRefresh) {
        HTTPResultHistory httpHistory = session.ResultHistoryGet();
        TCPResultHistory tcpHistory = session.TcpSessionInfoGet().ResultHistoryGet();
        String clientId = session.ServerClientIdGet();
        if (this.knownClients.contains(clientId)) {
            httpHistory.Clear();
            tcpHistory.Clear();
        } else {
            this.knownClients.add(clientId);
        }
        this.lastRefreshKey = toRefresh.add(new AbstractRefreshableResult[]{httpHistory, tcpHistory});
    }

    public void hasRestarted(String oldServerClientId, String newServerClientId) {
        LocalHttpResultData pastData = this.httpServerCumulData.getOrDefault(oldServerClientId, new LocalHttpResultData());
        LocalHttpResultData currentData = this.currentHttpServerCumulData.getOrDefault(oldServerClientId, new LocalHttpResultData());
        this.httpServerCumulData.remove(oldServerClientId);
        this.currentHttpServerCumulData.remove(oldServerClientId);
        this.httpServerCumulData.put(newServerClientId, pastData.add(currentData));
        LocalTcpResultData pastTcpData = this.tcpServerCumulData.getOrDefault(oldServerClientId, new LocalTcpResultData());
        LocalTcpResultData currentTcpData = this.currentTcpServerCumulData.getOrDefault(oldServerClientId, new LocalTcpResultData());
        this.tcpServerCumulData.remove(oldServerClientId);
        this.currentTcpServerCumulData.remove(oldServerClientId);
        this.tcpServerCumulData.put(newServerClientId, pastTcpData.add(currentTcpData));
    }

    public LocalHttpResultData getCumulHTTP(String serverClientId) {
        HTTPResultHistory hist;
        LocalHttpResultData previous = this.httpServerCumulData.getOrDefault(serverClientId, new LocalHttpResultData());
        HTTPSessionInfo clientSession = this.SessionInfoGet(serverClientId);
        LocalHttpResultData current = clientSession != null ? ((hist = clientSession.ResultHistoryGet()).CumulativeLengthGet() > 0L ? new LocalHttpResultData(hist.CumulativeLatestGet()) : new LocalHttpResultData()) : new LocalHttpResultData();
        this.currentHttpServerCumulData.put(serverClientId, current);
        LocalHttpResultData together = previous.add(current);
        return together;
    }

    public LocalTcpResultData getCumulTcp(String serverClientId) {
        TCPResultHistory hist;
        LocalTcpResultData previous = this.tcpServerCumulData.getOrDefault(serverClientId, new LocalTcpResultData());
        HTTPSessionInfo clientSession = this.SessionInfoGet(serverClientId);
        LocalTcpResultData current = clientSession != null ? ((hist = clientSession.TcpSessionInfoGet().ResultHistoryGet()).CumulativeLengthGet() > 0L ? new LocalTcpResultData(hist.CumulativeLatestGet()) : new LocalTcpResultData()) : new LocalTcpResultData();
        this.currentTcpServerCumulData.put(serverClientId, current);
        LocalTcpResultData together = previous.add(current);
        return together;
    }

    public int getIdxFor(String serverClientId) {
        int bestExample = Integer.MIN_VALUE;
        for (String identAtServer : this.getIdentifiers()) {
            String[] splitted;
            if (identAtServer.equals(serverClientId)) break;
            if (!identAtServer.startsWith(serverClientId) || (splitted = identAtServer.split("-")).length != 2 || bestExample >= this.tryInt(splitted[1])) continue;
            bestExample = this.tryInt(splitted[1]);
        }
        return bestExample;
    }
}

