/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.Latency;
import com.excentis.products.byteblower.communication.api.LatencyBasic;
import com.excentis.products.byteblower.communication.api.LatencyBasicResultData;
import com.excentis.products.byteblower.communication.api.LatencyBasicResultHistory;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeLatency;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.SamplingConfiguration;
import com.excentis.products.byteblower.run.utils.LocalLatencyResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;

public class RuntimeLatencyBasic
extends RuntimeLatency {
    public RuntimeLatencyBasic(RuntimeFbFlow rtFbFlow, RuntimePort rtPort) {
        super(rtFbFlow, rtPort, (Latency)rtPort.getApiPort().RxLatencyBasicAdd());
        SamplingConfiguration config = this.getSamplingConfig();
        this.getApiReceiver().ResultHistoryGet().SamplingBufferLengthSet(config.getBufferSize());
        this.getApiReceiver().ResultHistoryGet().SamplingIntervalDurationSet(config.getSampleDurationNs());
    }

    protected RuntimeLatencyBasic(RuntimeFbFlow rtFbFlow, RuntimeMobileDevice rtPort) {
        super(rtFbFlow, rtPort);
    }

    public LatencyBasic getApiReceiver() {
        return (LatencyBasic)this.apiRx;
    }

    @Override
    public void visit(RuntimeRx.TriggerVisitor v) {
        v.visit(this);
    }

    @Override
    public void resetResults() {
        if (this.getApiReceiver() != null) {
            this.getApiReceiver().ResultClear();
            this.getApiReceiver().ResultHistoryGet().Refresh();
            this.getApiReceiver().ResultHistoryGet().Clear();
        }
    }

    @Override
    public void gatherRealtimeResults(RefreshableSet toRefresh) {
        LatencyBasicResultHistory history = this.getApiReceiver().ResultHistoryGet();
        history.Clear();
        toRefresh.add(new AbstractRefreshableResult[]{history});
    }

    @Override
    public void visit(RuntimeRx.SnapshotVisitor v) {
        LatencyBasicResultHistory ss = this.getApiReceiver().ResultHistoryGet();
        ArrayList<LocalLatencyResultData> results = new ArrayList<LocalLatencyResultData>();
        for (LatencyBasicResultData a : ss.IntervalGet()) {
            results.add(new LocalLatencyResultData(a));
        }
        if (results.size() > 0) {
            results.remove(results.size() - 1);
        }
        v.visit(this.getRuntimePort(), results.toArray(new LocalLatencyResultData[results.size()]));
    }

    @Override
    public void visitCumulativeSnapshots(RuntimeRx.SnapshotVisitor visitor) {
        LatencyBasicResultHistory ss = this.getApiReceiver().ResultHistoryGet();
        ArrayList<LocalLatencyResultData> results = new ArrayList<LocalLatencyResultData>();
        for (LatencyBasicResultData a : ss.CumulativeGet()) {
            results.add(new LocalLatencyResultData(a));
        }
        if (results.size() > 0) {
            results.remove(results.size() - 1);
        }
        visitor.visit(this.getRuntimePort(), results.toArray(new LocalLatencyResultData[results.size()]));
    }
}

