/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.Latency;
import com.excentis.products.byteblower.communication.api.LatencyDistribution;
import com.excentis.products.byteblower.communication.api.LatencyDistributionResultSnapshot;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeLatency;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.utils.LocalLatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.RefreshableSet;

public class RuntimeLatencyDistribution
extends RuntimeLatency {
    public RuntimeLatencyDistribution(RuntimeFbFlow rtFbFlow, RuntimePort rtPort, Long distributionRangeStartNs, Long distributionRangeEndNs) {
        super(rtFbFlow, rtPort, (Latency)rtPort.getApiPort().RxLatencyDistributionAdd());
        this.getApiReceiver().RangeSet(distributionRangeStartNs.longValue(), distributionRangeEndNs.longValue());
    }

    public LatencyDistribution getApiReceiver() {
        return (LatencyDistribution)this.apiRx;
    }

    public Long getApiDistributionRangeStart() {
        return this.getApiReceiver().RangeMinimumGet();
    }

    public Long getApiDistributionRangeEnd() {
        return this.getApiReceiver().RangeMaximumGet();
    }

    @Override
    public void visit(RuntimeRx.TriggerVisitor v) {
        v.visit(this);
    }

    @Override
    public void resetResults() {
        this.getApiReceiver().ResultClear();
    }

    @Override
    public void gatherRealtimeResults(RefreshableSet toRefresh) {
    }

    @Override
    public void visit(RuntimeRx.SnapshotVisitor v) {
        LatencyDistributionResultSnapshot ss = this.getApiReceiver().ResultGet();
        v.visit(this.getRuntimePort(), new LocalLatencyDistributionSnapshot(ss));
    }

    @Override
    public void visitCumulativeSnapshots(RuntimeRx.SnapshotVisitor visitor) {
        LatencyDistributionResultSnapshot ss = this.getApiReceiver().ResultGet();
        visitor.visit(this.getRuntimePort(), new LocalLatencyDistributionSnapshot(ss));
    }
}

