/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.ByteBlower;
import com.excentis.products.byteblower.communication.api.MeetingPoint;
import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.communication.api.WirelessEndpointList;
import com.excentis.products.byteblower.run.objects.RuntimeByteBlower;
import com.excentis.products.byteblower.run.objects.RuntimeInterface;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import com.excentis.products.byteblower.run.utils.DebugInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class RuntimeMeetingPoint
extends RuntimeServer {
    private final MeetingPoint apiServer;
    private final HashMap<String, RuntimeInterface> interfaces;

    protected RuntimeMeetingPoint(RuntimeByteBlower rtByteBlower, MeetingPoint apiServer) {
        super(rtByteBlower);
        this.apiServer = apiServer;
        this.interfaces = new HashMap();
        for (WirelessEndpoint ee : apiServer.DeviceListGet()) {
            String id = ee.DeviceIdentifierGet();
            this.interfaces.put(id, new RuntimeInterface(this, id));
        }
    }

    public MeetingPoint getApiServer() {
        return this.apiServer;
    }

    @Override
    public String getDescription() {
        return this.apiServer.DescriptionGet();
    }

    @Override
    public String getVersion() {
        return this.apiServer.ServiceInfoGet().VersionGet();
    }

    public RuntimeInterface getRuntimeInterface(String id) {
        return this.interfaces.get(id);
    }

    @Override
    public void cleanup(ByteBlower apiByteblower) {
        apiByteblower.MeetingPointRemove(this.apiServer);
    }

    @Override
    public long now() {
        return this.getApiServer().TimestampGet();
    }

    @Override
    public long startAll(Collection<RuntimePort> endpoints) {
        WirelessEndpointList list = new WirelessEndpointList();
        for (RuntimePort port : endpoints) {
            WirelessEndpoint endpoint = port.getMobilePort();
            list.add(endpoint);
        }
        return this.apiServer.DevicesStart(list);
    }

    @Override
    public String getIPAddress() {
        return this.apiServer.ServiceInfoGet().ConnectionIPAddressGet();
    }

    @Override
    public String getName() {
        return this.apiServer.ServiceInfoGet().ConnectionHostGet();
    }

    @Override
    public String getType() {
        return this.apiServer.ServiceInfoGet().TypeGet();
    }

    @Override
    public String getUUID() {
        return this.apiServer.ServiceInfoGet().ServiceIDGet();
    }

    @Override
    protected Collection<? extends DebugInfo> collectDebugInfo() {
        return Collections.emptyList();
    }
}

