/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.FrameMobile;
import com.excentis.products.byteblower.communication.api.NetworkInfo;
import com.excentis.products.byteblower.communication.api.NetworkInfoMonitor;
import com.excentis.products.byteblower.communication.api.NetworkInfoMonitorResultData;
import com.excentis.products.byteblower.communication.api.NetworkInfoMonitorResultHistory;
import com.excentis.products.byteblower.communication.api.StreamMobile;
import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.RuntimePreferences;
import com.excentis.products.byteblower.run.actions.ConfigureMobileDevice;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeInterface;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeMobileRx;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.LocalNetworkInfoResult;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import com.excentis.products.byteblower.utils.Sleep;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Version;

public class RuntimeMobileDevice
extends RuntimePort {
    private static final Logger LOGGER = Logger.getGlobal();
    private static long FASTBEAT = 1000000000L;
    private final WirelessEndpoint apiMobile;
    private final String virtualMac;
    private final String ip;
    private final String ipv6;
    private final String localIpv6;
    private final boolean isIPv6;
    private final long originalHeartBeat;
    private final int prefix;
    private NetworkInfoMonitor monitor;
    private boolean resultsFeteched = false;
    private final ArrayList<EthernetPacket> toNatKeepAlive = new ArrayList();

    public RuntimeMobileDevice(RuntimeScenario rtScenario, RuntimeInterface rtInterface, WirelessEndpoint apiPort, ByteBlowerGuiPort mPort) {
        super(rtScenario, rtInterface, apiPort, mPort);
        String[] parts;
        String fetchedIp;
        this.apiMobile = apiPort;
        if (!this.apiMobile.LockTry(true, false)) {
            throw new IllegalStateException("Device was already locked by " + this.apiMobile.LockOwnerGet());
        }
        this.isIPv6 = ReaderFactory.create((ByteBlowerGuiPort)mPort).isIPv6();
        this.originalHeartBeat = this.apiMobile.HeartbeatIntervalGet();
        this.apiMobile.HeartbeatIntervalSet(FASTBEAT);
        NetworkInfo networkInfo = this.apiMobile.DeviceInfoGet().NetworkInfoGet();
        this.ip = fetchedIp = networkInfo.IPv4Get();
        if (networkInfo.IPv6LinkLocalGet().size() > 0) {
            String ipv6Local = networkInfo.IPv6LinkLocalGet().get(0);
            parts = ipv6Local.split("/");
            this.localIpv6 = parts[0];
        } else {
            this.localIpv6 = "0::0";
        }
        if (networkInfo.IPv6GlobalGet().size() > 0) {
            String ipv6_prefix = networkInfo.IPv6GlobalGet().get(0);
            parts = ipv6_prefix.split("/");
            this.ipv6 = parts[0];
            this.prefix = Integer.parseInt(parts[1]);
        } else {
            this.prefix = 0;
            this.ipv6 = "";
        }
        this.monitor = this.apiMobile.DeviceInfoGet().NetworkInfoMonitorAdd();
        Random rand = new Random();
        Formatter mac = new Formatter();
        boolean first = true;
        int ctr = 0;
        while (ctr < 6) {
            if (!first) {
                mac.format("-", new Object[0]);
            }
            mac.format("%02x", rand.nextInt() & 0xFF);
            first = false;
            ++ctr;
        }
        this.virtualMac = mac.toString();
        mac.close();
    }

    @Override
    public String getInterfaceName() {
        return this.apiMobile.DeviceIdentifierGet();
    }

    public void setRuntimeLayer3(RuntimeLayer3Configuration config) {
        this.rtL3Config = config;
    }

    @Override
    public boolean isRuntimeLayer3Ipv4() {
        return true;
    }

    @Override
    public boolean isRuntimeLayer3Ipv6() {
        return true;
    }

    public Version apiVersion() {
        Version version;
        try {
            version = Version.parseVersion((String)this.apiMobile.AppVersionGet());
        }
        catch (IllegalArgumentException ex) {
            version = Version.emptyVersion;
            Logger.getGlobal().log(Level.SEVERE, "Received invalid version string", ex);
        }
        return version;
    }

    public boolean isIpv6() {
        return this.isIPv6;
    }

    @Override
    public String getIPAddress() {
        if (this.isIPv6) {
            return this.ipv6;
        }
        return this.ip;
    }

    public String getIPv6Address() {
        return this.ipv6;
    }

    public String getLocalIPv6Address() {
        return this.localIpv6;
    }

    public int getNetworkPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isRuntimeLayer2Ethernet() {
        return true;
    }

    @Override
    public AbstractAction createConfigureAction(AbstractAction action) {
        return ConfigureMobileDevice.create(action.getContext(), this);
    }

    @Override
    public RuntimeRx createBasicTrigger(RuntimeFbFlow rtFbFlow) {
        return new RuntimeMobileRx(rtFbFlow, (RuntimePort)this);
    }

    @Override
    public String getMacAddressString() {
        return this.virtualMac;
    }

    @Override
    public boolean isMobile() {
        return true;
    }

    public long getHeartBeat(TimeUnit unit) {
        WirelessEndpoint device = this.getMobilePort();
        long beatMs = device.HeartbeatIntervalGet();
        return unit.convert(beatMs, TimeUnit.NANOSECONDS);
    }

    public boolean executeScenario(long maxDuration, TimeUnit unit, Context context) {
        boolean success;
        WirelessEndpoint device = this.getMobilePort();
        long heartbeat = device.HeartbeatIntervalGet();
        device.Prepare();
        device.Start();
        long durationMs = unit.toMillis(maxDuration) + 10L * TimeUnit.NANOSECONDS.toMillis(heartbeat);
        long startMoment = System.currentTimeMillis();
        long MAXWAIT = RuntimePreferences.getResponsiveWait();
        DeviceStatus current = DeviceStatus.Reserved;
        do {
            Sleep.sleep((long)MAXWAIT);
            current = device.StatusGet();
        } while (System.currentTimeMillis() - startMoment < durationMs && (current == DeviceStatus.Starting || current == DeviceStatus.Running) && !context.isCancelled());
        boolean bl = success = current == DeviceStatus.Reserved;
        if (!success) {
            LOGGER.severe("Not able to execute scenario on device: " + current);
            throw new IllegalStateException("Not able to execute scenario on the Wireless Endpoint");
        }
        return success;
    }

    @Override
    public void release() {
        this.apiMobile.ResultClear();
        this.apiMobile.HeartbeatIntervalSet(this.originalHeartBeat);
        this.apiMobile.LockTry(false, true);
    }

    public void prepareScenario() {
        this.getMobilePort().Prepare();
    }

    public boolean allowLatency() {
        return this.getMobilePort().CapabilityIsSupported("Tx.Latency") && this.getMobilePort().CapabilityIsSupported("Rx.Latency.Basic");
    }

    @Override
    public void resetResults() {
        WirelessEndpoint device = this.getMobilePort();
        device.ResultClear();
    }

    public boolean allowLatencyDistribution() {
        return this.getMobilePort().CapabilityIsSupported("Rx.Latency.Distribution");
    }

    @Override
    public boolean fetchResults() {
        if (!this.resultsFeteched) {
            try {
                this.getMobilePort().ResultGet();
                this.resultsFeteched = true;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to retrieve WEP results", e);
            }
        }
        return this.resultsFeteched;
    }

    @Override
    public void visit(RuntimePort.PortVisit visitor) {
        NetworkInfoMonitorResultHistory hist = this.monitor.ResultHistoryGet();
        ArrayList<LocalNetworkInfoResult> collected = new ArrayList<LocalNetworkInfoResult>();
        collected.add(new LocalNetworkInfoResult(this.apiMobile.DeviceInfoGet().NetworkInfoGet()));
        for (NetworkInfoMonitorResultData aResult : hist.IntervalGet()) {
            collected.add(new LocalNetworkInfoResult(aResult));
        }
        visitor.visitWifi(collected);
    }

    private StreamMobile buildNATStream(EthernetPacket packetEthernet, long interframegapNs) {
        WirelessEndpoint device = this.getMobilePort();
        StreamMobile apiMobileStream = device.TxStreamAdd();
        apiMobileStream.NumberOfFramesSet(10L);
        apiMobileStream.InterFrameGapSet(interframegapNs);
        UDPPacket udp = null;
        if (2048 == packetEthernet.getType()) {
            Ipv4Packet ipv4 = (Ipv4Packet)packetEthernet.getPayload();
            apiMobileStream.DestinationAddressSet(ipv4.getDestinationAddress());
            if (17 == ipv4.getProtocol()) {
                udp = (UDPPacket)ipv4.getPayload();
            }
        } else if (34525 == packetEthernet.getType()) {
            Ipv6Packet ipv6 = (Ipv6Packet)packetEthernet.getPayload();
            apiMobileStream.DestinationAddressSet(ipv6.getDestinationAddress());
            if (17 == ipv6.getNextHeader()) {
                udp = (UDPPacket)ipv6.getPayload();
            }
        } else {
            throw new IllegalStateException("Unsupport Transport layer");
        }
        if (udp == null) {
            throw new IllegalStateException("Only UDP NATDiscovery is supported on Endpoints");
        }
        apiMobileStream.DestinationPortSet(udp.getDestination());
        apiMobileStream.SourcePortSet(udp.getSource());
        FrameMobile frame = apiMobileStream.FrameAdd();
        ProtocolField payload = udp.getPayload();
        byte[] data = new byte[payload.getSize() / 8];
        payload.dump(data, 0);
        Formatter strData = new Formatter();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            strData.format("%02x", b);
            ++n2;
        }
        frame.PayloadSet(strData.toString());
        strData.close();
        return apiMobileStream;
    }

    @Override
    public RuntimePort.NatStream createNATStream(EthernetPacket packetEthernet, final long interframegapNs) {
        this.toNatKeepAlive.add(packetEthernet);
        final WirelessEndpoint device = this.getMobilePort();
        final ArrayList<StreamMobile> streams = new ArrayList<StreamMobile>();
        for (EthernetPacket packet : this.toNatKeepAlive) {
            StreamMobile apiMobileStream = this.buildNATStream(packet, interframegapNs);
            streams.add(apiMobileStream);
        }
        return new RuntimePort.NatStream(){

            @Override
            public void start(Context context) {
                RuntimeMobileDevice.this.prepareScenario();
                long heartbeat = RuntimeMobileDevice.this.getHeartBeat(TimeUnit.NANOSECONDS);
                long duration = 10L * interframegapNs + heartbeat * 10L;
                RuntimeMobileDevice.this.executeScenario(duration, TimeUnit.NANOSECONDS, context);
                for (StreamMobile apStream : streams) {
                    device.TxStreamRemove(apStream);
                }
            }
        };
    }

    @Override
    public void resultsToRefresh(RefreshableSet toRefresh) {
        NetworkInfoMonitorResultHistory hist = this.monitor.ResultHistoryGet();
        hist.Clear();
        toRefresh.add(new AbstractRefreshableResult[]{hist});
    }

    @Override
    public String getDockedInfo() {
        String name = this.apiMobile.DeviceInfoGet().GivenNameGet();
        String version = this.apiMobile.AppVersionGet();
        String serverAddr = this.getRuntimeServer().getName();
        return String.format("%s on %s - %s", name, serverAddr, version);
    }
}

