/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.LatencyBasic;
import com.excentis.products.byteblower.communication.api.LatencyDistributionMobile;
import com.excentis.products.byteblower.communication.api.LatencyDistributionResultHistory;
import com.excentis.products.byteblower.communication.api.LatencyDistributionResultSnapshot;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeLatencyBasic;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.SamplingConfiguration;
import com.excentis.products.byteblower.run.utils.LocalLatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.RefreshableSet;

public class RuntimeMobileLatencyDistributionRx
extends RuntimeLatencyBasic {
    private final RuntimePort rtPort;
    private LatencyDistributionMobile apiRx;

    public RuntimeMobileLatencyDistributionRx(RuntimeFbFlow rtFbFlow, RuntimeMobileDevice rtPort) {
        super(rtFbFlow, rtPort);
        this.rtPort = rtPort;
    }

    @Override
    public LatencyBasic getApiReceiver() {
        return null;
    }

    @Override
    public RuntimePort getRuntimePort() {
        return this.rtPort;
    }

    @Override
    public Filter getFilter() {
        return null;
    }

    @Override
    public void updateFilter() {
    }

    public LatencyDistributionMobile getApi() {
        if (this.apiRx == null) {
            this.apiRx = this.rtPort.getMobilePort().RxLatencyDistributionAdd();
            SamplingConfiguration config = this.getSamplingConfig();
            this.apiRx.ResultHistoryGet().SamplingIntervalDurationSet(config.getSampleDurationNs());
        }
        return this.apiRx;
    }

    @Override
    public void visit(RuntimeRx.TriggerVisitor v) {
        v.visit(this);
    }

    @Override
    public boolean isFinished() {
        DeviceStatus status = this.rtPort.getMobilePort().StatusGet();
        return !status.equals(DeviceStatus.Starting) && !status.equals(DeviceStatus.Running);
    }

    @Override
    public void visit(RuntimeRx.SnapshotVisitor v) {
        this.visitCumulativeSnapshots(v);
    }

    @Override
    public void visitCumulativeSnapshots(RuntimeRx.SnapshotVisitor visitor) {
        LatencyDistributionResultSnapshot apiResult = this.apiRx.ResultGet();
        visitor.visit(this.getRuntimePort(), new LocalLatencyDistributionSnapshot(apiResult));
    }

    @Override
    public void gatherRealtimeResults(RefreshableSet toRefresh) {
        LatencyDistributionResultHistory history = this.apiRx.ResultHistoryGet();
        history.Clear();
        toRefresh.add(new AbstractRefreshableResult[]{history});
    }
}

