/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.LatencyBasic;
import com.excentis.products.byteblower.communication.api.LatencyBasicMobile;
import com.excentis.products.byteblower.communication.api.LatencyBasicResultData;
import com.excentis.products.byteblower.communication.api.LatencyBasicResultHistory;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeLatencyBasic;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.SamplingConfiguration;
import com.excentis.products.byteblower.run.utils.LocalLatencyResultData;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;

public class RuntimeMobileLatencyRx
extends RuntimeLatencyBasic {
    private final RuntimePort rtPort;
    private LatencyBasicMobile apiRx;

    public RuntimeMobileLatencyRx(RuntimeFbFlow rtFbFlow, RuntimeMobileDevice rtPort) {
        super(rtFbFlow, rtPort);
        this.rtPort = rtPort;
    }

    @Override
    public LatencyBasic getApiReceiver() {
        return null;
    }

    @Override
    public RuntimePort getRuntimePort() {
        return this.rtPort;
    }

    @Override
    public Filter getFilter() {
        return null;
    }

    @Override
    public void updateFilter() {
    }

    public LatencyBasicMobile getApi() {
        if (this.apiRx == null) {
            this.apiRx = this.rtPort.getMobilePort().RxLatencyBasicAdd();
            SamplingConfiguration config = this.getSamplingConfig();
            this.apiRx.ResultHistoryGet().SamplingIntervalDurationSet(config.getSampleDurationNs());
        }
        return this.apiRx;
    }

    @Override
    public void visit(RuntimeRx.TriggerVisitor v) {
        v.visit(this);
    }

    @Override
    public boolean isFinished() {
        DeviceStatus status = this.rtPort.getMobilePort().StatusGet();
        return !status.equals(DeviceStatus.Starting) && !status.equals(DeviceStatus.Running);
    }

    @Override
    public void visit(RuntimeRx.SnapshotVisitor v) {
        LatencyBasicResultHistory history = this.apiRx.ResultHistoryGet();
        ArrayList<LocalLatencyResultData> latencyTriggers = new ArrayList<LocalLatencyResultData>();
        ArrayList<LocalTriggerResultData> throughputTriggers = new ArrayList<LocalTriggerResultData>();
        for (LatencyBasicResultData interval : history.IntervalGet()) {
            latencyTriggers.add(new LocalLatencyResultData(interval));
            throughputTriggers.add(new LocalTriggerResultData(interval));
        }
        if (!latencyTriggers.isEmpty()) {
            int incompleteSnapshot = latencyTriggers.size() - 1;
            latencyTriggers.remove(incompleteSnapshot);
            throughputTriggers.remove(incompleteSnapshot);
        }
        v.visit(this.rtPort, latencyTriggers.toArray(new LocalLatencyResultData[latencyTriggers.size()]));
        v.visit(this.rtPort, throughputTriggers.toArray(new LocalTriggerResultData[latencyTriggers.size()]));
    }

    @Override
    public void visitCumulativeSnapshots(RuntimeRx.SnapshotVisitor visitor) {
        LatencyBasicResultHistory history = this.apiRx.ResultHistoryGet();
        ArrayList<LocalLatencyResultData> latencyTriggers = new ArrayList<LocalLatencyResultData>();
        ArrayList<LocalTriggerResultData> throughputTriggers = new ArrayList<LocalTriggerResultData>();
        for (LatencyBasicResultData interval : history.CumulativeGet()) {
            latencyTriggers.add(new LocalLatencyResultData(interval));
            throughputTriggers.add(new LocalTriggerResultData(interval));
        }
        if (!latencyTriggers.isEmpty()) {
            int incompleteSnapshot = latencyTriggers.size() - 1;
            latencyTriggers.remove(incompleteSnapshot);
            throughputTriggers.remove(incompleteSnapshot);
        }
        visitor.visit(this.rtPort, latencyTriggers.toArray(new LocalLatencyResultData[latencyTriggers.size()]));
        visitor.visit(this.rtPort, throughputTriggers.toArray(new LocalTriggerResultData[throughputTriggers.size()]));
    }

    @Override
    public void gatherRealtimeResults(RefreshableSet toRefresh) {
        LatencyBasicResultHistory history = this.apiRx.ResultHistoryGet();
        history.Clear();
        toRefresh.add(new AbstractRefreshableResult[]{history});
    }
}

