/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.MulticastSourceFilter;
import com.excentis.products.byteblower.communication.api.StringList;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.MulticastSourceByteBlowerGuiPort;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.reader.impl.IpAddressReaderImpl;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;

public abstract class RuntimeMulticastSession
extends RuntimeObject {
    private final RuntimePort rtPort;
    private final MulticastMemberPort mMulticastMemberPort;

    RuntimeMulticastSession(RuntimePort rtPort, MulticastMemberPort mMulticastMemberPort) {
        this.rtPort = rtPort;
        this.mMulticastMemberPort = mMulticastMemberPort;
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.rtPort.getRuntimeScenario();
    }

    public RuntimePort getRuntimePort() {
        return this.rtPort;
    }

    public MulticastMemberPort getModelMulticastMemberPort() {
        return this.mMulticastMemberPort;
    }

    public MulticastGroup getModelMulticastGroup() {
        return this.mMulticastMemberPort.getMulticastGroup();
    }

    public boolean isIpv4() {
        boolean groupIpv4;
        boolean portIpv4 = this.rtPort.isRuntimeLayer3Ipv4();
        if (portIpv4 != (groupIpv4 = this.mMulticastMemberPort.getMulticastGroup().getMulticastIpAddress() instanceof Ipv4Address)) {
            throw new IllegalStateException();
        }
        return portIpv4;
    }

    public boolean isIpv6() {
        boolean groupIpv6;
        boolean portIpv6 = this.rtPort.isRuntimeLayer3Ipv6();
        if (portIpv6 != (groupIpv6 = this.mMulticastMemberPort.getMulticastGroup().getMulticastIpAddress() instanceof Ipv6Address)) {
            throw new IllegalStateException();
        }
        return portIpv6;
    }

    public MulticastSourceFilter getApiSourceFilter() {
        switch (this.mMulticastMemberPort.getMulticastSourceFilter()) {
            case INCLUDE: {
                return MulticastSourceFilter.Include;
            }
            case EXCLUDE: {
                return MulticastSourceFilter.Exclude;
            }
        }
        throw new IllegalStateException("Unsupported multicast filter type: " + this.mMulticastMemberPort.getMulticastSourceFilter());
    }

    public StringList getSourceGroupIpAddressesApiStringList() {
        MulticastSourceGroup mMulticastSourceGroup = this.mMulticastMemberPort.getMulticastSourceGroup();
        StringList apiMcSourceAddressStringList = new StringList();
        if (mMulticastSourceGroup == null) {
            return apiMcSourceAddressStringList;
        }
        for (IpAddress mMcSourceIpAddress : mMulticastSourceGroup.getIpAddresses()) {
            apiMcSourceAddressStringList.add(IpAddressReaderImpl.getAddress((IpAddress)mMcSourceIpAddress));
        }
        for (MulticastSourceByteBlowerGuiPort mMcSourcePort : mMulticastSourceGroup.getMulticastSourceByteBlowerGuiPort()) {
            RuntimePort rtMcSourcePort = this.getRuntimeScenario().findRuntimePort(mMcSourcePort.getByteBlowerGuiPort());
            apiMcSourceAddressStringList.add(rtMcSourcePort.getIPAddress());
        }
        return apiMcSourceAddressStringList;
    }
}

