/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.ByteBlowerPort;
import com.excentis.products.byteblower.communication.api.CapabilityList;
import com.excentis.products.byteblower.communication.api.EthernetConfiguration;
import com.excentis.products.byteblower.communication.api.Frame;
import com.excentis.products.byteblower.communication.api.HTTPClient;
import com.excentis.products.byteblower.communication.api.HTTPServer;
import com.excentis.products.byteblower.communication.api.IPv4Configuration;
import com.excentis.products.byteblower.communication.api.IPv6Configuration;
import com.excentis.products.byteblower.communication.api.Layer2Configuration;
import com.excentis.products.byteblower.communication.api.Layer3Configuration;
import com.excentis.products.byteblower.communication.api.Stream;
import com.excentis.products.byteblower.communication.api.VLANTag;
import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.PortForwardingReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.actions.ConfigurePort;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.actions.natdiscovery.AutoIPPortForward;
import com.excentis.products.byteblower.run.actions.natdiscovery.Direction;
import com.excentis.products.byteblower.run.actions.natdiscovery.DumbCache;
import com.excentis.products.byteblower.run.actions.natdiscovery.ManualIPPortForward;
import com.excentis.products.byteblower.run.actions.natdiscovery.NATCache;
import com.excentis.products.byteblower.run.filters.VlanFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.run.objects.PortHTTPConfig;
import com.excentis.products.byteblower.run.objects.RuntimeEthernetIIConfiguration;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrameRx;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.objects.RuntimeIPv4Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeIPv6Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeInterface;
import com.excentis.products.byteblower.run.objects.RuntimeLayer25Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer2Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import com.excentis.products.byteblower.run.objects.RuntimeTriggerBasic;
import com.excentis.products.byteblower.run.objects.RuntimeVlanConfiguration;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import com.excentis.products.byteblower.run.utils.LocalNetworkInfoResult;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import com.excentis.products.byteblower.run.utils.ReverseIterator;
import com.excentis.products.byteblower.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.collections.IteratorUtils;

public class RuntimePort
extends RuntimeObject {
    private State state;
    private final Collection<RuntimeFrameTx> outGoingFrames = new ArrayList<RuntimeFrameTx>();
    private final Collection<RuntimeFrameRx> arrivingFrames = new ArrayList<RuntimeFrameRx>();
    private final RuntimeScenario rtScenario;
    private final RuntimeInterface rtInterface;
    private ByteBlowerPort apiPort = null;
    private WirelessEndpoint apiMobile = null;
    private final ByteBlowerGuiPort mPort;
    private final ByteBlowerGuiPortReader mPortReader;
    private RuntimeLayer2Configuration rtL2Config = null;
    private List<RuntimeLayer25Configuration> rtL25ConfigList = new ArrayList<RuntimeLayer25Configuration>();
    protected RuntimeLayer3Configuration rtL3Config = null;
    private List<Stream> configStreams = new ArrayList<Stream>();
    private final PortHTTPConfig httpConfig;
    private Map<String, String> macResolutions = new HashMap<String, String>();
    private NATCache natCache;
    private long nextKeepAlive = this.calcNextKeepAlive();

    private RuntimePort(RuntimeScenario rtScenario, RuntimeInterface rtInterface, ByteBlowerGuiPort modelPort) {
        PortForwardingReader forwardReader;
        this.rtScenario = rtScenario;
        this.rtInterface = rtInterface;
        this.mPort = modelPort;
        this.mPortReader = ReaderFactory.create((ByteBlowerGuiPort)modelPort);
        this.state = State.CREATED;
        this.httpConfig = new PortHTTPConfig(this);
        PortForwarding portForward = this.mPortReader.getPortForwarding();
        this.natCache = portForward != null && modelPort.isSetIpv4Configuration() ? ((forwardReader = ReaderFactory.create((PortForwarding)portForward)).isAutomaticPublicIpv4() ? new AutoIPPortForward(forwardReader) : new ManualIPPortForward(forwardReader)) : new DumbCache();
    }

    protected RuntimePort(RuntimeScenario rtScenario, RuntimeInterface rtInterface, ByteBlowerPort apiPort, ByteBlowerGuiPort mPort) {
        this(rtScenario, rtInterface, mPort);
        this.apiPort = apiPort;
    }

    RuntimePort(RuntimeScenario rtScenario, RuntimeInterface rtInterface, WirelessEndpoint apiPort, ByteBlowerGuiPort mPort) {
        this(rtScenario, rtInterface, mPort);
        this.apiMobile = apiPort;
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.rtScenario;
    }

    public RuntimeInterface getRuntimeInterface() {
        return this.rtInterface;
    }

    public RuntimeServer getRuntimeServer() {
        return this.rtInterface.getRuntimeServer();
    }

    public ByteBlowerPort getApiPort() {
        return this.apiPort;
    }

    public WirelessEndpoint getMobilePort() {
        return this.apiMobile;
    }

    public ByteBlowerGuiPort getModelPort() {
        return this.mPort;
    }

    public ByteBlowerGuiPortReader getModelPortReader() {
        return this.mPortReader;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getName() {
        return this.mPort.getName();
    }

    public String getInterfaceName() {
        return this.apiPort.GetByteBlowerInterface().NameGet();
    }

    public boolean isRuntimeLayer2Configured() {
        return this.rtL2Config != null;
    }

    public boolean isRuntimeLayer2Ethernet() {
        return this.rtL2Config instanceof RuntimeEthernetIIConfiguration;
    }

    public RuntimeLayer2Configuration getRuntimeLayer2Configuration() {
        return this.rtL2Config;
    }

    public RuntimeLayer2Configuration configureRuntimeLayer2Configuration(Layer2Configuration apiL2Config) {
        if (this.rtL2Config != null) {
            throw new IllegalStateException("rtLayer2 should not be set twice");
        }
        if (!(apiL2Config instanceof EthernetConfiguration)) {
            throw new IllegalStateException("Unsupported layer2 port configuration " + apiL2Config.getClass().getSimpleName());
        }
        this.rtL2Config = new RuntimeEthernetIIConfiguration(this, (EthernetConfiguration)apiL2Config);
        return this.rtL2Config;
    }

    public boolean isRuntimeLayer25Empty() {
        return this.rtL25ConfigList.isEmpty();
    }

    public int getLayer25OverheadSize() {
        int sum = 0;
        for (RuntimeLayer25Configuration config : this.rtL25ConfigList) {
            sum += config.getHeaderSize();
        }
        return sum;
    }

    public Iterator<RuntimeLayer25Configuration> layer25ConfigurationOuterIterator() {
        return IteratorUtils.unmodifiableIterator(this.rtL25ConfigList.iterator());
    }

    public Iterator<RuntimeLayer25Configuration> layer25ConfigurationInnerIterator() {
        ListIterator<RuntimeLayer25Configuration> g = this.rtL25ConfigList.listIterator(this.rtL25ConfigList.size());
        ReverseIterator<RuntimeLayer25Configuration> result = new ReverseIterator<RuntimeLayer25Configuration>(g);
        return IteratorUtils.unmodifiableIterator(result);
    }

    public List<RuntimeLayer25Configuration> getRuntimeLayer25Configuration() {
        if (this.rtL25ConfigList != null) {
            return this.rtL25ConfigList;
        }
        return Collections.emptyList();
    }

    public RuntimeLayer25Configuration addRuntimeLayer25Configuration(VLANTag apiL25Config, Vlan vlan) {
        if (this.rtL2Config == null) {
            throw new IllegalStateException("rtLayer25 should not be set before rtLayer2");
        }
        RuntimeVlanConfiguration rtL25Config = new RuntimeVlanConfiguration(this, vlan, apiL25Config);
        this.rtL25ConfigList.add(rtL25Config);
        return rtL25Config;
    }

    public boolean isRuntimeLayer3Configured() {
        return this.rtL3Config != null;
    }

    public boolean isRuntimeLayer3Ipv4() {
        return this.rtL3Config instanceof RuntimeIPv4Configuration;
    }

    public boolean isRuntimeLayer3Ipv6() {
        return this.rtL3Config instanceof RuntimeIPv6Configuration;
    }

    public RuntimeLayer3Configuration getRuntimeLayer3Configuration() {
        return this.rtL3Config;
    }

    public RuntimeLayer3Configuration configureRuntimeLayer3Configuration(Layer3Configuration apiL3Config) {
        if (this.rtL2Config == null) {
            throw new IllegalStateException("rtLayer3 should not be set before rtLayer2");
        }
        if (this.rtL3Config != null) {
            throw new IllegalStateException("rtLayer3 should not be set twice");
        }
        if (apiL3Config instanceof IPv4Configuration) {
            this.rtL3Config = new RuntimeIPv4Configuration(this, (IPv4Configuration)apiL3Config);
        } else if (apiL3Config instanceof IPv6Configuration) {
            this.rtL3Config = new RuntimeIPv6Configuration(this, (IPv6Configuration)apiL3Config);
        } else {
            throw new IllegalStateException("Unsupported layer3 port configuration " + apiL3Config.getClass().getSimpleName());
        }
        return this.rtL3Config;
    }

    public RuntimeHttpServer addRuntimeHttpServer(HTTPServer apiHttpServer, TcpFlow mHttpFlowTemplate) {
        return this.httpConfig.addRuntimeHttpServer(apiHttpServer, mHttpFlowTemplate);
    }

    public boolean hasRuntimeHttpServer(TcpFlow mHttpFlowTemplate) {
        return this.findRuntimeHttpServer(mHttpFlowTemplate) != null;
    }

    public RuntimeHttpServer findRuntimeHttpServer(TcpFlow mHttpFlowTemplate) {
        return this.httpConfig.findRuntimeHttpServer(mHttpFlowTemplate);
    }

    public RuntimeHttpClient addRuntimeHttpClient(HTTPClient apiHttpClient, RuntimeHttpFlow rtHttpFlow) {
        return this.httpConfig.addRuntimeHttpClient(apiHttpClient, rtHttpFlow);
    }

    public boolean isNatted() {
        return this.mPort.getPortForwarding() != null || this.mPort.isNatted();
    }

    public String getIPAddress() {
        if (this.rtL3Config != null) {
            return this.rtL3Config.getIPAddress();
        }
        return null;
    }

    private void addResolvedMacAddress(String ipAddress, String macAddress) {
        this.macResolutions.put(ipAddress, macAddress);
    }

    public String getGateway() {
        return this.rtL3Config.getGateway();
    }

    public String getPrefix() {
        return this.rtL3Config.getPrefix();
    }

    public String resolve(String ip) {
        return this.resolve(ip, false);
    }

    public String resolve(String ip, boolean shouldFailEarly) {
        String macAddr = this.macResolutions.get(ip);
        if (macAddr == null) {
            macAddr = this.rtL3Config.resolve(ip, shouldFailEarly);
            this.addResolvedMacAddress(ip, macAddr);
        }
        return macAddr;
    }

    public boolean hasVlanFilter() {
        return this.getModelPortReader().getVlanStack() != null && !this.getModelPortReader().getVlanStack().getVlans().isEmpty();
    }

    public Filter getVlanFilter() {
        boolean first = true;
        Filter vlanFilter = null;
        for (Vlan vlan : this.getModelPortReader().getVlanStack().getVlans()) {
            VlanFilter part = VlanFilter.createVlanFilter(Short.toString(vlan.getVlanId()));
            if (first) {
                vlanFilter = part;
                first = false;
                continue;
            }
            vlanFilter = Filter.and(vlanFilter, (Filter)part);
        }
        return vlanFilter;
    }

    public NATCache query(Direction dir) {
        return this.natCache;
    }

    public boolean isRuntimeLayer25SingleVlan() {
        throw new RuntimeException("Not valid anymore, VLAN stack");
    }

    public int getLayer2OverheadSize() {
        return this.getRuntimeLayer2Configuration().getHeaderSize();
    }

    public AbstractAction createConfigureAction(AbstractAction action) {
        return ConfigurePort.create(action.getContext(), this);
    }

    public RuntimeRx createBasicTrigger(RuntimeFbFlow rtFbFlow) {
        return new RuntimeTriggerBasic(rtFbFlow, this);
    }

    public String getMacAddressString() {
        return ((RuntimeEthernetIIConfiguration)this.getRuntimeLayer2Configuration()).getMacAddressString();
    }

    public boolean isMobile() {
        return false;
    }

    public String getDockedInfo() {
        return this.mPortReader.getDockedStatus();
    }

    public void release() {
    }

    public void resetResults() {
    }

    public void addTxFrame(RuntimeFrameTx rtFrameTx) {
        this.outGoingFrames.add(rtFrameTx);
    }

    public Collection<RuntimeFrameTx> getOutgoingFrames() {
        return Collections.unmodifiableCollection(this.outGoingFrames);
    }

    void addArrivingFrame(RuntimeFrameRx rxFrame) {
        this.arrivingFrames.add(rxFrame);
    }

    public Collection<RuntimeFrameRx> getRxFrames() {
        return Collections.unmodifiableCollection(this.arrivingFrames);
    }

    List<RuntimeFrameRx> getRxFrames(RuntimeFlow rtFlow) {
        ArrayList<RuntimeFrameRx> rxFrames = new ArrayList<RuntimeFrameRx>();
        for (RuntimeFrameRx frame : this.arrivingFrames) {
            if (!rtFlow.equals(frame.getRuntimeFlow())) continue;
            rxFrames.add(frame);
        }
        return rxFrames;
    }

    void remove(RuntimeFrameRx oldFrame) {
        this.arrivingFrames.remove(oldFrame);
    }

    public String toString() {
        return "rt " + this.getName();
    }

    public boolean supportsRestart() {
        if (this.apiMobile != null) {
            return this.apiMobile.CapabilityIsSupported("Tcp.Restart");
        }
        return true;
    }

    public NatStream createNATStream(EthernetPacket packetEthernet, long inferframeGapNs) {
        final Stream stream = this.apiPort.TxStreamAdd();
        this.configStreams.add(stream);
        int byteSize = packetEthernet.getSize() / 8;
        byte[] buffer = new byte[byteSize];
        packetEthernet.dump(buffer, 0);
        String frameHexBytes = Utils.bufferToHexString((byte[])buffer, (int)buffer.length);
        Frame apiTxFrame = stream.FrameAdd();
        apiTxFrame.BytesSet(frameHexBytes);
        apiTxFrame.SetL3AutoChecksum(true);
        apiTxFrame.SetL3AutoLength(true);
        apiTxFrame.SetL4AutoChecksum(true);
        apiTxFrame.SetL4AutoLength(true);
        stream.InitialTimeToWaitSet(0L);
        stream.NumberOfFramesSet(1000000000L);
        stream.InterFrameGapSet(inferframeGapNs);
        return new NatStream(){

            @Override
            public void start(Context context) {
                stream.Start();
            }
        };
    }

    public boolean fetchResults() {
        return true;
    }

    public Supplier<Boolean> prepareForTestRun() {
        long proposedWaitTime = 0L;
        for (Stream aStream : this.configStreams) {
            aStream.Stop();
            this.apiPort.TxStreamRemove(aStream);
            proposedWaitTime = 250L;
        }
        this.configStreams.clear();
        long waitTime = proposedWaitTime;
        long startWait = System.currentTimeMillis();
        return () -> {
            if (System.currentTimeMillis() - startWait > waitTime) {
                return true;
            }
            return false;
        };
    }

    private long calcNextKeepAlive() {
        long second = 1000L;
        long now = System.currentTimeMillis();
        long minimumDuration = 100L * second;
        long variation = (long)(50.0 * Math.random() * (double)second);
        return now + minimumDuration + variation;
    }

    private void doKeepAlive() {
        long now = System.currentTimeMillis();
        if (!this.isMobile() && this.isRuntimeLayer3Ipv4() && this.nextKeepAlive - now < 0L) {
            this.nextKeepAlive = this.calcNextKeepAlive();
            try {
                ((IPv4Configuration)this.rtL3Config.getApiConfiguration()).ProtocolGratuitousArpReply();
                System.out.format("Sent out an  GratuisousARP\n", new Object[0]);
            }
            catch (Exception exception) {}
        }
    }

    public void resultsToRefresh(RefreshableSet toRefresh) {
    }

    public void visit(PortVisit visitor) {
    }

    public boolean supportsTcpPrague() {
        if (this.apiMobile != null) {
            CapabilityList caps = this.apiMobile.CapabilityListGet();
            System.out.println(caps);
            return this.apiMobile.CapabilityIsSupported("Tcp.L4S");
        }
        return true;
    }

    public static interface NatStream {
        public void start(Context var1);
    }

    public static interface PortVisit {
        public void visitWifi(List<LocalNetworkInfoResult> var1);
    }

    public static enum State {
        CREATED,
        CONFIGURED_AND_WAITING_FOR_ASYNC,
        CONFIGURED,
        FAILED;

    }
}

