/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class SamplingConfiguration {
    static final long EXPECTED_SAMPLES = 100L;
    static final long MIN_SAMPLING_INTERVAL = TimeUnit.MILLISECONDS.toNanos(10L);
    static final long MAX_SAMPLING_INTERVAL = TimeUnit.SECONDS.toNanos(1L);
    static final long TIME_BUFFERED = TimeUnit.SECONDS.toNanos(10L);
    private final long sampleNs;
    private final long bufferSize;

    static {
        assert (SamplingConfiguration.clamp(0L, 1L, 100L) == 1L);
        assert (SamplingConfiguration.clamp(0L, -1L, 100L) == 0L);
        assert (SamplingConfiguration.clamp(0L, 111L, 100L) == 100L);
        assert (SamplingConfiguration.samplingMagnitude(0L) == 10L) : "Underflow check";
        assert (SamplingConfiguration.samplingMagnitude(142256123L) == 100000000L) : "Common case";
        assert (SamplingConfiguration.samplingMagnitude(1000000000L) == 1000000000L) : "Exact case";
        assert (Math.log10(SamplingConfiguration.samplingMagnitude(Long.MAX_VALUE)) < Math.log10(9.223372036854776E18)) : "No Overflow";
        assert (Math.log10(SamplingConfiguration.samplingMagnitude(Long.MAX_VALUE)) > Math.log10(9.223372036854776E18) - 1.0) : "highest result";
    }

    private SamplingConfiguration(long sampleNs, long bufferSize) {
        this.sampleNs = sampleNs;
        this.bufferSize = bufferSize;
    }

    public SamplingConfiguration(HighResolutionDuration highResolutionDuration) {
        this(Duration.ofNanos(highResolutionDuration.getTimeInNanoseconds()));
    }

    public SamplingConfiguration(Duration duration) {
        this(SamplingConfiguration.samplingInterval(duration), SamplingConfiguration.samples(duration));
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public long getSampleDurationNs() {
        return this.sampleNs;
    }

    private static long samplingInterval(Duration totalDuration) {
        long intervalDuration = SamplingConfiguration.samplingMagnitude(totalDuration.toNanos() / 100L);
        return SamplingConfiguration.clamp(MIN_SAMPLING_INTERVAL, intervalDuration, MAX_SAMPLING_INTERVAL);
    }

    private static long samples(Duration totalDuration) {
        long intervalDuration = SamplingConfiguration.samplingInterval(totalDuration);
        return TIME_BUFFERED / intervalDuration;
    }

    private static long clamp(long min, long val, long max) {
        long lowerBound = Math.max(min, val);
        long inBoundaries = Math.min(max, lowerBound);
        return inBoundaries;
    }

    private static long samplingMagnitude(long val) {
        long nextPower;
        long result = 10L;
        while (val >= (nextPower = result * 10L) && (result = nextPower) < 0xCCCCCCCCCCCCCCCL) {
        }
        return result;
    }
}

