/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.utils;

import com.excentis.products.byteblower.communication.api.NetworkInfo;
import com.excentis.products.byteblower.communication.api.NetworkInfoMonitorResultData;
import com.excentis.products.byteblower.communication.api.NetworkInterface;
import com.excentis.products.byteblower.communication.api.NetworkInterfaceType;
import com.excentis.products.byteblower.communication.api.WiFiBand;
import com.excentis.products.byteblower.communication.api.WiFiLink;
import com.excentis.products.byteblower.communication.api.WiFiLinkList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class LocalNetworkInfoResult {
    public static final long UNDEFINED_MOMENT = 0L;
    final long timestamp;
    final Collection<LocalNetworkInterface> netifs;

    public LocalNetworkInfoResult(NetworkInfoMonitorResultData data) {
        this.timestamp = data.TimestampGet();
        this.netifs = new ArrayList<LocalNetworkInterface>();
        for (NetworkInterface info : data.InterfaceGet()) {
            LocalNetworkInterface result = new LocalNetworkInterface(info);
            this.netifs.add(result);
        }
    }

    public LocalNetworkInfoResult(NetworkInfo data) {
        this.timestamp = 0L;
        this.netifs = new ArrayList<LocalNetworkInterface>();
        for (NetworkInterface api : data.InterfaceGet()) {
            this.netifs.add(new LocalNetworkInterface(api));
        }
    }

    public long TimestampGet() {
        return this.timestamp;
    }

    public Collection<LocalNetworkInterface> InterfaceGet() {
        return this.netifs;
    }

    public boolean untimedResults() {
        return this.timestamp == 0L;
    }

    public static class LocalNetworkInterface {
        public final String name;
        public final long rssi;
        public final String bssid;
        public final String ssid;
        public final NetIfType type;
        public final Collection<LocalWiFiLink> wiFiLinks;

        public LocalNetworkInterface(NetworkInterface info) {
            this.name = info.DisplayNameGet();
            this.rssi = info.WiFiRssiGet();
            this.bssid = info.WiFiBssidGet();
            this.ssid = info.WiFiSsidGet();
            this.wiFiLinks = LocalNetworkInterface.collectLinks(info);
            this.type = info.TypeGet() == NetworkInterfaceType.Ethernet ? NetIfType.Ethernet : (info.TypeGet() == NetworkInterfaceType.WiFi ? NetIfType.WiFi : NetIfType.Other);
        }

        private static Collection<LocalWiFiLink> collectLinks(NetworkInterface info) {
            WiFiLinkList links = info.WiFiLinkGet();
            if (links.isEmpty() && info.TypeGet() == NetworkInterfaceType.WiFi) {
                return LocalNetworkInterface.legacyLink(info);
            }
            if (links.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<LocalWiFiLink> wiFiLinks = new ArrayList<LocalWiFiLink>();
            for (WiFiLink ll : links) {
                wiFiLinks.add(new LocalWiFiLink(ll));
            }
            return wiFiLinks;
        }

        private static Collection<LocalWiFiLink> legacyLink(NetworkInterface info) {
            ArrayList<LocalWiFiLink> ll = new ArrayList<LocalWiFiLink>();
            ll.add(new LocalWiFiLink(info));
            return ll;
        }
    }

    public static class LocalWiFiLink {
        public static final long NON_MLO = 0L;
        public final String apMac;
        public final long channel;
        public final long frequency;
        public final WiFiBand frequencyBand;
        public final long id;
        public final long rssi;
        public final long rxLinkSpeed;
        public final String staMac;
        public final long txLinkSpeed;

        public LocalWiFiLink(WiFiLink link) {
            this.apMac = link.ApMacGet();
            this.channel = link.ChannelGet();
            this.frequency = link.FrequencyGet();
            this.frequencyBand = link.FrequencyBandGet();
            this.id = link.LinkIdGet();
            this.rssi = link.RssiGet();
            this.rxLinkSpeed = link.RxLinkSpeedGet();
            this.staMac = link.StaMacGet();
            this.txLinkSpeed = link.TxLinkSpeedGet();
        }

        public LocalWiFiLink(NetworkInterface info) {
            this.apMac = info.MacGet();
            this.channel = info.WiFiChannelGet();
            this.frequency = 0L;
            this.frequencyBand = WiFiBand.Unknown;
            this.id = 0L;
            this.rssi = info.WiFiRssiGet();
            this.rxLinkSpeed = info.WiFiRxRateGet();
            this.staMac = info.WiFiBssidGet();
            this.txLinkSpeed = info.WiFiTxRateGet();
        }
    }

    public static enum NetIfType {
        Ethernet,
        WiFi,
        Other;

    }
}

