/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.utils;

import com.excentis.products.byteblower.communication.api.OutOfSequenceResultData;
import com.excentis.products.byteblower.run.utils.TimeStamped;

public class LocalOutOfSequenceResultData
implements TimeStamped {
    private long timestamp;
    private long timestampFirst;
    private long timestampLast;
    private long packetCount;
    private long byteCount;
    private int frameSizeMax;
    private int frameSizeMin;
    private long packetCountValid;
    private long packetCountInvalid;
    private long packetCountOutOfSequence;
    private long intervalDuration;

    public LocalOutOfSequenceResultData() {
    }

    public LocalOutOfSequenceResultData(OutOfSequenceResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.packetCount = orig.PacketCountGet();
        this.byteCount = orig.ByteCountGet();
        this.intervalDuration = orig.IntervalDurationGet();
        if (this.packetCount > 0L) {
            this.timestampFirst = orig.TimestampFirstGet();
            this.timestampLast = orig.TimestampLastGet();
            this.frameSizeMin = orig.FramesizeMinimumGet();
            this.frameSizeMax = orig.FramesizeMaximumGet();
            this.packetCountValid = orig.PacketCountValidGet();
            this.packetCountInvalid = orig.PacketCountInvalidGet();
            this.packetCountOutOfSequence = orig.PacketCountOutOfSequenceGet();
        }
    }

    public LocalOutOfSequenceResultData(LocalOutOfSequenceResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.timestampFirst = orig.TimestampFirstGet();
        this.timestampLast = orig.TimestampLastGet();
        this.packetCount = orig.PacketCountGet();
        this.byteCount = orig.ByteCountGet();
        this.frameSizeMax = orig.FramesizeMaximumGet();
        this.frameSizeMin = orig.FramesizeMinimumGet();
        this.packetCountValid = orig.PacketCountValidGet();
        this.packetCountInvalid = orig.PacketCountInvalidGet();
        this.packetCountOutOfSequence = orig.PacketCountOutOfSequenceGet();
        this.intervalDuration = orig.IntervalDurationGet();
    }

    public long PacketCountOutOfSequenceGet() {
        return this.packetCountOutOfSequence;
    }

    public long PacketCountInvalidGet() {
        return this.packetCountInvalid;
    }

    public long PacketCountValidGet() {
        return this.packetCountValid;
    }

    @Override
    public long TimestampGet() {
        return this.timestamp;
    }

    public long TimestampFirstGet() {
        return this.timestampFirst;
    }

    public long TimestampLastGet() {
        return this.timestampLast;
    }

    public long PacketCountGet() {
        return this.packetCount;
    }

    public long ByteCountGet() {
        return this.byteCount;
    }

    public int FramesizeMaximumGet() {
        return this.frameSizeMax;
    }

    public int FramesizeMinimumGet() {
        return this.frameSizeMin;
    }

    public long IntervalDurationGet() {
        return this.intervalDuration;
    }

    public LocalOutOfSequenceResultData add(LocalOutOfSequenceResultData oth) {
        LocalOutOfSequenceResultData result = new LocalOutOfSequenceResultData();
        result.timestamp = this.timestamp;
        result.intervalDuration = this.intervalDuration;
        result.timestampFirst = Math.min(oth.timestampFirst, this.timestampFirst);
        result.timestampLast = Math.max(oth.timestampLast, this.timestampLast);
        result.packetCount = oth.packetCount + this.packetCount;
        result.byteCount = oth.byteCount + this.byteCount;
        result.frameSizeMax = Math.max(oth.frameSizeMax, this.frameSizeMax);
        result.frameSizeMin = Math.min(oth.frameSizeMin, this.frameSizeMin);
        result.packetCountValid = oth.packetCountValid + this.packetCountValid;
        result.packetCountInvalid = oth.packetCountInvalid + this.packetCountInvalid;
        return result;
    }
}

