/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.utils;

import com.excentis.products.byteblower.communication.api.DomainError;
import com.excentis.products.byteblower.communication.api.TCPConnectionState;
import com.excentis.products.byteblower.communication.api.TCPResultData;
import com.excentis.products.byteblower.run.utils.Addable;
import java.math.BigInteger;
import java.util.logging.Logger;

public class LocalTcpResultData
implements Addable<LocalTcpResultData> {
    private static final Logger LOGGER = Logger.getGlobal();
    private long timestamp;
    private long rxByteCountHeader;
    private long rxByteCountPayload;
    private long rxByteCountTotal;
    private long rxTimestampLast;
    private long txByteCountHeader;
    private long txByteCountPayload;
    private long txByteCountTotal;
    private long txTimestampLast;
    private TCPConnectionState connectionState;
    private long congestionWindowCurrent;
    private long congestionWindowMaximum;
    private long congestionWindowMinimum = Long.MAX_VALUE;
    private long receiverWindowCurrent;
    private long receiverWindowMaximum;
    private long receiverWindowMinimum = Long.MAX_VALUE;
    private long roundTripTimeAverage;
    private long roundTripTimeMaximum;
    private long roundTripTimeMinimum = Long.MAX_VALUE;
    private long slowStartThresholdCurrent;
    private long slowStartThresholdMinimum = Long.MAX_VALUE;
    private long slowStartThresholdMaximum;
    private long retransmissionCountTotal;
    private long retransmissionCountSlow;
    private long retransmissionCountFast;
    private long rxSegmentCountTotal;
    private long rxSegmentCountOutOfOrder;
    private long txSegmentCountTotal;
    private long numberOfSynReceived;
    private long timestampSynReceived;
    private long numberOfSynSent;
    private long timestampSynSent;
    private long numberOfFinSent;
    private long timestampFinSent;
    private long numberOfFinReceived;
    private long timestampFinReceived;
    private long intervalDuration;
    private long flightSizeMaximum;
    private long flightSizeMinimum;
    private long timestampEstablished;
    private long flightSizeCurrent;
    private long rxLocalCongestionNotificationCount;
    private long rxRemoteCongestionNotificationCount;

    public LocalTcpResultData() {
        this.connectionState = TCPConnectionState.LISTEN;
    }

    public LocalTcpResultData(LocalTcpResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.rxByteCountHeader = orig.RxByteCountHeaderGet();
        this.rxByteCountPayload = orig.RxByteCountPayloadGet();
        this.rxByteCountTotal = orig.RxByteCountTotalGet();
        this.rxTimestampLast = orig.RxTimestampLastGet();
        this.txByteCountHeader = orig.TxByteCountHeaderGet();
        this.txByteCountPayload = orig.TxByteCountPayloadGet();
        this.txByteCountTotal = orig.TxByteCountTotalGet();
        this.txTimestampLast = orig.TxTimestampLastGet();
        this.connectionState = orig.ConnectionStateGet();
        this.congestionWindowCurrent = orig.CongestionWindowCurrentGet();
        this.congestionWindowMaximum = orig.CongestionWindowMaximumGet();
        this.congestionWindowMinimum = orig.CongestionWindowMinimumGet();
        this.receiverWindowCurrent = orig.ReceiverWindowCurrentGet();
        this.receiverWindowMaximum = orig.ReceiverWindowMaximumGet();
        this.receiverWindowMinimum = orig.ReceiverWindowMinimumGet();
        this.roundTripTimeAverage = orig.RoundTripTimeAverageGet();
        this.roundTripTimeMaximum = orig.RoundTripTimeMaximumGet();
        this.roundTripTimeMinimum = orig.RoundTripTimeMinimumGet();
        this.slowStartThresholdCurrent = orig.SlowStartThresholdCurrentGet();
        this.slowStartThresholdMinimum = orig.SlowStartThresholdMinimumGet();
        this.slowStartThresholdMaximum = orig.SlowStartThresholdMaximumGet();
        this.retransmissionCountTotal = orig.RetransmissionCountTotalGet();
        this.retransmissionCountSlow = orig.RetransmissionCountSlowGet();
        this.retransmissionCountFast = orig.RetransmissionCountFastGet();
        this.rxSegmentCountTotal = orig.RxSegmentCountTotalGet();
        this.rxSegmentCountOutOfOrder = orig.RxSegmentCountOutOfOrderGet();
        this.txSegmentCountTotal = orig.TxSegmentCountTotalGet();
        this.numberOfSynReceived = orig.NumberOfSynReceivedGet();
        this.timestampSynReceived = orig.TimestampSynReceivedGet();
        this.numberOfSynSent = orig.NumberOfSynSentGet();
        this.timestampSynSent = orig.TimestampSynSentGet();
        this.numberOfFinSent = orig.NumberOfFinSentGet();
        this.timestampFinSent = orig.TimestampFinSentGet();
        this.numberOfFinReceived = orig.NumberOfFinReceivedGet();
        this.timestampFinReceived = orig.TimestampFinReceivedGet();
        this.intervalDuration = orig.IntervalDurationGet();
        this.flightSizeMaximum = orig.FlightSizeMaximumGet();
        this.flightSizeMinimum = orig.FlightSizeMinimumGet();
        this.timestampEstablished = orig.TimestampEstablishedGet();
        this.flightSizeCurrent = orig.FlightSizeCurrentGet();
        this.rxLocalCongestionNotificationCount = orig.rxLocalCongestionNotificationCount;
        this.rxRemoteCongestionNotificationCount = orig.rxRemoteCongestionNotificationCount;
    }

    public LocalTcpResultData(TCPResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.rxByteCountHeader = orig.RxByteCountHeaderGet();
        this.rxByteCountPayload = orig.RxByteCountPayloadGet();
        this.rxByteCountTotal = orig.RxByteCountTotalGet();
        if (this.rxByteCountTotal > 0L) {
            this.rxTimestampLast = orig.RxTimestampLastGet();
        }
        this.txByteCountHeader = orig.TxByteCountHeaderGet();
        this.txByteCountPayload = orig.TxByteCountPayloadGet();
        this.txByteCountTotal = orig.TxByteCountTotalGet();
        if (this.txByteCountTotal > 0L) {
            this.txTimestampLast = orig.TxTimestampLastGet();
        }
        this.connectionState = orig.ConnectionStateGet();
        this.congestionWindowCurrent = orig.CongestionWindowCurrentGet();
        this.congestionWindowMaximum = orig.CongestionWindowMaximumGet();
        this.congestionWindowMinimum = orig.CongestionWindowMinimumGet();
        this.receiverWindowCurrent = orig.ReceiverWindowCurrentGet();
        this.receiverWindowMaximum = orig.ReceiverWindowMaximumGet();
        this.receiverWindowMinimum = orig.ReceiverWindowMinimumGet();
        try {
            this.roundTripTimeAverage = orig.RoundTripTimeAverageGet();
        }
        catch (DomainError domainError) {
            this.roundTripTimeAverage = orig.RoundTripTimeCurrentGet();
        }
        this.roundTripTimeMaximum = orig.RoundTripTimeMaximumGet();
        this.roundTripTimeMinimum = orig.RoundTripTimeMinimumGet();
        this.slowStartThresholdCurrent = orig.SlowStartThresholdCurrentGet();
        this.slowStartThresholdMinimum = orig.SlowStartThresholdMinimumGet();
        this.slowStartThresholdMaximum = orig.SlowStartThresholdMaximumGet();
        this.retransmissionCountTotal = orig.RetransmissionCountTotalGet();
        this.retransmissionCountSlow = orig.RetransmissionCountSlowGet();
        this.retransmissionCountFast = orig.RetransmissionCountFastGet();
        this.rxSegmentCountTotal = orig.RxSegmentCountTotalGet();
        this.rxSegmentCountOutOfOrder = orig.RxSegmentCountOutOfOrderGet();
        this.txSegmentCountTotal = orig.TxSegmentCountTotalGet();
        this.numberOfSynReceived = orig.NumberOfSynReceivedGet();
        if (this.numberOfSynReceived > 0L) {
            this.timestampSynReceived = orig.TimestampSynReceivedGet();
        }
        this.numberOfSynSent = orig.NumberOfSynSentGet();
        if (this.numberOfSynSent > 0L) {
            this.timestampSynSent = orig.TimestampSynSentGet();
        }
        this.numberOfFinSent = orig.NumberOfFinSentGet();
        if (this.numberOfFinSent > 0L) {
            this.timestampFinSent = orig.TimestampFinSentGet();
        }
        this.numberOfFinReceived = orig.NumberOfFinReceivedGet();
        if (this.numberOfFinReceived > 0L) {
            this.timestampFinReceived = orig.TimestampFinReceivedGet();
        }
        this.intervalDuration = orig.IntervalDurationGet();
        this.flightSizeMaximum = orig.FlightSizeMaximumGet();
        this.flightSizeMinimum = orig.FlightSizeMinimumGet();
        if (this.rxByteCountTotal > 0L) {
            this.timestampEstablished = orig.TimestampEstablishedGet();
        }
        this.flightSizeCurrent = orig.FlightSizeCurrentGet();
        try {
            this.rxLocalCongestionNotificationCount = orig.RxLocalCongestionNotificationCountGet();
            this.rxRemoteCongestionNotificationCount = orig.RxRemoteCongestionNotificationCountGet();
        }
        catch (DomainError domainError) {
            LOGGER.warning("NO ECN support on this server. Update the server");
            this.rxLocalCongestionNotificationCount = 0L;
            this.rxRemoteCongestionNotificationCount = 0L;
        }
    }

    public long TimestampGet() {
        return this.timestamp;
    }

    public long RxLocalCongestionNotificationCountGet() {
        return this.rxLocalCongestionNotificationCount;
    }

    public long RxRemoteCongestionNotificationCountGet() {
        return this.rxRemoteCongestionNotificationCount;
    }

    public long RxByteCountHeaderGet() {
        return this.rxByteCountHeader;
    }

    public long RxByteCountPayloadGet() {
        return this.rxByteCountPayload;
    }

    public long RxByteCountTotalGet() {
        return this.rxByteCountTotal;
    }

    public long RxTimestampLastGet() {
        return this.rxTimestampLast;
    }

    public long TxByteCountHeaderGet() {
        return this.txByteCountHeader;
    }

    public long TxByteCountPayloadGet() {
        return this.txByteCountPayload;
    }

    public long TxByteCountTotalGet() {
        return this.txByteCountTotal;
    }

    public long TxTimestampLastGet() {
        return this.txTimestampLast;
    }

    public TCPConnectionState ConnectionStateGet() {
        return this.connectionState;
    }

    public long CongestionWindowCurrentGet() {
        return this.congestionWindowCurrent;
    }

    public long CongestionWindowMaximumGet() {
        return this.congestionWindowMaximum;
    }

    public long CongestionWindowMinimumGet() {
        return this.congestionWindowMinimum;
    }

    public long ReceiverWindowCurrentGet() {
        return this.receiverWindowCurrent;
    }

    public long ReceiverWindowMaximumGet() {
        return this.receiverWindowMaximum;
    }

    public long ReceiverWindowMinimumGet() {
        return this.receiverWindowMinimum;
    }

    public long RoundTripTimeAverageGet() {
        return this.roundTripTimeAverage;
    }

    public long RoundTripTimeMaximumGet() {
        return this.roundTripTimeMaximum;
    }

    public long RoundTripTimeMinimumGet() {
        return this.roundTripTimeMinimum;
    }

    public long SlowStartThresholdCurrentGet() {
        return this.slowStartThresholdCurrent;
    }

    public long SlowStartThresholdMinimumGet() {
        return this.slowStartThresholdMinimum;
    }

    public long SlowStartThresholdMaximumGet() {
        return this.slowStartThresholdMaximum;
    }

    public long RetransmissionCountTotalGet() {
        return this.retransmissionCountTotal;
    }

    public long RetransmissionCountSlowGet() {
        return this.retransmissionCountSlow;
    }

    public long RetransmissionCountFastGet() {
        return this.retransmissionCountFast;
    }

    public long RxSegmentCountTotalGet() {
        return this.rxSegmentCountTotal;
    }

    public long RxSegmentCountOutOfOrderGet() {
        return this.rxSegmentCountOutOfOrder;
    }

    public long TxSegmentCountTotalGet() {
        return this.txSegmentCountTotal;
    }

    public long NumberOfSynReceivedGet() {
        return this.numberOfSynReceived;
    }

    public long TimestampSynReceivedGet() {
        return this.timestampSynReceived;
    }

    public long NumberOfSynSentGet() {
        return this.numberOfSynSent;
    }

    public long TimestampSynSentGet() {
        return this.timestampSynSent;
    }

    public long NumberOfFinSentGet() {
        return this.numberOfFinSent;
    }

    public long TimestampFinSentGet() {
        return this.timestampFinSent;
    }

    public long NumberOfFinReceivedGet() {
        return this.numberOfFinReceived;
    }

    public long TimestampFinReceivedGet() {
        return this.timestampFinReceived;
    }

    public long IntervalDurationGet() {
        return this.intervalDuration;
    }

    public long FlightSizeMaximumGet() {
        return this.flightSizeMaximum;
    }

    public long FlightSizeMinimumGet() {
        return this.flightSizeMinimum;
    }

    public long TimestampEstablishedGet() {
        return this.timestampEstablished;
    }

    public long FlightSizeCurrentGet() {
        return this.flightSizeCurrent;
    }

    private long weightedAverage(long ... data) {
        BigInteger sum = BigInteger.ZERO;
        long totals = 0L;
        assert (data.length % 2 == 0);
        int ctr = 0;
        while (ctr < data.length) {
            long amt = data[ctr];
            long val = data[ctr + 1];
            BigInteger multiplied = BigInteger.valueOf(amt).multiply(BigInteger.valueOf(val));
            sum = sum.add(multiplied);
            totals += amt;
            ctr += 2;
        }
        return sum.divide(BigInteger.valueOf(Math.max(1L, totals))).longValue();
    }

    private long average(long ... data) {
        long sum = 0L;
        long[] lArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            long d = lArray[n2];
            sum += d;
            ++n2;
        }
        return sum / (long)data.length;
    }

    @Override
    public LocalTcpResultData add(LocalTcpResultData oth) {
        LocalTcpResultData result = new LocalTcpResultData(this);
        result.timestamp = Math.max(this.timestamp, oth.TimestampGet());
        result.rxByteCountHeader = this.RxByteCountHeaderGet() + oth.RxByteCountHeaderGet();
        result.rxByteCountPayload = this.RxByteCountPayloadGet() + oth.RxByteCountPayloadGet();
        result.rxByteCountTotal = this.RxByteCountTotalGet() + oth.RxByteCountTotalGet();
        result.rxTimestampLast = Math.max(this.RxTimestampLastGet(), oth.RxTimestampLastGet());
        result.txByteCountHeader = this.TxByteCountHeaderGet() + oth.TxByteCountHeaderGet();
        result.txByteCountPayload = this.TxByteCountPayloadGet() + oth.TxByteCountPayloadGet();
        result.txByteCountTotal = this.TxByteCountTotalGet() + oth.TxByteCountTotalGet();
        result.txTimestampLast = Math.max(this.TxTimestampLastGet(), oth.TxTimestampLastGet());
        result.connectionState = oth.ConnectionStateGet();
        result.congestionWindowCurrent = this.average(this.CongestionWindowCurrentGet(), oth.CongestionWindowCurrentGet());
        result.congestionWindowMaximum = Math.max(this.CongestionWindowMaximumGet(), oth.CongestionWindowMaximumGet());
        result.congestionWindowMinimum = Math.min(this.CongestionWindowMinimumGet(), oth.CongestionWindowMinimumGet());
        result.receiverWindowCurrent = this.average(this.ReceiverWindowCurrentGet(), oth.ReceiverWindowCurrentGet());
        result.receiverWindowMaximum = Math.max(this.ReceiverWindowMaximumGet(), oth.ReceiverWindowMaximumGet());
        result.receiverWindowMinimum = Math.min(this.ReceiverWindowMinimumGet(), oth.ReceiverWindowMinimumGet());
        result.roundTripTimeAverage = this.weightedAverage(this.RxByteCountPayloadGet(), this.RoundTripTimeAverageGet(), oth.rxByteCountPayload, oth.RoundTripTimeAverageGet());
        result.roundTripTimeMaximum = Math.max(this.RoundTripTimeMaximumGet(), oth.RoundTripTimeMaximumGet());
        result.roundTripTimeMinimum = Math.min(this.RoundTripTimeMinimumGet(), oth.RoundTripTimeMinimumGet());
        result.slowStartThresholdCurrent = this.average(this.SlowStartThresholdCurrentGet(), oth.SlowStartThresholdCurrentGet());
        result.slowStartThresholdMinimum = Math.min(this.SlowStartThresholdMinimumGet(), oth.SlowStartThresholdMinimumGet());
        result.slowStartThresholdMaximum = Math.max(this.SlowStartThresholdMaximumGet(), oth.SlowStartThresholdMaximumGet());
        result.retransmissionCountTotal = this.RetransmissionCountTotalGet() + oth.RetransmissionCountTotalGet();
        result.retransmissionCountSlow = this.RetransmissionCountSlowGet() + oth.RetransmissionCountSlowGet();
        result.retransmissionCountFast = this.RetransmissionCountFastGet() + oth.RetransmissionCountFastGet();
        result.rxSegmentCountTotal = this.RxSegmentCountTotalGet() + oth.RxSegmentCountTotalGet();
        result.rxSegmentCountOutOfOrder = this.RxSegmentCountOutOfOrderGet() + oth.RxSegmentCountOutOfOrderGet();
        result.txSegmentCountTotal = this.TxSegmentCountTotalGet() + oth.TxSegmentCountTotalGet();
        result.numberOfSynReceived = this.NumberOfSynReceivedGet() + oth.NumberOfSynReceivedGet();
        result.timestampSynReceived = Math.max(this.TimestampSynReceivedGet(), oth.TimestampSynReceivedGet());
        result.numberOfSynSent = this.NumberOfSynReceivedGet() + oth.NumberOfSynReceivedGet();
        result.timestampSynSent = Math.max(this.TimestampSynSentGet(), oth.TimestampSynSentGet());
        result.numberOfFinSent = this.NumberOfFinSentGet() + oth.NumberOfFinSentGet();
        result.timestampFinSent = Math.max(this.TimestampFinSentGet(), oth.TimestampFinSentGet());
        result.numberOfFinReceived = this.NumberOfFinReceivedGet() + oth.NumberOfFinReceivedGet();
        result.timestampFinReceived = Math.max(this.TimestampFinReceivedGet(), oth.TimestampFinReceivedGet());
        result.intervalDuration = Math.max(this.IntervalDurationGet(), oth.IntervalDurationGet());
        result.flightSizeMaximum = Math.max(this.FlightSizeMaximumGet(), oth.FlightSizeMaximumGet());
        result.flightSizeMinimum = Math.min(this.FlightSizeMinimumGet(), oth.FlightSizeMinimumGet());
        result.timestampEstablished = Math.max(this.TimestampEstablishedGet(), oth.TimestampEstablishedGet());
        result.flightSizeCurrent = this.average(this.FlightSizeCurrentGet(), oth.FlightSizeCurrentGet());
        result.rxLocalCongestionNotificationCount = this.RxLocalCongestionNotificationCountGet() + oth.RxLocalCongestionNotificationCountGet();
        result.rxRemoteCongestionNotificationCount = this.RxRemoteCongestionNotificationCountGet() + oth.RxRemoteCongestionNotificationCountGet();
        return result;
    }
}

