/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.runner.jobs;

import com.excentis.products.byteblower.bear.Bear;
import com.excentis.products.byteblower.bear.BearApi;
import com.excentis.products.byteblower.bear.ProjectReference;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.TimedStartType;
import com.excentis.products.byteblower.model.reader.BatchActionReader;
import com.excentis.products.byteblower.model.reader.BatchReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.project.ByteBlowerResource;
import com.excentis.products.byteblower.project.ByteBlowerResourceController;
import com.excentis.products.byteblower.runner.jobs.ExecuteScenarioJob;
import com.excentis.products.byteblower.runner.jobs.ExecutionJob;
import com.excentis.products.byteblower.runner.jobs.IBatchJobListener;
import com.excentis.products.byteblower.runner.jobs.IScenarioJobListener;
import com.excentis.products.byteblower.runner.workers.OpenFileProjectWorker;
import com.excentis.products.byteblower.runner.workers.OpenXmlProjectWorker;
import com.excentis.products.byteblower.runner.workers.ProjectLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;

public class ExecuteBatchJob
extends ExecutionJob
implements IScenarioJobListener {
    private BatchReader batchReader;
    private final String batchName;
    private final Object finishWaitObj = new Object();
    private boolean batchFinished = false;
    private boolean userCancelRequested;
    private BearApi bearApi;
    private ProjectLoader projectLoader;
    private ProjectReference projectReference;
    private List<IBatchJobListener> listeners = new ArrayList<IBatchJobListener>();
    private int currentBatchAction = 0;
    private IProgressMonitor monitor;
    private ExecuteScenarioJob currentScenarioJob;
    private String runTitle;

    private ExecuteBatchJob(String batchName, String runTitle) {
        super("Run batch '" + batchName + "'");
        this.addJobChangeListener(this);
        this.batchName = batchName;
        this.bearApi = Bear.getBearApi();
        this.userCancelRequested = false;
        this.runTitle = runTitle;
    }

    public ExecuteBatchJob(Path projectFilePath, String batchName, String runTitle) {
        this(batchName, runTitle);
        this.projectLoader = new OpenFileProjectWorker(this.bearApi, projectFilePath);
    }

    public ExecuteBatchJob(String projectXmlString, String batchName, String runTitle) {
        this(batchName, runTitle);
        this.projectLoader = new OpenXmlProjectWorker(this.bearApi, projectXmlString);
    }

    public ExecuteBatchJob(Batch batch, String runTitle) {
        this(batch.getName(), runTitle);
        this.batchReader = ReaderFactory.create((Batch)batch);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.monitor = monitor;
            monitor.beginTask("Running batch", -1);
            if (this.projectReference == null) {
                monitor.subTask(this.projectLoader.getName());
                try {
                    this.projectReference = this.projectLoader.run();
                    if (this.projectReference == null) {
                        throw new IllegalStateException("ProjectReference object should not be null at this point");
                    }
                }
                catch (Exception ex) {
                    Status status = new Status(4, "com.excentis.products.byteblower.runner", "Failed to load project into runtime", (Throwable)ex);
                    monitor.done();
                    return status;
                }
                if (this.userCancelRequested) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (this.projectReference == null) {
                    throw new IllegalStateException("ProjectReference object should not be null at this point");
                }
                if (this.userCancelRequested) {
                    Status status = new Status(8, "com.excentis.products.byteblower.runner", "Batch execution canceled after loading project into runtime");
                    return status;
                }
            }
            if (this.batchReader == null) {
                String resourceUriString = this.projectReference.getProjectResourceUriString();
                ByteBlowerResource resource = ByteBlowerResourceController.getInstance().getResource(resourceUriString);
                if (resource == null) {
                    Status status = new Status(4, "com.excentis.products.byteblower.runner", "Failed to find loaded project resource with URI '" + resourceUriString + "'");
                    return status;
                }
                ByteBlowerProject project = resource.getByteBlowerProject();
                if (project == null) {
                    Status status = new Status(4, "com.excentis.products.byteblower.runner", "Failed to find project within project resource with URI '" + resourceUriString + "'");
                    return status;
                }
                ByteBlowerProjectReader projectReader = ReaderFactory.create((ByteBlowerProject)project);
                this.batchReader = projectReader.getBatchReader(this.batchName);
                if (this.batchReader == null) {
                    Status status = new Status(4, "com.excentis.products.byteblower.runner", "Failed to find batch '" + this.batchName + "' within project resource with URI '" + resourceUriString + "'");
                    return status;
                }
            }
            if (this.batchReader.getStartType() != TimedStartType.RELATIVE) {
                throw new IllegalStateException("Batch '" + this.batchName + "' has start time type " + ((Batch)this.batchReader.getObject()).getStartType() + "; in 2.x this should always be relative");
            }
            if (this.batchReader.getBatchActionBlocks().size() > 1) {
                throw new IllegalStateException("Batch '" + this.batchName + "' contains " + this.batchReader.getBatchActionBlocks().size() + " BatchActionBlocks; in 2.x it should only contain one");
            }
            if (this.userCancelRequested) {
                Status status = new Status(8, "com.excentis.products.byteblower.runner", "Batch execution canceled after scenario jobs were created");
                return status;
            }
            this.scheduleNextScenarioJob();
            this.waitForFinish();
            monitor.subTask("Wrapping up...");
            if (this.userCancelRequested) {
                Status status = new Status(8, "com.excentis.products.byteblower.runner", "Batch canceled");
                return status;
            }
            Status status = new Status(0, "com.excentis.products.byteblower.runner", "Batch executed");
            return status;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextScenarioJob() {
        List readers = this.batchReader.getBatchActionReaders();
        boolean reachedTheEnd = this.currentBatchAction >= readers.size();
        Object object = this.finishWaitObj;
        synchronized (object) {
            if (reachedTheEnd || this.userCancelRequested) {
                this.batchFinished = true;
                this.finishWaitObj.notifyAll();
                return;
            }
        }
        BatchActionReader reader = (BatchActionReader)readers.get(this.currentBatchAction);
        long pauseTimeInMillis = reader.getStartTime().getTimeInMillis();
        if (pauseTimeInMillis < 0L) {
            throw new IllegalStateException("BatchAction " + this.currentBatchAction + " of batch '" + this.batchName + "' has negative relative time " + pauseTimeInMillis + "; in 2.x it should only contain one");
        }
        ExecuteScenarioJob scenarioJob = new ExecuteScenarioJob(this.projectReference, reader.getScenarioReader().getName(), this.runTitle);
        scenarioJob.addScenarioJobListener(this);
        this.monitor.subTask("Scheduling action " + (this.currentBatchAction + 1) + "/" + readers.size() + "... (scenario '" + scenarioJob.getScenarioName() + "')");
        scenarioJob.schedule(pauseTimeInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForFinish() {
        Object object = this.finishWaitObj;
        synchronized (object) {
            while (true) {
                if (this.batchFinished) {
                    return;
                }
                try {
                    this.finishWaitObj.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected void canceling() {
        super.canceling();
        this.userCancelRequested = true;
        if (this.currentScenarioJob != null) {
            this.currentScenarioJob.cancel();
        }
    }

    public String getBatchName() {
        return this.batchName;
    }

    @Override
    public void handleScenarioJobRunning(ExecuteScenarioJob scenarioJob) {
        this.currentScenarioJob = scenarioJob;
        for (IBatchJobListener listener : this.listeners) {
            listener.handleScenarioJobRunning(scenarioJob);
        }
    }

    @Override
    public void handleScenarioJobDone(ExecuteScenarioJob scenarioJob) {
        if (this.currentScenarioJob == scenarioJob) {
            this.currentScenarioJob = null;
        }
        for (IBatchJobListener listener : this.listeners) {
            listener.handleScenarioJobDone(scenarioJob);
        }
        ++this.currentBatchAction;
        this.scheduleNextScenarioJob();
    }

    public void addBatchJobListener(IBatchJobListener listener) {
        this.listeners.add(listener);
    }

    private void notifyExecuteBatchJobRunningListeners() {
        for (IBatchJobListener listener : this.listeners) {
            listener.handleBatchJobRunning(this);
        }
    }

    private void notifyExecuteBatchJobDoneListeners() {
        for (IBatchJobListener listener : this.listeners) {
            listener.handleBatchJobDone(this);
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        this.notifyExecuteBatchJobDoneListeners();
    }

    public void running(IJobChangeEvent event) {
        this.notifyExecuteBatchJobRunningListeners();
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

