/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.server.model.provider;

import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.server.model.reader.PhysicalServerGuiReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.PhysicalServerReader;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelFactory;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import com.excentis.products.byteblower.server.model.provider.AbstractServerItemProvider;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.graphics.Image;

class PhysicalServerItemProvider
extends AbstractServerItemProvider {
    PhysicalServerItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPhysicalConfigurationPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    private void addPhysicalConfigurationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalServer_PhysicalConfiguration_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalServer_PhysicalConfiguration_feature", "_UI_PhysicalServer_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_SERVER__PHYSICAL_CONFIGURATION, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ByteBlowerServerModelPackage.Literals.PHYSICAL_SERVER__PHYSICAL_INTERFACE);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public String getTextGen(Object object) {
        String label = ((PhysicalServer)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_PhysicalServer_type") : String.valueOf(this.getString("_UI_PhysicalServer_type")) + " " + label;
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ByteBlowerServerModelPackage.Literals.PHYSICAL_SERVER__PHYSICAL_INTERFACE, ByteBlowerServerModelFactory.eINSTANCE.createPhysicalInterface()));
    }

    public Image getImage(Object object) {
        PhysicalServer server = (PhysicalServer)object;
        PhysicalServerGuiReader reader = GuiReaderFactory.create((PhysicalServer)server);
        return reader.getImage();
    }

    @Override
    public String getText(Object object) {
        PhysicalServer server = (PhysicalServer)object;
        PhysicalServerReader reader = ReaderFactory.create((PhysicalServer)server);
        return reader.getServerInfoString();
    }

    public String getToolTipText(Object object, int columnIndex) {
        String sysLocation;
        PhysicalServer physicalServer = (PhysicalServer)object;
        String toolTip = new String();
        String localName = physicalServer.getLocalName();
        toolTip = localName != null ? String.valueOf(toolTip) + localName : String.valueOf(toolTip) + "Unknown";
        toolTip = String.valueOf(toolTip) + " ( " + physicalServer.getAddress() + " ) \n";
        String version = physicalServer.getVersion();
        toolTip = version != null ? String.valueOf(toolTip) + "Version : " + version + "\n" : String.valueOf(toolTip) + "Version : unknown\n";
        EList currentUsers = physicalServer.getCurrentUsers();
        if (currentUsers != null) {
            toolTip = currentUsers.isEmpty() ? String.valueOf(toolTip) + "Current users on the system : none \n" : String.valueOf(toolTip) + "Current users on the system : " + currentUsers.toString() + "\n";
        }
        if ((sysLocation = physicalServer.getSysLocation()) != null) {
            toolTip = String.valueOf(toolTip) + "Location : " + sysLocation;
        }
        return toolTip;
    }
}

