/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.server.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InterfaceLinkStatus implements Enumerator
{
    OFFLINE(0, "offline", "offline"),
    ONLINE(1, "online", "online"),
    UNPLUGGED(2, "unplugged", "unplugged"),
    UNKNOWN(3, "unknown", "unknown"),
    USER_RESERVED(4, "userReserved", "userReserved"),
    OTHER_USER_RESERVED(5, "otherUserReserved", "otherUserReserved"),
    TEST_RUNNING(6, "testRunning", "testRunning"),
    OTHER_TEST_RUNNING(7, "otherTestRunning", "otherTestRunning");

    public static final int OFFLINE_VALUE = 0;
    public static final int ONLINE_VALUE = 1;
    public static final int UNPLUGGED_VALUE = 2;
    public static final int UNKNOWN_VALUE = 3;
    public static final int USER_RESERVED_VALUE = 4;
    public static final int OTHER_USER_RESERVED_VALUE = 5;
    public static final int TEST_RUNNING_VALUE = 6;
    public static final int OTHER_TEST_RUNNING_VALUE = 7;
    private static final InterfaceLinkStatus[] VALUES_ARRAY;
    public static final List<InterfaceLinkStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InterfaceLinkStatus[]{OFFLINE, ONLINE, UNPLUGGED, UNKNOWN, USER_RESERVED, OTHER_USER_RESERVED, TEST_RUNNING, OTHER_TEST_RUNNING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InterfaceLinkStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterfaceLinkStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterfaceLinkStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterfaceLinkStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterfaceLinkStatus get(int value) {
        switch (value) {
            case 0: {
                return OFFLINE;
            }
            case 1: {
                return ONLINE;
            }
            case 2: {
                return UNPLUGGED;
            }
            case 3: {
                return UNKNOWN;
            }
            case 4: {
                return USER_RESERVED;
            }
            case 5: {
                return OTHER_USER_RESERVED;
            }
            case 6: {
                return TEST_RUNNING;
            }
            case 7: {
                return OTHER_TEST_RUNNING;
            }
        }
        return null;
    }

    private InterfaceLinkStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

