/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.httpproxy;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.HttpRequestHandler;

class ProxyHandler
implements HttpRequestHandler {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final String HTTP_CONN_KEEPALIVE = "http.proxy.conn-keepalive";
    private static final int HTTPPORT = 80;
    private final HttpProcessor httpproc;
    private final HttpRequestExecutor httpexecutor;
    private final ConnectionReuseStrategy connStrategy;

    ProxyHandler(HttpProcessor httpproc, HttpRequestExecutor httpexecutor) {
        this.httpproc = httpproc;
        this.httpexecutor = httpexecutor;
        this.connStrategy = DefaultConnectionReuseStrategy.INSTANCE;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String requestLine = request.getRequestLine().getUri();
        String host = this.parseTargetHost(requestLine);
        LOGGER.info("Processing Request URI.");
        HttpClientConnection outconn = this.openOutConnection(host);
        context.setAttribute("http.proxy.out-conn", (Object)outconn);
        context.setAttribute("http.connection", (Object)outconn);
        context.setAttribute("http.target_host", (Object)host);
        request.removeHeaders("Content-Length");
        request.removeHeaders("Transfer-Encoding");
        request.removeHeaders("Connection");
        request.removeHeaders("Keep-Alive");
        request.removeHeaders("Proxy-Authenticate");
        request.removeHeaders("TE");
        request.removeHeaders("Trailers");
        request.removeHeaders("Upgrade");
        this.httpexecutor.preProcess(request, this.httpproc, context);
        HttpResponse targetResponse = this.httpexecutor.execute(request, outconn, context);
        this.httpexecutor.postProcess(response, this.httpproc, context);
        targetResponse.removeHeaders("Content-Length");
        targetResponse.removeHeaders("Transfer-Encoding");
        targetResponse.removeHeaders("Connection");
        targetResponse.removeHeaders("Keep-Alive");
        targetResponse.removeHeaders("TE");
        targetResponse.removeHeaders("Trailers");
        targetResponse.removeHeaders("Upgrade");
        response.setStatusLine(targetResponse.getStatusLine());
        response.setHeaders(targetResponse.getAllHeaders());
        response.setEntity(targetResponse.getEntity());
        LOGGER.info("Done processing, sending response.");
        boolean keepalive = this.connStrategy.keepAlive(response, context);
        context.setAttribute(HTTP_CONN_KEEPALIVE, (Object)new Boolean(keepalive));
    }

    private HttpClientConnection openOutConnection(String host) throws UnknownHostException, IOException {
        Socket outsocket = new Socket(host, 80);
        outsocket.setSoTimeout(1000);
        DefaultBHttpClientConnection outconn = new DefaultBHttpClientConnection(16384);
        outconn.bind(outsocket);
        return outconn;
    }

    private String parseTargetHost(String requestLine) throws UnknownHostException {
        if (requestLine.isEmpty()) {
            throw new UnknownHostException();
        }
        try {
            URI u = new URI(requestLine);
            String host = u.getHost();
            if (host.isEmpty()) {
                throw new UnknownHostException();
            }
            return host;
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Received malformatted request", e);
            throw new UnknownHostException();
        }
    }
}

