/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.httpproxy;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpException;
import org.apache.http.HttpServerConnection;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpService;

class ProxyThread
extends Thread {
    private static final String HTTP_IN_CONN = "http.proxy.in-conn";
    protected static final String HTTP_OUT_CONN = "http.proxy.out-conn";
    private static final Logger LOGGER = Logger.getGlobal();
    private static final String HTTP_CONN_KEEPALIVE = "http.proxy.conn-keepalive";
    private final HttpService httpservice;
    private final HttpServerConnection inconn;
    private HttpConnectionMetrics metrics = new EmptyMetrics();

    ProxyThread(HttpService httpservice, HttpServerConnection inconn, HttpClientConnection outconn) {
        this.httpservice = httpservice;
        this.inconn = inconn;
        this.setName("Request thread");
    }

    HttpConnectionMetrics metrics() {
        return this.metrics;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        LOGGER.info("New Request thread");
        HttpClientConnection outconn = null;
        BasicHttpContext context = new BasicHttpContext(null);
        context.setAttribute(HTTP_IN_CONN, (Object)this.inconn);
        try {
            try {
                while (!Thread.interrupted()) {
                    outconn = (HttpClientConnection)context.getAttribute(HTTP_OUT_CONN);
                    if (outconn != null) {
                        this.metrics = this.inconn.getMetrics();
                    }
                    if (!this.inconn.isOpen() && outconn != null) {
                        outconn.close();
                    } else {
                        this.httpservice.handleRequest(this.inconn, (HttpContext)context);
                        boolean keepalive = (Boolean)context.getAttribute(HTTP_CONN_KEEPALIVE);
                        if (keepalive) continue;
                        this.inconn.close();
                    }
                    break;
                }
            }
            catch (ConnectionClosedException ex) {
                LOGGER.log(Level.INFO, "Client closed connection", ex);
                outconn = (HttpClientConnection)context.getAttribute(HTTP_OUT_CONN);
                try {
                    this.inconn.shutdown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (outconn != null) {
                        this.metrics = this.inconn.getMetrics();
                        outconn.shutdown();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "I/O error ", ex);
                outconn = (HttpClientConnection)context.getAttribute(HTTP_OUT_CONN);
                try {
                    this.inconn.shutdown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (outconn != null) {
                        this.metrics = this.inconn.getMetrics();
                        outconn.shutdown();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (HttpException ex) {
                LOGGER.log(Level.INFO, "Unrecoverable HTTP protocol violation", ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                outconn = (HttpClientConnection)context.getAttribute(HTTP_OUT_CONN);
                try {
                    this.inconn.shutdown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (outconn != null) {
                        this.metrics = this.inconn.getMetrics();
                        outconn.shutdown();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            outconn = (HttpClientConnection)context.getAttribute(HTTP_OUT_CONN);
            try {
                this.inconn.shutdown();
            }
            catch (IOException iOException) {}
            try {
                if (outconn != null) {
                    this.metrics = this.inconn.getMetrics();
                    outconn.shutdown();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static final class EmptyMetrics
    implements HttpConnectionMetrics {
        private EmptyMetrics() {
        }

        public void reset() {
        }

        public long getSentBytesCount() {
            return 0L;
        }

        public long getResponseCount() {
            return 0L;
        }

        public long getRequestCount() {
            return 0L;
        }

        public long getReceivedBytesCount() {
            return 0L;
        }

        public Object getMetric(String metricName) {
            return 0L;
        }
    }
}

