/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils;

import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;

public class HighResolutionCalendarParser {
    private static final long NANOSCECONDS_TO_NANOSECONDS = 1L;
    private static final long MICROSECONDS_TO_NANOSECONDS = 1000L;
    private static final long MILLISECONDS_IN_NANOSECONDS = 1000000L;
    private static final long SECONDS_IN_NANOSECONDS = 1000000000L;
    private static final long MINUTES_IN_NANOSECONDS = 60000000000L;
    private static final long HOURS_IN_NANOSECONDS = 3600000000000L;
    private static final long DAYS_IN_NANOSECONDS = 86400000000000L;
    private static final long WEEKS_IN_NANOSECONDS = 604800000000000L;
    private static final BigInteger MAXVAL = BigInteger.valueOf(Long.MAX_VALUE);
    private static String regExpDateTime_DMYInput = "^((((31\\/(0?[13578]|1[02]))|((29|30)\\/(0?[1,3-9]|1[0-2])))\\/(1[6-9]|[2-9]\\d)?\\d{2})|(29\\/0?2\\/(((1[6-9]|[2-9]\\d)?(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))))|(0?[1-9]|1\\d|2[0-8])\\/((0?[1-9])|(1[0-2]))\\/((1[6-9]|[2-9]\\d)?\\d{2})) (20|21|22|23|[0-1]?\\d):[0-5]?\\d:[0-5]?\\d$";

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$utils$HighResolutionCalendarParser$IN_PARSE_STATE = HighResolutionCalendarParser.$SWITCH_TABLE$com$excentis$products$byteblower$utils$HighResolutionCalendarParser$IN_PARSE_STATE();
    }

    public static final String getRelativeTime(HighResolutionCalendar highResolutionCalendar) {
        return HighResolutionCalendarParser.getRelativeTime(highResolutionCalendar, false, true, true);
    }

    public static final String getRelativeTime(long nanoseconds) {
        HighResolutionCalendar calendar = new HighResolutionCalendar(nanoseconds);
        return HighResolutionCalendarParser.getRelativeTime(calendar, false, true, true);
    }

    public static final String getRelativeTime(HighResolutionCalendar highResolutionCalendar, boolean complete, boolean shortUnits) {
        return HighResolutionCalendarParser.getRelativeTime(highResolutionCalendar, complete, shortUnits, true);
    }

    public static final String getRelativeTime(HighResolutionCalendar highResolutionCalendar, boolean complete, boolean shortUnits, boolean withCommas) {
        return HighResolutionCalendarParser.getRelativeTime(highResolutionCalendar, complete, shortUnits, withCommas, 18, 4);
    }

    public static final String getRelativeTime(HighResolutionCalendar highResolutionCalendar, boolean complete, boolean shortUnits, boolean withCommas, int minResolution, int maxResolution) {
        if (highResolutionCalendar == null) {
            return "0s";
        }
        String timestring = "";
        int weeks = highResolutionCalendar.getTotal(4);
        int days = highResolutionCalendar.getTotal(7) - 7 * weeks;
        int hours = highResolutionCalendar.getTotal(10) - 168 * weeks - 24 * days;
        int minutes = highResolutionCalendar.getMinute();
        int seconds = highResolutionCalendar.getSecond();
        int milliSeconds = highResolutionCalendar.getMillisecond();
        int microSeconds = highResolutionCalendar.getMicrosecond();
        int nanoSeconds = highResolutionCalendar.getNanosecond();
        if (minResolution >= 4 && maxResolution <= 4 && (weeks != 0 || complete)) {
            timestring = String.valueOf(timestring) + weeks + (shortUnits ? "w" : " weeks");
        }
        if (minResolution >= 7 && maxResolution <= 7 && (days != 0 || complete)) {
            if (timestring != "") {
                timestring = String.valueOf(timestring) + (withCommas ? ", " : " ");
            }
            timestring = String.valueOf(timestring) + days + (shortUnits ? "d" : " days");
        }
        if (minResolution >= 10 && maxResolution <= 10 && (hours != 0 || complete)) {
            if (timestring != "") {
                timestring = String.valueOf(timestring) + (withCommas ? ", " : " ");
            }
            timestring = String.valueOf(timestring) + hours + (shortUnits ? "h" : " hours");
        }
        if (minResolution >= 12 && maxResolution <= 12 && (minutes != 0 || complete)) {
            if (timestring != "") {
                timestring = String.valueOf(timestring) + (withCommas ? ", " : " ");
            }
            timestring = String.valueOf(timestring) + minutes + (shortUnits ? "m" : " minutes");
        }
        if (minResolution >= 13 && maxResolution <= 13 && (seconds != 0 || complete)) {
            if (timestring != "") {
                timestring = String.valueOf(timestring) + (withCommas ? ", " : " ");
            }
            timestring = String.valueOf(timestring) + seconds + (shortUnits ? "s" : " seconds");
        }
        if (minResolution >= 14 && maxResolution <= 14 && (milliSeconds != 0 || complete)) {
            if (timestring != "") {
                timestring = String.valueOf(timestring) + (withCommas ? ", " : " ");
            }
            timestring = String.valueOf(timestring) + milliSeconds + (shortUnits ? "ms" : " milliseconds");
        }
        if (minResolution >= 17 && maxResolution <= 17 && (microSeconds != 0 || complete)) {
            if (timestring != "") {
                timestring = String.valueOf(timestring) + (withCommas ? ", " : " ");
            }
            timestring = String.valueOf(timestring) + microSeconds + (shortUnits ? "\u03bcs" : " microseconds");
        }
        if (minResolution >= 18 && maxResolution <= 18 && (nanoSeconds != 0 || complete)) {
            if (timestring != "") {
                timestring = String.valueOf(timestring) + (withCommas ? ", " : " ");
            }
            timestring = String.valueOf(timestring) + nanoSeconds + (shortUnits ? "ns" : " nanoseconds");
        }
        if (timestring == "") {
            timestring = "0s";
        }
        return timestring;
    }

    public static boolean relativeTimeInputPatternMatches(String relativeTime) {
        return PARSE_RESULT.SUCCESS == HighResolutionCalendarParser.parseToRelativeTime(relativeTime, null);
    }

    public static boolean dateTime_DMYInputPatternMatches(String valueString) {
        return Pattern.matches(regExpDateTime_DMYInput, valueString);
    }

    public static void setSecondsPrecision(Calendar calendar) {
        long millis = calendar.getTimeInMillis();
        long seconds = millis / 1000L;
        millis = seconds * 1000L;
        calendar.setTimeInMillis(millis);
    }

    private static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static boolean isThousandSeperator(char ch) {
        return ' ' == ch || ',' == ch;
    }

    private static boolean isDot(char ch) {
        return '.' == ch;
    }

    private static boolean isSpace(char ch) {
        return ' ' == ch;
    }

    private static boolean isUnitSeperator(char ch) {
        return ',' == ch || ';' == ch || ':' == ch;
    }

    public static PARSE_RESULT parseToRelativeTime(String input, HighResolutionCalendar target) {
        ParserState stateData = new ParserState(input);
        while (!stateData.isDone()) {
            switch (stateData.getState()) {
                case INTEGRAL: {
                    HighResolutionCalendarParser.handleIntegral(stateData);
                    break;
                }
                case DOT: {
                    HighResolutionCalendarParser.handleDot(stateData);
                    break;
                }
                case DECIMAL: {
                    HighResolutionCalendarParser.handleDecimal(stateData);
                    break;
                }
                case UNIT: {
                    HighResolutionCalendarParser.handleUnit(stateData);
                    break;
                }
                case SPACE: {
                    HighResolutionCalendarParser.handleSpace(stateData);
                    break;
                }
                case UNIT_SEP: {
                    HighResolutionCalendarParser.handleUnitSeperator(stateData);
                    break;
                }
            }
        }
        PARSE_RESULT result = stateData.getResult();
        if (stateData.isEndState()) {
            if (target != null) {
                target.setTimeInNanoseconds(stateData.nanos());
            }
            result = PARSE_RESULT.SUCCESS;
        } else if (PARSE_RESULT.PARSING == result) {
            result = PARSE_RESULT.INCOMPLETE_UNIT;
        }
        return result;
    }

    private static void handleUnitSeperator(ParserState stateData) {
        if (HighResolutionCalendarParser.isUnitSeperator(stateData.current())) {
            stateData.nextChar();
        }
        stateData.prepareNextUnit();
    }

    private static void handleSpace(ParserState stateData) {
        if (HighResolutionCalendarParser.isSpace(stateData.current())) {
            stateData.nextChar();
        } else {
            stateData.nextState(IN_PARSE_STATE.UNIT_SEP);
        }
    }

    private static void handleUnit(ParserState stateData) {
        Collection<TimeUnit> greedy;
        char character = stateData.current();
        if (stateData.getUnitCharPosition() == 0) {
            greedy = TimeUnit.matchList(character);
            stateData.unitMatches(greedy);
        } else {
            greedy = new ArrayList<TimeUnit>();
            for (TimeUnit u : stateData.getMatchedUnits()) {
                if (!stateData.stillValid(u)) continue;
                greedy.add(u);
            }
        }
        if (!greedy.isEmpty()) {
            stateData.continueGreedy();
        }
        if (greedy.isEmpty() || stateData.isLastChar()) {
            stateData.calcUnit();
        }
        if (stateData.isLastChar()) {
            stateData.nextChar();
        } else if (!greedy.isEmpty()) {
            stateData.unitMatches(greedy);
            stateData.nextChar();
        }
    }

    private static void handleDecimal(ParserState stateData) {
        char character = stateData.current();
        if (HighResolutionCalendarParser.isDigit(character)) {
            stateData.nextChar();
            stateData.incrDecimal(character - 48);
        } else if (HighResolutionCalendarParser.isThousandSeperator(character)) {
            stateData.nextChar();
        } else {
            stateData.nextState(IN_PARSE_STATE.UNIT);
        }
    }

    private static void handleDot(ParserState stateData) {
        char character = stateData.current();
        if (HighResolutionCalendarParser.isDot(character)) {
            stateData.hasParsedNumber();
            stateData.nextChar();
            stateData.nextState(IN_PARSE_STATE.DECIMAL);
        } else {
            stateData.nextState(IN_PARSE_STATE.UNIT);
        }
    }

    private static void handleIntegral(ParserState stateData) {
        long LSBMASK = 0x80000000L;
        long MSBMASK = -9223372034707292160L;
        char character = stateData.current();
        if (HighResolutionCalendarParser.isDigit(character)) {
            boolean overflow;
            stateData.hasParsedNumber();
            long integral = stateData.getIntegral();
            long msb = 10L * (integral & 0x8000000080000000L);
            integral = integral * 10L + (long)(character - 48);
            boolean bl = overflow = (msb & 0x80000000L) != 0L || integral < 0L;
            if (overflow) {
                stateData.setResult(PARSE_RESULT.DECIMAL_OVERFLOW);
            }
            stateData.setIntegral(integral);
            stateData.nextChar();
        } else if (HighResolutionCalendarParser.isThousandSeperator(character)) {
            stateData.nextChar();
        } else {
            stateData.nextState(IN_PARSE_STATE.DOT);
        }
    }

    public static boolean setRelativeTime(String input, HighResolutionCalendar target) {
        return PARSE_RESULT.SUCCESS == HighResolutionCalendarParser.parseToRelativeTime(input, target);
    }

    private HighResolutionCalendarParser() {
    }

    private static enum IN_PARSE_STATE {
        INTEGRAL,
        DOT,
        DECIMAL,
        UNIT,
        SPACE,
        UNIT_SEP;

    }

    public static enum PARSE_RESULT {
        SUCCESS,
        UNKNOWN_UNIT,
        DECIMAL_OVERFLOW,
        CALENDER_OVERFLOW,
        BELOW_RESOLUTION,
        OUT_ORDER,
        INCOMPLETE_UNIT,
        NO_VAL_FOR_UNIT,
        DUPLICATE_UNIT,
        PARSING;

    }

    private static class ParserState {
        private boolean parsedNumber = false;
        private BigInteger nanoSeconds = BigInteger.ZERO;
        private long integral = 0L;
        private BigInteger decimal = BigInteger.ZERO;
        private int decimalScale = 1;
        private int unitCharPosition = 0;
        private TimeUnit pastUnit = TimeUnit.nullUnit;
        private Collection<TimeUnit> units = new ArrayList<TimeUnit>();
        private int charCtr = 0;
        private IN_PARSE_STATE state = IN_PARSE_STATE.INTEGRAL;
        private char[] input;
        private PARSE_RESULT result = PARSE_RESULT.PARSING;

        public ParserState(String input) {
            this.input = input.toCharArray();
        }

        public long nanos() {
            return this.nanoSeconds.longValue();
        }

        public boolean isEndState() {
            return PARSE_RESULT.SUCCESS == this.result || PARSE_RESULT.PARSING == this.result && this.state == IN_PARSE_STATE.SPACE || this.state == IN_PARSE_STATE.UNIT_SEP || this.state == IN_PARSE_STATE.INTEGRAL && !this.parsedNumber;
        }

        public void prepareNextUnit() {
            this.state = IN_PARSE_STATE.INTEGRAL;
            this.integral = 0L;
            this.decimal = BigInteger.ZERO;
            this.decimalScale = 1;
            this.unitCharPosition = 0;
            this.parsedNumber = false;
        }

        public void calcUnit() {
            TimeUnit u;
            TimeUnit currentUnit = TimeUnit.nullUnit;
            Iterator<TimeUnit> it = this.unitIterator();
            while (it.hasNext()) {
                u = it.next();
                if (!u.complete(this.unitCharPosition)) continue;
                currentUnit = u;
                break;
            }
            while (it.hasNext()) {
                u = it.next();
                if (!u.complete(this.unitCharPosition)) continue;
                this.setResult(PARSE_RESULT.DUPLICATE_UNIT);
            }
            if (currentUnit.precedence(this.pastUnit)) {
                BigInteger shiftedIntegral = BigInteger.valueOf(currentUnit.baseValue).multiply(BigInteger.valueOf(this.integral));
                this.nanoSeconds = this.nanoSeconds.add(shiftedIntegral);
                long decimalOperand = currentUnit.baseValue / (long)this.decimalScale;
                if (decimalOperand == 0L) {
                    this.setResult(PARSE_RESULT.BELOW_RESOLUTION);
                }
                this.decimal = this.decimal.multiply(BigInteger.valueOf(decimalOperand));
                this.nanoSeconds = this.nanoSeconds.add(this.decimal);
                if (this.nanoSeconds.compareTo(MAXVAL) > 0) {
                    this.setResult(PARSE_RESULT.CALENDER_OVERFLOW);
                }
                this.pastUnit = currentUnit;
                this.state = IN_PARSE_STATE.SPACE;
            } else if (currentUnit == TimeUnit.getNull()) {
                this.setResult(PARSE_RESULT.INCOMPLETE_UNIT);
            } else {
                this.setResult(PARSE_RESULT.OUT_ORDER);
            }
        }

        public Iterator<TimeUnit> unitIterator() {
            return this.units.iterator();
        }

        public boolean isLastChar() {
            return this.charCtr == this.input.length - 1;
        }

        public void continueGreedy() {
            ++this.unitCharPosition;
        }

        public boolean stillValid(TimeUnit u) {
            return u.match(this.unitCharPosition, this.current());
        }

        public Collection<TimeUnit> getMatchedUnits() {
            return this.units;
        }

        public void unitMatches(Collection<TimeUnit> matchedUnits) {
            this.units = matchedUnits;
            if (this.units.isEmpty()) {
                this.setResult(PARSE_RESULT.UNKNOWN_UNIT);
            }
            if (!this.parsedNumber) {
                this.setResult(PARSE_RESULT.NO_VAL_FOR_UNIT);
            }
        }

        public int getUnitCharPosition() {
            return this.unitCharPosition;
        }

        public void incrDecimal(int dig) {
            this.decimal = this.decimal.multiply(BigInteger.TEN).add(BigInteger.valueOf(dig));
            this.decimalScale *= 10;
        }

        public PARSE_RESULT getResult() {
            return this.result;
        }

        public boolean isDone() {
            return this.charCtr >= this.input.length || this.result != PARSE_RESULT.PARSING;
        }

        public void setResult(PARSE_RESULT result) {
            this.result = result;
        }

        public void setIntegral(long integral) {
            this.integral = integral;
        }

        public long getIntegral() {
            return this.integral;
        }

        public void nextState(IN_PARSE_STATE next) {
            this.state = next;
        }

        public void hasParsedNumber() {
            this.parsedNumber = true;
        }

        public IN_PARSE_STATE getState() {
            return this.state;
        }

        public char current() {
            return this.input[this.charCtr];
        }

        public void nextChar() {
            ++this.charCtr;
        }
    }

    private static class TimeUnit {
        private static final TimeUnit[] units = new TimeUnit[]{new TimeUnit(1L, "nanosecond", 1), new TimeUnit(1L, "nanoseconds", 1), new TimeUnit(1000L, "microseconds", 2), new TimeUnit(1000L, "microsecond", 2), new TimeUnit(1000000L, "milliseconds", 3), new TimeUnit(1000000L, "millisecond", 3), new TimeUnit(1000000000L, "seconds", 4), new TimeUnit(1000000000L, "second", 4), new TimeUnit(60000000000L, "minute", 5), new TimeUnit(60000000000L, "minutes", 5), new TimeUnit(3600000000000L, "hours", 6), new TimeUnit(3600000000000L, "hour", 6), new TimeUnit(1L, "ns", 1), new TimeUnit(1000L, "\u03bcs", 2), new TimeUnit(1000L, "us", 2), new TimeUnit(1000000L, "ms", 3), new TimeUnit(1000000000L, "s", 4), new TimeUnit(60000000000L, "m", 5), new TimeUnit(60000000000L, "min", 5), new TimeUnit(3600000000000L, "h", 6), new TimeUnit(3600000000000L, "hr", 6), new TimeUnit(86400000000000L, "d", 7), new TimeUnit(604800000000000L, "w", 8)};
        static final TimeUnit nullUnit = new TimeUnit(0L, "", Integer.MAX_VALUE);
        private final long baseValue;
        private final char[] txt;
        private final int position;

        public static Collection<TimeUnit> matchList(char c) {
            ArrayList<TimeUnit> matches = new ArrayList<TimeUnit>();
            TimeUnit[] timeUnitArray = units;
            int n = units.length;
            int n2 = 0;
            while (n2 < n) {
                TimeUnit unit = timeUnitArray[n2];
                if (unit.match(0, c)) {
                    matches.add(unit);
                }
                ++n2;
            }
            return matches;
        }

        public static TimeUnit getNull() {
            return nullUnit;
        }

        private TimeUnit(long baseValue, String txt, int position) {
            this.baseValue = baseValue;
            this.txt = txt.toCharArray();
            this.position = position;
        }

        public boolean match(int position, char ch) {
            return position < this.txt.length && this.txt[position] == ch;
        }

        public boolean complete(int charIndex) {
            return charIndex == this.txt.length;
        }

        public boolean precedence(TimeUnit pastUnit) {
            return this.position < pastUnit.position;
        }
    }
}

