/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils;

import com.excentis.products.byteblower.utils.Interval;
import java.util.ArrayList;

public final class SubSetIterator {
    private Interval interval;
    private SubSetIterator neighbor;
    private Integer value;
    private boolean started = false;

    public SubSetIterator(Interval interval, int length) {
        this.interval = interval;
        int numNeighbors = length - 1;
        if (numNeighbors > 0) {
            this.neighbor = new SubSetIterator(new Interval(interval.getFirst() + 1, interval.getSecond()), length - 1);
            this.interval = new Interval(interval.getFirst(), interval.getSecond() - numNeighbors);
        }
        this.value = this.interval.getFirst();
    }

    public ArrayList<Integer> getValues() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(this.value);
        if (this.neighbor != null) {
            result.addAll(this.neighbor.getValues());
        }
        return result;
    }

    public boolean hasNext() {
        return this.value < this.interval.getSecond();
    }

    public ArrayList<Integer> next() {
        if (!this.hasNext()) {
            return null;
        }
        if (!this.isStarted()) {
            this.setStarted();
            return this.getValues();
        }
        if (this.neighbor == null) {
            this.value = this.value + 1;
        } else if (this.neighbor.hasNext()) {
            this.neighbor.next();
        } else {
            this.value = this.value + 1;
            this.neighbor.reset(this.value - this.interval.getFirst());
        }
        return this.getValues();
    }

    private void reset(int offset) {
        this.value = this.interval.getFirst() + offset;
        if (this.neighbor != null) {
            this.neighbor.reset(offset);
        }
    }

    private boolean isStarted() {
        return this.started;
    }

    private void setStarted() {
        this.started = true;
        if (this.neighbor != null) {
            this.neighbor.setStarted();
        }
    }
}

