/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils;

import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import com.excentis.products.byteblower.utils.RunTitleUtility;
import java.io.File;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;

public class Utils {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final String[] hexValues = new String[256];

    static {
        int i = 0;
        while (i < 256) {
            Utils.hexValues[i] = String.format("%02X", i);
            ++i;
        }
    }

    private Utils() {
    }

    public static String byte2string(byte b) {
        return hexValues[b & 0xFF];
    }

    public static String bool2string(boolean b) {
        return b ? "Yes" : "No";
    }

    public static byte string2byte(String s) {
        byte b1 = Byte.parseByte("" + s.charAt(0), 16);
        byte b2 = Byte.parseByte("" + s.charAt(1), 16);
        return (byte)((b1 & 0xF) << 4 | b2);
    }

    public static String int2HexString(int n) {
        return Integer.toHexString(n).toUpperCase();
    }

    public static String zeroPadding(String str, int len) {
        StringBuilder buffer = new StringBuilder();
        int toPad = len - str.length();
        int i = 0;
        while (i < toPad) {
            buffer.append('0');
            ++i;
        }
        buffer.append(str);
        return buffer.toString();
    }

    public static byte[] hexStringToBuffer(String hexString) {
        int len = hexString.length();
        String stdHexString = hexString;
        if (len % 2 == 1) {
            ++len;
            stdHexString = "0" + stdHexString;
        }
        byte[] retBytes = new byte[len / 2];
        int i = 0;
        while (i < len / 2) {
            retBytes[i] = Utils.string2byte(stdHexString.substring(i * 2, i * 2 + 2));
            ++i;
        }
        return retBytes;
    }

    public static String bufferToHexString(byte[] buffer) {
        return Utils.bufferToHexString(buffer, buffer.length);
    }

    public static String bufferToHexString(byte[] buffer, int size) {
        StringBuilder bytesHexString = new StringBuilder();
        int j = 0;
        while (j < size) {
            byte curByte = buffer[j];
            String byteHex = Utils.byte2string(curByte);
            bytesHexString.append(byteHex);
            ++j;
        }
        return bytesHexString.toString();
    }

    public static String trim(String value, int scale) {
        BigDecimal decimal = new BigDecimal(value);
        if (decimal.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        decimal = decimal.setScale(scale, 6);
        return Utils.trim(decimal.toString());
    }

    public static String trim(String value) {
        String ret = value;
        if (ret.length() == 0) {
            return "";
        }
        int length = ret.length();
        int commaPos = ret.indexOf(".");
        String beforeComma = ret;
        String afterComma = "";
        if (commaPos != -1) {
            beforeComma = ret.substring(0, commaPos);
            afterComma = ret.substring(commaPos + 1, length);
        }
        while (beforeComma.charAt(0) == '0') {
            if ((beforeComma = beforeComma.substring(1, beforeComma.length())).length() == 0) break;
        }
        if (afterComma.length() > 0) {
            while (afterComma.charAt(afterComma.length() - 1) == '0') {
                if ((afterComma = afterComma.substring(0, afterComma.length() - 1)).length() == 0) break;
            }
        }
        ret = beforeComma.length() > 0 && afterComma.length() > 0 ? String.valueOf(beforeComma) + "." + afterComma : (beforeComma.length() == 0 && afterComma.length() > 0 ? "0." + afterComma : (beforeComma.length() > 0 && afterComma.length() == 0 ? beforeComma : "0"));
        return ret;
    }

    public static BigDecimal convertToBps(BigDecimal throughput, int unit) {
        BigDecimal modifiedThroughput;
        switch (unit) {
            case 0: {
                modifiedThroughput = throughput;
                break;
            }
            case 1: {
                modifiedThroughput = throughput.multiply(BigDecimal.valueOf(1000L));
                break;
            }
            case 2: {
                modifiedThroughput = throughput.multiply(BigDecimal.valueOf(1000000L));
                break;
            }
            case 3: {
                modifiedThroughput = throughput.multiply(BigDecimal.valueOf(1000000000L));
                break;
            }
            case 4: {
                modifiedThroughput = throughput.multiply(BigDecimal.valueOf(8L));
                break;
            }
            case 5: {
                modifiedThroughput = throughput.multiply(BigDecimal.valueOf(8000L));
                break;
            }
            case 6: {
                modifiedThroughput = throughput.multiply(BigDecimal.valueOf(8000000L));
                break;
            }
            case 7: {
                modifiedThroughput = throughput.multiply(BigDecimal.valueOf(1000000000L)).multiply(BigDecimal.valueOf(8L));
                break;
            }
            default: {
                modifiedThroughput = throughput;
            }
        }
        return modifiedThroughput;
    }

    public static Integer convertToInteger(byte value) {
        return value;
    }

    public static String convertToTimeString(HighResolutionCalendar value) {
        return HighResolutionCalendarParser.getRelativeTime(value, false, true);
    }

    public static String convertToString(int value) {
        return Integer.toString(value);
    }

    public static String convertByteToString(byte pcp) {
        return Byte.toString(pcp);
    }

    public static String formatFloat(Float floatValue) {
        int rateInt = Float.valueOf(floatValue.floatValue()).intValue();
        if ((float)rateInt == floatValue.floatValue()) {
            return Integer.toString(rateInt);
        }
        return Float.toString(floatValue.floatValue());
    }

    private static String formatDate(Date date) {
        return dateFormat.format(date);
    }

    public static String getBackupFilename(Date scenarioStartTime) {
        String startTime = Utils.formatDate(scenarioStartTime);
        return "ByteBlower_Project_Backup_" + startTime;
    }

    private static boolean fileExists(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    private static String sanitizeFilename(String input) {
        String forbiddenCharacters = "/<>:\"\\|?*";
        String replacement = "_";
        char[] cArray = "/<>:\"\\|?*".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char forbidden = cArray[n2];
            String check = Pattern.quote("" + forbidden);
            input = input.replaceAll(check, "_");
            ++n2;
        }
        return input;
    }

    public static String createReportFileNameBase(IPath path, String testRunTitle, String testName, Date testStartTime, String postfix) {
        StringBuilder reportFileName = new StringBuilder();
        if (RunTitleUtility.isValidRunTitle(testRunTitle) && !testRunTitle.isEmpty()) {
            reportFileName.append(testRunTitle);
            reportFileName.append(" - ");
        }
        reportFileName.append(Utils.sanitizeFilename(testName));
        reportFileName.append(" - ");
        if (testStartTime == null) {
            testStartTime = new Date();
        }
        String startTime = Utils.formatDate(testStartTime);
        reportFileName.append(startTime);
        if (!postfix.isEmpty()) {
            reportFileName.append("_");
            reportFileName.append(postfix);
        }
        path = path.append(reportFileName.toString());
        String generatedReportFileName = path.toOSString();
        return generatedReportFileName;
    }

    public static String createUniqueReportFilename(String reportOutputFilenameBase, String extension) {
        int uniqueIndex = 1;
        boolean uniquename = false;
        while (!uniquename) {
            String outputFile = String.valueOf(reportOutputFilenameBase) + "_" + uniqueIndex + "." + extension;
            boolean bl = uniquename = !Utils.fileExists(outputFile);
            if (uniquename) {
                return outputFile;
            }
            ++uniqueIndex;
        }
        return null;
    }

    public static String createReportFileName(IPath path, String testRunTitle, String testName, Date testStartTime, String postfix, String extension) {
        String base = Utils.createReportFileNameBase(path, testRunTitle, testName, testStartTime, postfix);
        return Utils.createUniqueReportFilename(base, extension);
    }

    public static boolean runningWindows32Bit() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("win") && Utils.running32Bit();
    }

    public static boolean running32Bit() {
        String bits = System.getProperty("sun.arch.data.model");
        return "32".equals(bits);
    }
}

