/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.zip;

import com.excentis.products.byteblower.utils.Activator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private static final int BUFFER = 2048;

    private Zipper() {
    }

    public static boolean zip(String fileName, String zipFileName) {
        ArrayList<String> singleFileName = new ArrayList<String>();
        singleFileName.add(fileName);
        return Zipper.zip(singleFileName, zipFileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zip(List<String> fileNames, String zipFileName) {
        byte[] data = new byte[2048];
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileOutputStream dest = new FileOutputStream(zipFileName);
                try {
                    try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));){
                        BufferedInputStream origin = null;
                        out.setMethod(8);
                        for (String fileName : fileNames) {
                            int count;
                            File f = new File(fileName);
                            FileInputStream fi = new FileInputStream(f);
                            origin = new BufferedInputStream(fi, 2048);
                            String entryName = f.getName();
                            ZipEntry entry = new ZipEntry(entryName);
                            out.putNextEntry(entry);
                            while ((count = origin.read(data, 0, 2048)) != -1) {
                                out.write(data, 0, count);
                            }
                            origin.close();
                        }
                    }
                    if (dest == null) return true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (dest == null) throw throwable;
                    dest.close();
                    throw throwable;
                }
                dest.close();
                return true;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.print("Exception caught while zipping : " + e);
            Activator.log("Error while zipping", e);
            return false;
        }
    }

    public static boolean unzip(String zipFileName, String fileName) {
        try {
            int BUFFER = 2048;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(zipFileName);
            CheckedInputStream checksum = new CheckedInputStream(fis, new Adler32());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(checksum));
            File fOut = new File(fileName);
            while (zis.getNextEntry() != null) {
                int count;
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(fOut);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            Activator.log("Error unzip", e);
            return false;
        }
        return true;
    }
}

