/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.controller.commands;

import com.excentis.products.byteblower.bear.controller.commands.BearRecordingCommand;
import com.excentis.products.byteblower.bear.feedback.id.BearProjectId;
import com.excentis.products.byteblower.bear.feedback.id.BearScenarioId;
import com.excentis.products.byteblower.bear.feedback.status.EBearScenarioStatus;
import com.excentis.products.byteblower.bear.model.bear.BearFactory;
import com.excentis.products.byteblower.bear.model.bear.BearProject;
import com.excentis.products.byteblower.bear.model.bear.BearScenario;
import java.util.logging.Logger;

public class CreateBearScenarioCommand
extends BearRecordingCommand {
    private static final Logger LOGGER = Logger.getGlobal();
    private final BearProjectId bearProjectId;
    private final BearScenarioId bearScenarioId;
    private BearScenario bearScenario = null;

    public CreateBearScenarioCommand(BearProjectId bearProjectId, BearScenarioId scenarioId) {
        this.bearProjectId = bearProjectId;
        this.bearScenarioId = scenarioId;
    }

    @Override
    protected void doBearExecute() {
        BearProject bearProject = this.getBearProject(this.bearProjectId);
        if (bearProject == null) {
            LOGGER.warning("CreateBearScenarioCommand::doExecute : No Project found with id " + this.bearProjectId);
            return;
        }
        this.bearScenario = BearFactory.eINSTANCE.createBearScenario();
        this.bearScenario.setStatus(EBearScenarioStatus.CREATED);
        this.bearScenario.setBearScenarioId(this.bearScenarioId);
        bearProject.getBearScenarios().add((Object)this.bearScenario);
    }

    public BearScenario getBearScenario() {
        return this.bearScenario;
    }
}

