/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.controller.jobs;

import com.excentis.products.byteblower.bear.controller.commands.BearSetCommand;
import com.excentis.products.byteblower.bear.controller.commands.BearSetScenarioStatusCommand;
import com.excentis.products.byteblower.bear.controller.commands.CreateBearScenarioRunnerJobCommand;
import com.excentis.products.byteblower.bear.controller.jobs.RuntimeBearJob;
import com.excentis.products.byteblower.bear.feedback.id.BearScenarioId;
import com.excentis.products.byteblower.bear.feedback.status.EBearScenarioStatus;
import com.excentis.products.byteblower.bear.model.bear.BearPackage;
import com.excentis.products.byteblower.bear.model.bear.BearRoot;
import com.excentis.products.byteblower.bear.model.bear.BearScenario;
import com.excentis.products.byteblower.bear.model.bear.EBearJobStatus;
import com.excentis.products.byteblower.run.RuntimeScenarioRunner;
import com.excentis.products.byteblower.run.actions.core.CancellationTriggered;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RunScenarioJob
extends RuntimeBearJob {
    private final BearScenario bearScenario;
    private final RuntimeScenarioRunner rtScenarioRunner;

    public RunScenarioJob(BearScenarioId bearScenarioId, RuntimeScenarioRunner rtScenarioRunner) {
        super("Run scenario " + rtScenarioRunner.getRuntimeScenario().getName());
        this.rtScenarioRunner = rtScenarioRunner;
        this.bearScenario = this.getBearReader().getBearScenario(bearScenarioId);
        BearRoot bearRoot = this.getBearRoot();
        CreateBearScenarioRunnerJobCommand jobCommand = new CreateBearScenarioRunnerJobCommand(bearRoot, this.bearScenario, this);
        this.execute(jobCommand);
        this.bearJob = jobCommand.getBearJob();
        this.setJobStatus(EBearJobStatus.INITIALIZED);
    }

    @Override
    protected void work(IProgressMonitor progressMonitor) {
        RuntimeScenario rtScenario = this.rtScenarioRunner.getRuntimeScenario();
        if (rtScenario == null) {
            throw new IllegalStateException("Cannot find runtime scenario for ScenarioId " + this.bearScenario.getBearScenarioId());
        }
        progressMonitor.beginTask("Running scenario", this.calculateScenarioRunWork(rtScenario));
        try {
            this.setScenarioStatus(EBearScenarioStatus.RUNNING);
            this.rtScenarioRunner.run(progressMonitor);
            this.setScenarioStatus(EBearScenarioStatus.FINISHED);
        }
        catch (CancellationTriggered e) {
            this.setScenarioStatus(EBearScenarioStatus.CANCELED);
        }
        catch (Exception e) {
            this.setScenarioException(e);
            this.setScenarioStatus(EBearScenarioStatus.ERROR);
        }
        catch (Throwable e) {
            this.setScenarioStatus(EBearScenarioStatus.ERROR);
        }
    }

    private int calculateScenarioRunWork(RuntimeScenario rtScenario) {
        int work = 0;
        ++work;
        work += 100;
        return ++work;
    }

    private void setScenarioStatus(EBearScenarioStatus status) {
        BearSetScenarioStatusCommand command = new BearSetScenarioStatusCommand(this.bearScenario, status);
        this.execute(command);
    }

    private void setScenarioException(Exception e) {
        BearSetCommand cmd = new BearSetCommand((EObject)this.bearScenario, (EStructuralFeature)BearPackage.Literals.BEAR_SCENARIO__EXCEPTION, e);
        this.execute(cmd);
    }
}

