/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.controller.jobs;

import com.excentis.products.byteblower.bear.controller.BearController;
import com.excentis.products.byteblower.bear.controller.commands.BearSetJobStatusCommand;
import com.excentis.products.byteblower.bear.model.bear.BearJob;
import com.excentis.products.byteblower.bear.model.bear.BearRoot;
import com.excentis.products.byteblower.bear.model.bear.EBearJobStatus;
import com.excentis.products.byteblower.bear.reader.BearReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;

public abstract class RuntimeBearJob
extends Job {
    protected BearJob bearJob = null;

    RuntimeBearJob(String name) {
        super(name);
    }

    public boolean belongsTo(Object family) {
        return false;
    }

    protected IStatus run(IProgressMonitor progressMonitor) {
        try {
            if (this.bearJob.getStatus() != EBearJobStatus.INITIALIZED) {
                throw new IllegalStateException("Cannot run bear job with status " + this.bearJob.getStatus());
            }
            this.setJobStatus(EBearJobStatus.RUNNING);
            this.work(progressMonitor);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.excentis.products.byteblower.bear.controller", String.valueOf(this.getName()) + ": unhandled error", (Throwable)e);
            return status;
        }
        finally {
            progressMonitor.done();
            this.setJobStatus(EBearJobStatus.DONE);
            this.getBearController().removeJob(this);
        }
    }

    protected abstract void work(IProgressMonitor var1);

    private BearController getBearController() {
        return BearController.getInstance();
    }

    protected BearRoot getBearRoot() {
        return this.getBearController().getBearRoot();
    }

    protected BearReader getBearReader() {
        return BearReader.getInstance();
    }

    protected void execute(RecordingCommand command) {
        this.getBearController().execute((Command)command);
    }

    protected void setJobStatus(EBearJobStatus jobStatus) {
        BearSetJobStatusCommand command = new BearSetJobStatusCommand(this.bearJob, jobStatus);
        this.execute(command);
    }

    public BearJob getBearJob() {
        return this.bearJob;
    }
}

