/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.reader;

import com.excentis.products.byteblower.bear.controller.BearController;
import com.excentis.products.byteblower.bear.feedback.id.BearId;
import com.excentis.products.byteblower.bear.feedback.id.BearProjectId;
import com.excentis.products.byteblower.bear.feedback.id.BearScenarioId;
import com.excentis.products.byteblower.bear.feedback.listener.IBearListener;
import com.excentis.products.byteblower.bear.feedback.status.EBearScenarioStatus;
import com.excentis.products.byteblower.bear.model.bear.BearJob;
import com.excentis.products.byteblower.bear.model.bear.BearListener;
import com.excentis.products.byteblower.bear.model.bear.BearProject;
import com.excentis.products.byteblower.bear.model.bear.BearProjectJob;
import com.excentis.products.byteblower.bear.model.bear.BearRoot;
import com.excentis.products.byteblower.bear.model.bear.BearScenario;
import com.excentis.products.byteblower.bear.model.bear.BearScenarioJob;
import com.excentis.products.byteblower.model.Scenario;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;

public class BearReader {
    private static final Logger LOGGER = Logger.getGlobal();
    private static BearReader instance = null;

    public static synchronized BearReader getInstance() {
        if (instance == null) {
            instance = new BearReader();
        }
        return instance;
    }

    private BearReader() {
    }

    private BearController getBearController() {
        return BearController.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runSynchronized(RunnableWithResult<?> runnable) {
        BearController bearController = this.getBearController();
        synchronized (bearController) {
            Object result = null;
            try {
                BearController bearController2 = this.getBearController();
                result = bearController2.getEditingDomain().runExclusive(runnable);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, " BearReader::runSynchronized : InterruptedException", e);
                Thread.currentThread().interrupt();
            }
            return result;
        }
    }

    public BearRoot getBearRoot() {
        BearRoot bearRoot = null;
        RunnableWithResult.Impl<BearRoot> runnable = new RunnableWithResult.Impl<BearRoot>(){

            public void run() {
                BearRoot bearRoot = null;
                Resource bearResource = BearReader.this.getBearController().getBearResource();
                if (!bearResource.getContents().isEmpty()) {
                    bearRoot = (BearRoot)bearResource.getContents().get(0);
                }
                this.setResult(bearRoot);
            }
        };
        bearRoot = (BearRoot)this.runSynchronized((RunnableWithResult<?>)runnable);
        return bearRoot;
    }

    public EList<BearListener> getBearListeners() {
        EList bearListeners = null;
        RunnableWithResult.Impl<EList<BearListener>> runnable = new RunnableWithResult.Impl<EList<BearListener>>(){

            public void run() {
                BearRoot bearRoot = BearReader.this.getBearRoot();
                this.setResult(bearRoot.getListeners());
            }
        };
        bearListeners = (EList)this.runSynchronized((RunnableWithResult<?>)runnable);
        return bearListeners;
    }

    private BearProject getBearProject(final BearProjectId bearProjectId) {
        BearProject bearProject = null;
        final BearRoot bearRoot = this.getBearRoot();
        RunnableWithResult.Impl<BearProject> runnable = new RunnableWithResult.Impl<BearProject>(){

            public void run() {
                for (BearProject bearProject : bearRoot.getProjects()) {
                    if (!bearProject.getBearProjectId().equals((Object)bearProjectId)) continue;
                    this.setResult(bearProject);
                    break;
                }
            }
        };
        bearProject = (BearProject)this.runSynchronized((RunnableWithResult<?>)runnable);
        if (bearProject == null) {
            LOGGER.warning(() -> "BearReader::getBearProject : NO PROJECT FOUND WITH ID " + bearProjectId);
        }
        return bearProject;
    }

    public Scenario getScenario(BearProjectId bearProjectId, final String scenarioName) {
        Scenario mScenario = null;
        final BearProject bearProject = this.getBearProject(bearProjectId);
        RunnableWithResult.Impl<Scenario> runnable = new RunnableWithResult.Impl<Scenario>(){

            public void run() {
                for (Scenario mScenario : bearProject.getProject().getScenario()) {
                    if (!mScenario.getName().equals(scenarioName)) continue;
                    this.setResult(mScenario);
                    break;
                }
            }
        };
        mScenario = (Scenario)this.runSynchronized((RunnableWithResult<?>)runnable);
        return mScenario;
    }

    public BearScenario getBearScenario(final BearScenarioId bearScenarioId) {
        BearScenario bearScenario = null;
        final BearRoot bearRoot = this.getBearRoot();
        RunnableWithResult.Impl<BearScenario> runnable = new RunnableWithResult.Impl<BearScenario>(){

            public void run() {
                block0: for (BearProject bearProject : bearRoot.getProjects()) {
                    for (BearScenario bearScenario : bearProject.getBearScenarios()) {
                        if (!bearScenario.getBearScenarioId().equals((Object)bearScenarioId)) continue;
                        this.setResult(bearScenario);
                        continue block0;
                    }
                }
            }
        };
        bearScenario = (BearScenario)this.runSynchronized((RunnableWithResult<?>)runnable);
        return bearScenario;
    }

    private EBearScenarioStatus getBearScenarioStatus(final BearScenario bearScenario) {
        EBearScenarioStatus bearScenarioStatus = null;
        RunnableWithResult.Impl<EBearScenarioStatus> runnable = new RunnableWithResult.Impl<EBearScenarioStatus>(){

            public void run() {
                EBearScenarioStatus status = bearScenario.getStatus();
                this.setResult(status);
            }
        };
        bearScenarioStatus = (EBearScenarioStatus)this.runSynchronized((RunnableWithResult<?>)runnable);
        return bearScenarioStatus;
    }

    public EBearScenarioStatus getBearScenarioStatus(BearScenarioId bearScenarioId) {
        BearScenario bearScenario = this.getBearScenario(bearScenarioId);
        return this.getBearScenarioStatus(bearScenario);
    }

    private BearJob getBearJob(final BearId bearId) {
        BearJob bearJob = null;
        final BearRoot bearRoot = this.getBearRoot();
        RunnableWithResult.Impl<BearJob> runnable = new RunnableWithResult.Impl<BearJob>(){

            public void run() {
                for (BearJob bearJob : bearRoot.getJobs()) {
                    BearProjectId bearJobId = null;
                    if (bearJob instanceof BearProjectJob) {
                        bearJobId = ((BearProjectJob)bearJob).getBearProject().getBearProjectId();
                    } else if (bearJob instanceof BearScenarioJob) {
                        bearJobId = ((BearScenarioJob)bearJob).getBearScenario().getBearScenarioId();
                    } else {
                        LOGGER.warning("BearReader::getBearJob : Unknown job type...");
                    }
                    if (bearJobId == null || !bearJobId.equals((Object)bearId)) continue;
                    this.setResult(bearJob);
                    break;
                }
            }
        };
        bearJob = (BearJob)this.runSynchronized((RunnableWithResult<?>)runnable);
        return bearJob;
    }

    public Job getJob(BearId bearId) {
        final BearJob bearJob = this.getBearJob(bearId);
        Job job = null;
        if (bearJob != null) {
            RunnableWithResult.Impl<Job> runnable = new RunnableWithResult.Impl<Job>(){

                public void run() {
                    this.setResult(bearJob.getJob());
                }
            };
            job = (Job)this.runSynchronized((RunnableWithResult<?>)runnable);
        }
        return job;
    }

    public IBearListener getExternalListener(final BearListener bearListener) {
        IBearListener externalBearListener = null;
        RunnableWithResult.Impl<IBearListener> runnable = new RunnableWithResult.Impl<IBearListener>(){

            public void run() {
                this.setResult(bearListener.getExternalListener());
            }
        };
        externalBearListener = (IBearListener)this.runSynchronized((RunnableWithResult<?>)runnable);
        return externalBearListener;
    }
}

