/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datalibs;

import com.excentis.products.byteblower.datalibs.DatabaseType;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class DatabaseConfiguration {
    private static final Logger LOGGER = Logger.getGlobal();
    private final DatabaseType type;
    private final String location;
    private final String dbName;

    private DatabaseConfiguration(DatabaseType type, String location, String dbName) {
        this.type = type;
        this.location = location;
        this.dbName = dbName;
        try {
            this.loadDataBaseClass();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void loadDataBaseClass() throws ClassNotFoundException {
        String driverClass = this.type.getDriverClass();
        Class.forName(driverClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasProxy(String databaseUrl) {
        try {
            Proxy aProxy;
            List<Proxy> proxies = ProxySelector.getDefault().select(new URI(databaseUrl));
            if (proxies == null) {
                return false;
            }
            Iterator<Proxy> iterator = proxies.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((aProxy = iterator.next()).address() == null);
            return true;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static DatabaseConfiguration createH2(String username, String password, String fileName, String dbName) {
        System.setProperty("h2.bindAddress", "127.0.0.1");
        String loc = "jdbc:h2:file:" + fileName + dbName + ";MODE=MySQL";
        String strDatabaseUrl = String.format("http://%s", System.getProperty("h2.bindAddress"));
        if (!DatabaseConfiguration.hasProxy(strDatabaseUrl)) {
            LOGGER.info("Enabling H2 Auto server");
            loc = String.valueOf(loc) + ";AUTO_SERVER=TRUE";
        }
        return new DatabaseConfiguration(DatabaseType.H2, loc, dbName);
    }

    protected String getDriverClass() {
        return this.type.getDriverClass();
    }

    public String getUrl() {
        return this.location;
    }

    public String getName() {
        return this.dbName;
    }

    public DatabaseType getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.location) + "::" + this.dbName;
    }
}

