/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.hook;

import com.excentis.products.byteblower.datapersistence.hook.EventHook;
import com.excentis.products.byteblower.datapersistence.hook.UnsupportedEventHookException;
import com.excentis.products.byteblower.datapersistence.hook.impl.RuntimeConsoleLoggingHook;
import com.excentis.products.byteblower.datapersistence.hook.impl.RuntimeDatagatheringHookH2;
import com.excentis.products.byteblower.datapersistence.hook.impl.RuntimeDatagatheringHookMysql;

public class EventHookFactory {
    public static EventHook createHook(Type hookType) throws UnsupportedEventHookException {
        switch (hookType) {
            case LOG_DEBUG: {
                return new RuntimeConsoleLoggingHook(RuntimeConsoleLoggingHook.LogLevel.DEBUG);
            }
            case LOG_INFO: {
                return new RuntimeConsoleLoggingHook(RuntimeConsoleLoggingHook.LogLevel.INFO);
            }
            case LOG_WARNING: {
                return new RuntimeConsoleLoggingHook(RuntimeConsoleLoggingHook.LogLevel.WARNING);
            }
            case DATAGATHERING_MYSQL: {
                return new RuntimeDatagatheringHookMysql();
            }
            case DATAGATHERING_H2: {
                return new RuntimeDatagatheringHookH2();
            }
        }
        throw new UnsupportedEventHookException("Runtime event hook '" + (Object)((Object)hookType) + "' not supported.");
    }

    public static enum Type {
        DATAGATHERING_MYSQL,
        DATAGATHERING_H2,
        DATAGATHERING_HSQLDB,
        LOG_DEBUG,
        LOG_INFO,
        LOG_WARNING,
        LOG_ERROR;

    }
}

