/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.report.json.JsonEvent;
import com.excentis.products.byteblower.report.json.JsonScenario;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.run.actions.ResolveMacAddress;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.Date;

public class AddressResolutionJsonHandle
implements ResolveMacAddress.Listener {
    private final JsonScenario scenario;

    public AddressResolutionJsonHandle(JsonScenario sc) {
        this.scenario = sc;
    }

    public void register(Context context) {
        context.listen(ResolveMacAddress.Listener.class, (Object)this);
    }

    public void onMacAddressResolved(RuntimePort rtPortResolver, String ipAddressString, String macAddressString) {
        this.handleNewAddressResolution(new Date(), rtPortResolver, ipAddressString, macAddressString);
    }

    public void onMacAddressResolveFailed(RuntimePort rtPortResolver, String ipAddressString) {
        this.handleNewAddressResolution(new Date(), rtPortResolver, ipAddressString, null);
    }

    private void handleNewAddressResolution(Date time, RuntimePort rtPortResolver, String ipAddressString, String macAddressString) {
        EventSeverity severity;
        String message;
        String resolverPortName = rtPortResolver.getName();
        String resolvedMacAddress = macAddressString;
        if (resolvedMacAddress == null) {
            message = "Address resolution by resolver '" + resolverPortName + "' for IP " + ipAddressString + " failed.";
            severity = EventSeverity.NETWORK_WARNING;
        } else {
            message = "Address resolution by resolver '" + resolverPortName + "' for IP " + ipAddressString + " returned MAC address " + macAddressString + ".";
            severity = EventSeverity.NETWORK_LOG;
        }
        if (rtPortResolver.isRuntimeLayer3Ipv4()) {
            this.scenario.addEvent(new JsonEvent("", new Date(), severity.name(), message, ""));
        } else if (rtPortResolver.isRuntimeLayer3Ipv6()) {
            this.scenario.addEvent(new JsonEvent("", new Date(), severity.name(), message, ""));
        }
    }
}

