/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.communication.api.StreamRuntimeStatus;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.report.json.JsonEvent;
import com.excentis.products.byteblower.report.json.JsonScenario;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.enums.FlowInstanceStatus;
import com.excentis.products.byteblower.run.actions.ConfigureFlow;
import com.excentis.products.byteblower.run.actions.ConfigureFlowTrafficFb;
import com.excentis.products.byteblower.run.actions.ConfigureFlows;
import com.excentis.products.byteblower.run.actions.CreateFlow;
import com.excentis.products.byteblower.run.actions.CreateFlows;
import com.excentis.products.byteblower.run.actions.CreateFrame;
import com.excentis.products.byteblower.run.actions.ImproveFilters;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeGroupFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeInterface;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.map.MultiValueMap;

public class FbFlowLogJsonHandle
implements CreateFlow.Listener,
CreateFlows.Listener,
ConfigureFlow.Listener,
ConfigureFlows.Listener,
ImproveFilters.Listener,
RunScenario.Listener,
ConfigureFlowTrafficFb.Listener,
CreateFrame.Listener {
    private static final String IPV6_LATENCY_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/118";
    private static final String IPV4_LATENCY_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/117";
    private static final String ARTICLE_COLLIDING_FRAMES = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/148";
    private final JsonScenario sc;
    private final Set<RuntimeFbFlow> flowTxErrorMap = new HashSet<RuntimeFbFlow>();
    private final Set<RuntimeFbFlow> flowTxOutOfResourcesMap = new HashSet<RuntimeFbFlow>();

    public FbFlowLogJsonHandle(JsonScenario sc) {
        this.sc = sc;
    }

    public void register(Context context) {
        context.listen(CreateFlow.Listener.class, (Object)this);
        context.listen(CreateFlows.Listener.class, (Object)this);
        context.listen(ConfigureFlow.Listener.class, (Object)this);
        context.listen(ConfigureFlows.Listener.class, (Object)this);
        context.listen(ImproveFilters.Listener.class, (Object)this);
        context.listen(RunScenario.Listener.class, (Object)this);
        context.listen(ConfigureFlowTrafficFb.Listener.class, (Object)this);
        context.listen(CreateFrame.Listener.class, (Object)this);
    }

    public void onFlowCreated(RuntimeFlow runtimeFlow) {
    }

    public void onFlowCreationFailed(FlowMeasurement flowMeasurement, String errorMessage) {
        if (!(flowMeasurement.getFlow().getFlowTemplate() instanceof FrameBlastingFlow)) {
            return;
        }
        String flowName = flowMeasurement.getFlow().getName();
        String message = "Failed to create flow instance '" + flowName + "' due to following error:\n" + errorMessage;
        this.logFlowEvent(flowName, message, EventSeverity.TEST_ERROR);
    }

    public void onFlowsCreated(RuntimeScenario rtScenario) {
    }

    public void onFlowConfigured(RuntimeFlow runtimeFlow) {
        if (!(runtimeFlow instanceof RuntimeFbFlow) && !(runtimeFlow instanceof RuntimeGroupFbFlow)) {
            return;
        }
        String message = "Frame blasting flow '" + runtimeFlow.name() + "' configured";
        this.logFlowEvent(runtimeFlow.getFlowTemplateName(), message, EventSeverity.TEST_LOG);
    }

    public void onFlowConfigurationFailed(RuntimeFlow runtimeFlow, String errorMessage) {
        if (!(runtimeFlow instanceof RuntimeFbFlow)) {
            return;
        }
        RuntimeFbFlow rtFbFlow = (RuntimeFbFlow)runtimeFlow;
        String message = "Failed to configure frame blasting flow '" + rtFbFlow.name() + "' due to following error:\n" + errorMessage;
        this.logFlowEvent(rtFbFlow.getFlowTemplateName(), message, EventSeverity.TEST_ERROR);
    }

    public void onFlowsConfigured(RuntimeScenario rtScenario) {
    }

    public void onFiltersImproved(RuntimeScenario rtScenario, MultiValueMap rtFbFramesIdentical, MultiValueMap rtFbFramesIndistinguishable) {
        Date time = new Date();
        for (ImproveFilters.InterfaceFrame key : rtFbFramesIdentical.keySet()) {
            this.handleCollidingFrame((RuntimeFrame)key.getFrame(), key.getBbInterface(), rtFbFramesIdentical.getCollection((Object)key), "identical to", time);
        }
        for (ImproveFilters.InterfaceFrame key : rtFbFramesIndistinguishable.keySet()) {
            this.handleCollidingFrame((RuntimeFrame)key.getFrame(), key.getBbInterface(), rtFbFramesIndistinguishable.getCollection((Object)key), "indistinguishable from", time);
        }
    }

    private void handleCollidingFrame(RuntimeFrame rtFrame, RuntimeInterface rtInterface, Collection<RuntimeFrame> collidingFrames, String characteristic, Date time) {
        String conflictingFramesString = this.prettyPrintConflictingFrames(collidingFrames);
        String frameName = rtFrame.getName();
        String flowName = rtFrame.getRuntimeFlow().name();
        String pluralFrameDescription = collidingFrames.size() == 1 ? "a frame" : String.valueOf(collidingFrames.size()) + " frames";
        String pluralFlowDescription = collidingFrames.size() == 1 ? "another flow" : "other flows";
        String serverLocation = rtInterface.getRuntimeServer().getIPAddress();
        String messageFmt = "Frame '%s' of flow '%s' is %s %s of %s when arriving at %s on server %s. Unexpected packets may match this flow's filter and influence RX results.\n(problematic frames: %s)";
        String filledMessage = String.format("Frame '%s' of flow '%s' is %s %s of %s when arriving at %s on server %s. Unexpected packets may match this flow's filter and influence RX results.\n(problematic frames: %s)", frameName, flowName, characteristic, pluralFrameDescription, pluralFlowDescription, rtInterface.getCode(), serverLocation, conflictingFramesString);
        EventSeverity severity = EventSeverity.TEST_WARNING;
        this.sc.addEvent(new JsonEvent(rtFrame.getRuntimeFlow().getFlowTemplateName(), time, severity.name(), filledMessage, ARTICLE_COLLIDING_FRAMES));
    }

    private String prettyPrintConflictingFrames(Collection<RuntimeFrame> rtFramesConflicting) {
        String[] parts = new String[rtFramesConflicting.size()];
        int i = 0;
        for (RuntimeFrame rtFrame : rtFramesConflicting) {
            String errorFormat = "'%s' of '%s'";
            parts[i] = String.format("'%s' of '%s'", rtFrame.getName(), rtFrame.getRuntimeFlow().name());
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(parts[0]);
        if (parts.length > 1) {
            i = 1;
            while (i < parts.length - 1) {
                sb.append(", " + parts[i]);
                ++i;
            }
            sb.append(" and " + parts[parts.length - 1]);
        }
        return sb.toString();
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
        for (RuntimeFlow rtFbFlow : rtScenario.getRuntimeFlows()) {
            if (!(rtFbFlow instanceof RuntimeGroupFbFlow)) continue;
            FlowInstanceStatus status = FlowInstanceStatus.ACTIVE;
            boolean badCount = false;
            boolean bl = false;
        }
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
        this.handleResultsOverTime(rtScenario);
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
        this.handleResultsOverTime(rtScenario);
        this.handleGlobalResults(rtScenario);
    }

    private void handleGlobalResults(RuntimeScenario rtScenario) {
        for (RuntimeFbFlow rtFbFlow : rtScenario.getRuntimeFlowsConfiguredFb()) {
            this.verifyTxPacketCount(rtFbFlow);
        }
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
        this.handleResultsOverTime(rtScenario);
        this.handleGlobalResults(rtScenario);
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
        this.handleResultsOverTime(rtScenario);
        this.handleGlobalResults(rtScenario);
    }

    static FbDestination getDestination(String portName, FbFlowInstanceReader fbFlowInstanceReader) {
        for (FbDestination fbDestination : fbFlowInstanceReader.getDestinationsAndEavesdroppers()) {
            if (!portName.equals(fbDestination.getPort().getName())) continue;
            return fbDestination;
        }
        return null;
    }

    static FbDestination getDestination(RuntimePort port, FbFlowInstanceReader fbFlowInstanceReader) {
        for (FbDestination fbDestination : fbFlowInstanceReader.getDestinationsAndEavesdroppers()) {
            if (!port.getName().equals(fbDestination.getPort().getName())) continue;
            return fbDestination;
        }
        return null;
    }

    private void handleResultsOverTime(RuntimeScenario rtScenario) {
        boolean shouldSaveInterval = rtScenario.allowResultsOverTime();
        for (RuntimeFbFlow rtFbFlow : rtScenario.getRuntimeFlowsConfiguredFb()) {
            this.handleResultsOvertime(rtFbFlow, shouldSaveInterval);
        }
    }

    private void handleResultsOvertime(RuntimeFbFlow rtFbFlow, boolean shouldSaveInterval) {
        if (!this.flowHasTxOutOfResourcesEvent(rtFbFlow) && rtFbFlow.hasTxOutOfResourcesErrorCode()) {
            this.flowSetTxOutOfResourcesEvent(rtFbFlow);
            String ifName = rtFbFlow.getSourceRuntimePort().getInterfaceName();
            String message = "Frame blasting flow '" + rtFbFlow.name() + "' on '" + ifName + "' was out of resources while trying to transmit it's intended traffic load.";
            StreamRuntimeStatus.transmit_error_source errorSource = rtFbFlow.getErrorSource();
            String cause = this.humanErrorMessage(errorSource);
            if (!cause.isEmpty()) {
                message = String.valueOf(message) + " Cause : " + cause;
            }
            this.logFlowEvent(rtFbFlow.getFlowTemplateName(), message, EventSeverity.TEST_WARNING);
        }
        if (!this.flowHasTxErrorEvent(rtFbFlow) && rtFbFlow.hasTxOtherErrorCode()) {
            this.flowSetTxErrorEvent(rtFbFlow);
            String message = "Frame blasting flow '" + rtFbFlow.name() + "' encountered unknown error while transmitting it's intended traffic load.";
            EventSeverity severity = EventSeverity.TEST_WARNING;
            this.logFlowEvent(rtFbFlow.getFlowTemplateName(), message, severity);
        }
    }

    private String humanErrorMessage(StreamRuntimeStatus.transmit_error_source errorSource) {
        String cause = errorSource == StreamRuntimeStatus.transmit_error_source.INTERFACE_HARDWARE ? "Interface hardware limit exceeded." : (errorSource == StreamRuntimeStatus.transmit_error_source.SCHEDULING_CONFLICT ? "Transmission scheduling conflict." : (errorSource == StreamRuntimeStatus.transmit_error_source.TXUSER ? "Application transmission resource limit exceeded." : "Unknown."));
        return cause;
    }

    private void logFlowEvent(String flowName, String message, EventSeverity severity) {
        Date time = new Date();
        this.sc.addEvent(new JsonEvent(flowName, time, severity.name(), message, null));
    }

    private void flowSetTxErrorEvent(RuntimeFbFlow rtFbFlow) {
        this.flowTxErrorMap.add(rtFbFlow);
    }

    private boolean flowHasTxErrorEvent(RuntimeFbFlow rtFbFlow) {
        return this.flowTxErrorMap.contains(rtFbFlow);
    }

    private void flowSetTxOutOfResourcesEvent(RuntimeFbFlow rtFbFlow) {
        this.flowTxOutOfResourcesMap.add(rtFbFlow);
    }

    private boolean flowHasTxOutOfResourcesEvent(RuntimeFbFlow rtFbFlow) {
        return this.flowTxOutOfResourcesMap.contains(rtFbFlow);
    }

    private void verifyTxPacketCount(RuntimeFbFlow rtFbFlow) {
        boolean hasError;
        LocalTriggerResultData tx = rtFbFlow.txCumulativeSnapshot();
        long packetsSent = tx.PacketCountGet();
        long packetsToSend = rtFbFlow.getModelFlowInstanceReader().getNumberOfFrames();
        boolean hasEnd = rtFbFlow.getModelFlowInstanceReader().getDurationInNanoseconds() < Long.MAX_VALUE;
        boolean largeTxRxDifference = packetsSent > 0L && 0.02 < (double)((float)Math.abs(packetsSent - packetsToSend) / (float)Math.max(packetsSent, packetsToSend));
        boolean bl = hasError = !this.flowHasTxOutOfResourcesEvent(rtFbFlow) && largeTxRxDifference && hasEnd;
        if (!hasError) {
            return;
        }
        String underFlowFormat = "Frame blasting flow '%s' did not transmit its intended load: only %d out of %d packets (%.02f %%) were sent.";
        String overFlowFormat = "Frame blasting flow '%s' unexpectedly transmitted more than its intended load: %d instead of %d packets (%.02f %%) were sent.";
        float percentDiff = packetsSent > 0L ? 100.0f * (float)packetsSent / (float)packetsToSend : Float.NaN;
        String message = packetsSent < packetsToSend ? String.format("Frame blasting flow '%s' did not transmit its intended load: only %d out of %d packets (%.02f %%) were sent.", rtFbFlow.name(), packetsSent, packetsToSend, Float.valueOf(percentDiff)) : String.format("Frame blasting flow '%s' unexpectedly transmitted more than its intended load: %d instead of %d packets (%.02f %%) were sent.", rtFbFlow.name(), packetsSent, packetsToSend, Float.valueOf(percentDiff));
        this.logFlowEvent(rtFbFlow.getFlowTemplateName(), message, EventSeverity.TEST_WARNING);
    }

    public void onFbFlowTrafficConfigured(RuntimeFbFlow rtFbFlow) {
    }

    public void onFbFlowLatencyWarning(RuntimeFbFlow rtFbFlow, RuntimeFrame frame) {
        String link;
        String message;
        EventSeverity severity = EventSeverity.TEST_INFO;
        if (frame.hasIPv4Header()) {
            message = "IPv4 UDP Flow with Latency Measurement: automatic UDP checksum disabled.\nDue to a hardware limitation, UDP checksums of IPv4 packets in this latency flow were automatically set to zero (disabled) before timestamping. Click for more info.";
            link = IPV4_LATENCY_ARTICLE;
        } else {
            message = "IPv6 UDP Flow with Latency Measurement: automatic UDP checksum incorrect.\nDue to a hardware limitation, UDP checksums of IPv6 packets in this latency flow were incorrect after timestamping. Invalid packets may have been dropped by intermediate network devices. Click for more info.";
            link = IPV6_LATENCY_ARTICLE;
        }
        this.sc.addEvent(new JsonEvent(rtFbFlow.getFlowTemplateName(), new Date(), severity.name(), message, link));
    }

    public void onFbFlowConfigurationWarning(RuntimeFbFlow rtFbFlow, String desc) {
        EventSeverity severity = EventSeverity.TEST_WARNING;
        this.sc.addEvent(new JsonEvent(rtFbFlow.getFlowTemplateName(), new Date(), severity.name(), desc, null));
    }

    public void onFrameCreated(RuntimeFrame rtFrame) {
    }

    public void onFrameCreationFailed(RuntimeFrame rtFrame, String errorMessage) {
        EventSeverity severity = EventSeverity.TEST_WARNING;
        this.sc.addEvent(new JsonEvent(rtFrame.getRuntimeFlow().name(), new Date(), severity.name(), errorMessage, null));
    }
}

