/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.RetransmissionPolicy;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.Ipv4ConfigurationReader;
import com.excentis.products.byteblower.model.reader.Ipv6ConfigurationReader;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.InterfaceManager;
import com.excentis.products.byteblower.results.testdata.data.Ipv4AddressManager;
import com.excentis.products.byteblower.results.testdata.data.Ipv4NatConfigurationManager;
import com.excentis.products.byteblower.results.testdata.data.Ipv6AddressManager;
import com.excentis.products.byteblower.results.testdata.data.Layer25VlanConfigurationManager;
import com.excentis.products.byteblower.results.testdata.data.Layer3Ipv4ConfigurationDhcpv4Manager;
import com.excentis.products.byteblower.results.testdata.data.Layer3Ipv6ConfigurationDhcpv6Manager;
import com.excentis.products.byteblower.results.testdata.data.Layer3Ipv6ConfigurationSlaacManager;
import com.excentis.products.byteblower.results.testdata.data.MacAddressManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.ServerManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Interface;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4NatConfiguration;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer2;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer25Vlan;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer25VlanConfiguration;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer2EthernetII;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4ConfigurationDhcpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4ConfigurationStatic;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4SessionEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6ConfigurationDhcpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6ConfigurationSlaac;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6ConfigurationStatic;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionGateway;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionPrefix;
import com.excentis.products.byteblower.results.testdata.data.entities.MacAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.PortEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.PortGroup;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.entities.ServerEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.DhcpRetransmissionPolicy;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.enums.InterfaceCode;
import com.excentis.products.byteblower.results.testdata.data.enums.Ipv6AddressType;
import com.excentis.products.byteblower.results.testdata.data.enums.Ipv6DhcpPolicy;
import com.excentis.products.byteblower.results.testdata.data.enums.Ipv6GatewayType;
import com.excentis.products.byteblower.results.testdata.data.enums.Ipv6SlaacPolicy;
import com.excentis.products.byteblower.results.testdata.data.enums.PortStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.ServerConnectionState;
import com.excentis.products.byteblower.results.testdata.data.enums.ServerType;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv6AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.Pair;
import com.excentis.products.byteblower.run.actions.ConfigureLayer2;
import com.excentis.products.byteblower.run.actions.ConfigureLayer25;
import com.excentis.products.byteblower.run.actions.ConfigureLayer3;
import com.excentis.products.byteblower.run.actions.ConfigurePort;
import com.excentis.products.byteblower.run.actions.ConfigurePorts;
import com.excentis.products.byteblower.run.actions.CreateMeetingPoint;
import com.excentis.products.byteblower.run.actions.CreatePort;
import com.excentis.products.byteblower.run.actions.CreatePorts;
import com.excentis.products.byteblower.run.actions.CreateServer;
import com.excentis.products.byteblower.run.actions.CreateServers;
import com.excentis.products.byteblower.run.actions.PerformDhcp;
import com.excentis.products.byteblower.run.actions.PerformStatelessAutoconfiguration;
import com.excentis.products.byteblower.run.actions.StopScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeEthernetIIConfiguration;
import com.excentis.products.byteblower.run.objects.RuntimeIPv4Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeIPv6Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer25Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer2Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeMeetingPoint;
import com.excentis.products.byteblower.run.objects.RuntimeMobileL3IPv4Configuation;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import com.excentis.products.byteblower.run.objects.RuntimeVlanConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PortHandle
extends BaseHandle
implements CreateServer.Listener,
CreateMeetingPoint.Listener,
CreateServers.Listener,
CreatePort.Listener,
CreatePorts.Listener,
ConfigureLayer2.Listener,
ConfigureLayer25.Listener,
ConfigureLayer3.Listener,
PerformDhcp.Listener,
PerformStatelessAutoconfiguration.Listener,
ConfigurePort.Listener,
ConfigurePorts.Listener,
StopScenario.Listener {
    private final EventManager eventManager;
    private final MacAddressManager macAddressManager;
    private final Ipv4AddressManager ipv4AddressManager;
    private final Ipv6AddressManager ipv6AddressManager;
    private final Ipv4NatConfigurationManager ipv4NatConfigurationManager;
    private final ServerManager serverManager;
    private final InterfaceManager interfaceManager;
    private final PortManager portManager;
    private final BaseEntityManager<Layer2EthernetII> layer2EthernetIIManager;
    private final BaseEntityManager<Layer25Vlan> layer25VlanManager;
    private final Layer25VlanConfigurationManager layer25VlanConfigurationManager;
    private final BaseEntityManager<Layer3Ipv4> layer3Ipv4Manager;
    private final Layer3Ipv4ConfigurationDhcpv4Manager layer3Ipv4ConfigurationDhcpv4Manager;
    private final BaseEntityManager<Layer3Ipv4ConfigurationStatic> layer3Ipv4ConfigurationStaticManager;
    private final BaseEntityManager<Layer3Ipv4Session> layer3Ipv4SessionManager;
    private final BaseEntityManager<Layer3Ipv6> layer3Ipv6Manager;
    private final Layer3Ipv6ConfigurationDhcpv6Manager layer3Ipv6ConfigurationDhcpv6Manager;
    private final Layer3Ipv6ConfigurationSlaacManager layer3Ipv6ConfigurationSlaacManager;
    private final BaseEntityManager<Layer3Ipv6ConfigurationStatic> layer3Ipv6ConfigurationStaticManager;
    private final BaseEntityManager<Layer3Ipv6Session> layer3Ipv6SessionManager;
    private final BaseEntityManager<Layer3Ipv6SessionGateway> layer3Ipv6SessionGatewayManager;
    private final BaseEntityManager<Layer3Ipv6SessionPrefix> layer3Ipv6SessionPrefixManager;
    private final BaseEntityManager<Layer3Ipv6SessionAddress> layer3Ipv6SessionAddressManager;
    private final Map<RuntimePort, Port> portCache = new HashMap<RuntimePort, Port>();
    private TestDataPersistenceController pc;
    private Map<RuntimePort, Port> exampleForPortGroup = new HashMap<RuntimePort, Port>();

    public PortHandle(TestDataPersistenceController pc) {
        super(pc);
        this.pc = pc;
        this.eventManager = new EventManager(pc);
        this.macAddressManager = new MacAddressManager(pc);
        this.ipv4AddressManager = new Ipv4AddressManager(pc);
        this.ipv6AddressManager = new Ipv6AddressManager(pc);
        this.serverManager = new ServerManager(pc);
        this.interfaceManager = new InterfaceManager(pc);
        this.portManager = new PortManager(pc);
        this.ipv4NatConfigurationManager = new Ipv4NatConfigurationManager(pc);
        this.layer2EthernetIIManager = new BaseEntityManager(Layer2EthernetII.class, pc);
        this.layer25VlanManager = new BaseEntityManager(Layer25Vlan.class, pc);
        this.layer25VlanConfigurationManager = new Layer25VlanConfigurationManager(pc);
        this.layer3Ipv4Manager = new BaseEntityManager(Layer3Ipv4.class, pc);
        this.layer3Ipv4ConfigurationDhcpv4Manager = new Layer3Ipv4ConfigurationDhcpv4Manager(pc);
        this.layer3Ipv4ConfigurationStaticManager = new BaseEntityManager(Layer3Ipv4ConfigurationStatic.class, pc);
        this.layer3Ipv4SessionManager = new BaseEntityManager(Layer3Ipv4Session.class, pc);
        this.layer3Ipv6Manager = new BaseEntityManager(Layer3Ipv6.class, pc);
        this.layer3Ipv6ConfigurationDhcpv6Manager = new Layer3Ipv6ConfigurationDhcpv6Manager(pc);
        this.layer3Ipv6ConfigurationSlaacManager = new Layer3Ipv6ConfigurationSlaacManager(pc);
        this.layer3Ipv6ConfigurationStaticManager = new BaseEntityManager(Layer3Ipv6ConfigurationStatic.class, pc);
        this.layer3Ipv6SessionManager = new BaseEntityManager(Layer3Ipv6Session.class, pc);
        this.layer3Ipv6SessionGatewayManager = new BaseEntityManager(Layer3Ipv6SessionGateway.class, pc);
        this.layer3Ipv6SessionPrefixManager = new BaseEntityManager(Layer3Ipv6SessionPrefix.class, pc);
        this.layer3Ipv6SessionAddressManager = new BaseEntityManager(Layer3Ipv6SessionAddress.class, pc);
    }

    @Override
    public void register(Context context) {
        context.listen(CreateServer.Listener.class, (Object)this);
        context.listen(CreateMeetingPoint.Listener.class, (Object)this);
        context.listen(CreateServers.Listener.class, (Object)this);
        context.listen(CreatePort.Listener.class, (Object)this);
        context.listen(CreatePorts.Listener.class, (Object)this);
        context.listen(ConfigureLayer2.Listener.class, (Object)this);
        context.listen(ConfigureLayer25.Listener.class, (Object)this);
        context.listen(ConfigureLayer3.Listener.class, (Object)this);
        context.listen(PerformDhcp.Listener.class, (Object)this);
        context.listen(PerformStatelessAutoconfiguration.Listener.class, (Object)this);
        context.listen(ConfigurePort.Listener.class, (Object)this);
        context.listen(ConfigurePorts.Listener.class, (Object)this);
        context.listen(StopScenario.Listener.class, (Object)this);
    }

    private void createServer(RuntimeServer rtServer) {
        String uuid = rtServer.getUUID();
        Server server = this.serverManager.findOnUuid(uuid);
        if (server == null) {
            String ipv4AddressString = rtServer.getIPAddress();
            String name = rtServer.getName();
            String description = rtServer.getDescription();
            Ipv4Address ipv4Address = this.ipv4AddressManager.findOrCreate(ipv4AddressString);
            ServerType type = ServerType.getValueForCode((String)rtServer.getType());
            String version = rtServer.getVersion();
            server = new Server(ipv4AddressString, ServerConnectionState.SUCCESS, uuid, name, ipv4Address, type, version, description);
            this.serverManager.persistIdEntity((BaseEntity)server);
        }
    }

    public void onServerCreated(RuntimeBBServer rtServer) {
        this.createServer((RuntimeServer)rtServer);
    }

    public void onMeetingPointCreated(RuntimeMeetingPoint rtServer) {
        this.createServer((RuntimeServer)rtServer);
    }

    public void onServerCreationFailed(String serverUrl, CreateServer.Listener.ErrorType errorType, String errorMessage) {
        Date time = new Date();
        String description = "Invalid server";
        String uuidString = UUID.randomUUID().toString();
        String name = "";
        Server server = new Server(serverUrl, this.convertServerConnectionState(errorType), uuidString, name, null, null, null, description);
        this.serverManager.persistIdEntity((BaseEntity)server);
        String message = "Failed to contact server at url " + serverUrl + " due to following error:\n" + errorMessage;
        EventSeverity severity = EventSeverity.TEST_ERROR;
        ServerEvent event = new ServerEvent(time, message, severity, server);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    public void onServersCreated(RuntimeScenario rtScenario) {
    }

    public void onPortCreated(RuntimePort rtPort) {
        Port port = this.generatePersistedPort(rtPort);
        this.portCache.put(rtPort, port);
    }

    public void onPortCreationFailed(RuntimePort rtPort, String errorMessage) {
        if (rtPort == null) {
            String message = "Trying to start scenario with unknown port: " + errorMessage;
            EventSeverity severity = EventSeverity.TEST_ERROR;
            PortEvent event = new PortEvent(new Date(), message, severity, null);
            this.eventManager.persistIdEntity((BaseEntity)event);
            return;
        }
        ByteBlowerGuiPort mPort = rtPort.getModelPort();
        RuntimeServer rtServer = rtPort.getRuntimeServer();
        String interfaceString = rtPort.getInterfaceName();
        Date time = new Date();
        String portName = mPort.getName();
        Port port = this.portCache.get(rtPort);
        if (port == null) {
            port = this.generatePersistedPort(rtPort);
            this.portCache.put(rtPort, port);
        }
        port.setStatus(PortStatus.CONFIGURATION_ERROR);
        this.portManager.persistIdEntity((BaseEntity)port);
        String message = "Failed to create port '" + portName + "' on " + rtServer.getIPAddress() + "/" + interfaceString + " due to following error:\n" + errorMessage;
        EventSeverity severity = EventSeverity.TEST_ERROR;
        PortEvent event = new PortEvent(time, message, severity, port);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    private Port generatePersistedPort(RuntimeScenario.RuntimePortGroup a) {
        RuntimePort port;
        String portName = a.name();
        String uuid = "";
        InterfaceCode interfaceCode = InterfaceCode.getValueForCode((String)"");
        RuntimePort rtPort = null;
        Iterator iterator = a.getMembers().iterator();
        if (iterator.hasNext()) {
            port = (RuntimePort)iterator.next();
            uuid = port.getRuntimeServer().getUUID();
            interfaceCode = InterfaceCode.getValueForCode((String)port.getInterfaceName());
            rtPort = port;
        }
        port = null;
        Server server = this.serverManager.findOnUuid(uuid);
        Interface serverInterface = this.interfaceManager.find(server, interfaceCode);
        if (serverInterface == null) {
            serverInterface = new Interface(server, interfaceCode);
            this.interfaceManager.persistIdEntity((BaseEntity)serverInterface);
        }
        Integer mtu = 1500;
        String docked = "Port group";
        port = new Port(portName, serverInterface, mtu, docked);
        port.setStatus(PortStatus.CREATED);
        this.portManager.persistIdEntity((BaseEntity)port);
        String macAddressString = "00-00-00-00-00-00";
        MacAddress macAddress = this.macAddressManager.findOrCreate(macAddressString);
        Layer2EthernetII layer2Eth2 = new Layer2EthernetII((Port)port, macAddress);
        this.layer2EthernetIIManager.persistIdEntity((BaseEntity)layer2Eth2);
        this.exampleForPortGroup.put(rtPort, (Port)port);
        return port;
    }

    private Port generatePersistedPort(RuntimePort rtPort) {
        ByteBlowerGuiPort mPort = rtPort.getModelPort();
        RuntimeServer rtServer = rtPort.getRuntimeServer();
        String interfaceString = rtPort.getInterfaceName();
        String portName = mPort.getName();
        String uuid = rtServer.getUUID();
        InterfaceCode interfaceCode = InterfaceCode.getValueForCode((String)interfaceString);
        Port port = null;
        Server server = this.serverManager.findOnUuid(uuid);
        Interface serverInterface = this.interfaceManager.find(server, interfaceCode);
        if (serverInterface == null) {
            serverInterface = new Interface(server, interfaceCode);
            this.interfaceManager.persistIdEntity((BaseEntity)serverInterface);
        }
        Integer mtu = (int)mPort.getMtu();
        String docked = rtPort.getDockedInfo();
        port = new Port(portName, serverInterface, mtu, docked);
        port.setStatus(PortStatus.CREATED);
        this.persistPort(rtPort, port);
        return port;
    }

    private void persistPort(RuntimePort rtPort, Port port) {
        this.portManager.persistIdEntity((BaseEntity)port);
        this.portCache.put(rtPort, port);
    }

    public void onPortsCreated(RuntimeScenario rtScenario) {
        BaseEntityManager groupManager = new BaseEntityManager(PortGroup.class, this.pc);
        for (RuntimeScenario.RuntimePortGroup a : rtScenario.getPortGroups()) {
            PortGroup group = new PortGroup(a.name());
            for (RuntimePort p : a.getMembers()) {
                group.addMember(this.getCachedPortEntity(p));
            }
            groupManager.persistIdEntity((BaseEntity)group);
            this.generatePersistedPort(a);
        }
        System.out.println("all created");
    }

    public void onPortConfiguring(RuntimePort rtPort) {
        Port port = this.getCachedPortEntity(rtPort);
        port.setStatus(PortStatus.CONFIGURING);
        this.portManager.persistIdEntity((BaseEntity)port);
    }

    public void onLayer2Configured(RuntimeLayer2Configuration rtL2Config) {
        RuntimePort rtPort = rtL2Config.getRuntimePort();
        Port port = this.getCachedPortEntity(rtPort);
        if (!rtPort.isRuntimeLayer2Ethernet()) {
            throw new IllegalStateException("Unsupported layer2 type " + rtL2Config.getClass().getSimpleName());
        }
        String macAddressString = ((RuntimeEthernetIIConfiguration)rtL2Config).getMacAddressString();
        MacAddress macAddress = this.macAddressManager.findOrCreate(macAddressString);
        Layer2EthernetII layer2Eth2 = new Layer2EthernetII(port, macAddress);
        this.layer2EthernetIIManager.persistIdEntity((BaseEntity)layer2Eth2);
    }

    public void onLayer25Configured(List<RuntimeLayer25Configuration> rtL25ConfigList) {
        if (rtL25ConfigList.isEmpty()) {
            return;
        }
        RuntimePort rtPort = rtL25ConfigList.get(0).getRuntimePort();
        Port port = this.getCachedPortEntity(rtPort);
        Layer2 layer2 = port.getLayer2();
        Layer25Vlan parent = null;
        for (RuntimeLayer25Configuration rtL25Config : rtL25ConfigList) {
            if (rtL25Config instanceof RuntimeVlanConfiguration) {
                RuntimeVlanConfiguration rtVlanConfig = (RuntimeVlanConfiguration)rtL25Config;
                Layer25VlanConfiguration vlanConfiguration = this.layer25VlanConfigurationManager.find((int)rtVlanConfig.getVlanId(), (int)rtVlanConfig.getPriority(), rtVlanConfig.isDropEligible());
                if (vlanConfiguration == null) {
                    vlanConfiguration = new Layer25VlanConfiguration(Integer.valueOf(rtVlanConfig.getVlanId()), Integer.valueOf(rtVlanConfig.getPriority()), Boolean.valueOf(rtVlanConfig.isDropEligible()));
                    this.layer25VlanConfigurationManager.persistIdEntity((BaseEntity)vlanConfiguration);
                }
                parent = parent == null ? new Layer25Vlan(layer2, vlanConfiguration) : new Layer25Vlan(parent, vlanConfiguration);
                this.layer25VlanManager.persistIdEntity((BaseEntity)parent);
                continue;
            }
            throw new IllegalStateException("Unsupported layer25 type " + rtL25Config.getClass().getSimpleName());
        }
        Port portGroupClone = this.exampleForPortGroup.get(rtPort);
        if (portGroupClone != null) {
            Layer2 layer22 = portGroupClone.getLayer2();
            Layer25Vlan parent2 = null;
            for (RuntimeLayer25Configuration rtL25Config : rtL25ConfigList) {
                if (rtL25Config instanceof RuntimeVlanConfiguration) {
                    RuntimeVlanConfiguration rtVlanConfig = (RuntimeVlanConfiguration)rtL25Config;
                    Layer25VlanConfiguration vlanConfiguration = this.layer25VlanConfigurationManager.find((int)rtVlanConfig.getVlanId(), (int)rtVlanConfig.getPriority(), rtVlanConfig.isDropEligible());
                    if (vlanConfiguration == null) {
                        vlanConfiguration = new Layer25VlanConfiguration(Integer.valueOf(rtVlanConfig.getVlanId()), Integer.valueOf(rtVlanConfig.getPriority()), Boolean.valueOf(rtVlanConfig.isDropEligible()));
                        this.layer25VlanConfigurationManager.persistIdEntity((BaseEntity)vlanConfiguration);
                    }
                    parent2 = parent2 == null ? new Layer25Vlan(layer22, vlanConfiguration) : new Layer25Vlan(parent2, vlanConfiguration);
                    this.layer25VlanManager.persistIdEntity((BaseEntity)parent2);
                    continue;
                }
                throw new IllegalStateException("Unsupported layer25 type " + rtL25Config.getClass().getSimpleName());
            }
        }
    }

    public void onLayer3Configuring(RuntimePort rtPort) {
        ByteBlowerGuiPortReader mPortReader = rtPort.getModelPortReader();
        Port port = this.getCachedPortEntity(rtPort);
        if (mPortReader.isIPv4()) {
            Layer3Ipv4 layer3Ipv4;
            Ipv4NatConfiguration natType = null;
            PortForwarding forwardingConfig = mPortReader.getPortForwarding();
            if (forwardingConfig == null && mPortReader.isNatted()) {
                natType = Ipv4NatConfiguration.fullAuto();
            } else if (forwardingConfig != null) {
                natType = new Ipv4NatConfiguration(forwardingConfig.getName());
            }
            if (natType != null) {
                natType = this.ipv4NatConfigurationManager.findOrCreate(natType);
            }
            if (mPortReader.usesDHCP() && !rtPort.isMobile()) {
                Dhcp mDhcp = mPortReader.getDhcpv4();
                String dhcpName = mDhcp.getName();
                Layer3Ipv4ConfigurationDhcpv4 dhcpConfiguration = this.layer3Ipv4ConfigurationDhcpv4Manager.find(dhcpName);
                if (dhcpConfiguration == null) {
                    Long discoverInitialTimeout = mDhcp.getInitialDiscoverTimeout().getTimeInNanoseconds();
                    Integer discoverMaxRetries = mDhcp.getMaximumDiscoverRetries();
                    Long requestInitialTimeout = mDhcp.getInitialRequestTimeout().getTimeInNanoseconds();
                    Integer requestMaxRetries = mDhcp.getMaximumRequestRetries();
                    DhcpRetransmissionPolicy retransmissionPolicy = this.convertDhcpRetransmissionPolicy(mDhcp.getRetransmissionPolicy());
                    dhcpConfiguration = new Layer3Ipv4ConfigurationDhcpv4(dhcpName, discoverInitialTimeout, discoverMaxRetries, requestInitialTimeout, requestMaxRetries, retransmissionPolicy);
                    this.layer3Ipv4ConfigurationDhcpv4Manager.persistIdEntity((BaseEntity)dhcpConfiguration);
                }
                layer3Ipv4 = new Layer3Ipv4(port, dhcpConfiguration, natType);
            } else {
                Ipv4ConfigurationReader mIpv4Config = mPortReader.getIpv4ConfigurationReader();
                String addressString = mIpv4Config.getAddressReader().getAddress();
                Ipv4Address address = this.ipv4AddressManager.findOrCreate(addressString);
                String gatewayAddressString = mIpv4Config.getGatewayReader().getAddress();
                Ipv4Address gatewayAddress = this.ipv4AddressManager.findOrCreate(gatewayAddressString);
                String netmaskString = mIpv4Config.getNetmaskReader().getAddress();
                Integer netmask = Ipv4AddressUtility.convertIpv4NetmaskToPrefixLength((String)netmaskString);
                Layer3Ipv4ConfigurationStatic staticConfiguration = new Layer3Ipv4ConfigurationStatic(address, gatewayAddress, netmask);
                this.layer3Ipv4ConfigurationStaticManager.persistIdEntity((BaseEntity)staticConfiguration);
                layer3Ipv4 = new Layer3Ipv4(port, staticConfiguration, natType);
            }
            this.layer3Ipv4Manager.persistIdEntity((BaseEntity)layer3Ipv4);
        } else if (mPortReader.isIPv6()) {
            Layer3Ipv6ConfigurationDhcpv6 dhcpConfiguration;
            Ipv6DhcpPolicy dhcpPolicy;
            Ipv6SlaacPolicy slaacPolicy;
            Layer3Ipv6ConfigurationStatic staticConfiguration;
            Layer3Ipv6ConfigurationSlaac slaacConfiguration;
            if (mPortReader.usesDHCP()) {
                slaacConfiguration = null;
                staticConfiguration = null;
                slaacPolicy = Ipv6SlaacPolicy.DISABLE;
                dhcpPolicy = Ipv6DhcpPolicy.FORCE;
                Dhcp mDhcp = mPortReader.getDhcpv6();
                String dhcpName = mDhcp.getName();
                dhcpConfiguration = this.layer3Ipv6ConfigurationDhcpv6Manager.find(dhcpName);
                if (dhcpConfiguration == null) {
                    Long solicitInitialTimeout = mDhcp.getInitialDiscoverTimeout().getTimeInNanoseconds();
                    Integer solicitMaxRetries = mDhcp.getMaximumDiscoverRetries();
                    Long requestInitialTimeout = mDhcp.getInitialRequestTimeout().getTimeInNanoseconds();
                    Integer requestMaxRetries = mDhcp.getMaximumRequestRetries();
                    DhcpRetransmissionPolicy retransmissionPolicy = this.convertDhcpRetransmissionPolicy(mDhcp.getRetransmissionPolicy());
                    dhcpConfiguration = new Layer3Ipv6ConfigurationDhcpv6(dhcpName, solicitInitialTimeout, solicitMaxRetries, requestInitialTimeout, requestMaxRetries, retransmissionPolicy);
                    this.layer3Ipv6ConfigurationDhcpv6Manager.persistIdEntity((BaseEntity)dhcpConfiguration);
                }
            } else if (mPortReader.usesStatelessAutoconfiguration()) {
                dhcpConfiguration = null;
                staticConfiguration = null;
                dhcpPolicy = Ipv6DhcpPolicy.DISABLE;
                slaacPolicy = Ipv6SlaacPolicy.FORCE_MAC;
                slaacConfiguration = this.layer3Ipv6ConfigurationSlaacManager.findOrCreate();
            } else {
                dhcpConfiguration = null;
                slaacConfiguration = null;
                dhcpPolicy = Ipv6DhcpPolicy.DISABLE;
                slaacPolicy = Ipv6SlaacPolicy.DISABLE;
                Ipv6ConfigurationReader mIpv6ConfigReader = mPortReader.getIpv6ConfigurationReader();
                String addressString = mIpv6ConfigReader.getAddressReader().getAddress();
                Ipv6Address address = this.ipv6AddressManager.findOrCreate(addressString);
                String gatewayAddressString = mIpv6ConfigReader.getDefaultRouterReader().getAddress();
                Ipv6Address gatewayAddress = this.ipv6AddressManager.findOrCreate(gatewayAddressString);
                Integer prefixLength = mIpv6ConfigReader.getPrefixLength();
                HashSet<Pair> addressesWithPrefix = new HashSet<Pair>();
                addressesWithPrefix.add(new Pair((Object)address, (Object)prefixLength));
                HashSet<Pair> gatewaysWithPrefix = new HashSet<Pair>();
                gatewaysWithPrefix.add(new Pair((Object)gatewayAddress, (Object)64));
                staticConfiguration = new Layer3Ipv6ConfigurationStatic(addressesWithPrefix, gatewaysWithPrefix);
                this.layer3Ipv6ConfigurationStaticManager.persistIdEntity((BaseEntity)staticConfiguration);
            }
            Layer3Ipv6 layer3Ipv6 = new Layer3Ipv6(port, dhcpPolicy, slaacPolicy, dhcpConfiguration, slaacConfiguration, staticConfiguration);
            this.layer3Ipv6Manager.persistIdEntity((BaseEntity)layer3Ipv6);
        }
    }

    public void onDHCPPerformed(RuntimeLayer3Configuration rtL3Config) {
        Date time = new Date();
        RuntimePort rtPort = rtL3Config.getRuntimePort();
        String portName = rtPort.getName();
        Port port = this.getCachedPortEntity(rtPort);
        if (rtPort.isRuntimeLayer3Ipv4()) {
            RuntimeIPv4Configuration rtIpv4Config = (RuntimeIPv4Configuration)rtL3Config;
            Layer3Ipv4 layer3Ipv4 = (Layer3Ipv4)port.getLayer3();
            Layer3Ipv4Session ipv4Session = this.fillIpv4Session(layer3Ipv4, rtIpv4Config, "onDhcpPerformed");
            String message = "DHCPv4 performed by port '" + portName + "' provided IPv4 address " + rtIpv4Config.getIPAddress();
            EventSeverity severity = EventSeverity.NETWORK_LOG;
            Layer3Ipv4SessionEvent event = new Layer3Ipv4SessionEvent(time, message, severity, ipv4Session);
            this.eventManager.persistIdEntity((BaseEntity)event);
        } else if (rtPort.isRuntimeLayer3Ipv6()) {
            RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)rtL3Config;
            Layer3Ipv6 layer3Ipv6 = (Layer3Ipv6)port.getLayer3();
            Layer3Ipv6Session ipv6Session = this.fillIpv6SessionWithSingleAddress(layer3Ipv6, rtIpv6Config, "onDhcpPerformed");
            String message = "DHCPv6 performed by port '" + portName + "' provided IPv6 address " + rtIpv6Config.getFullDhcpIPAddress()[0];
            EventSeverity severity = EventSeverity.NETWORK_LOG;
            Layer3Ipv6SessionEvent event = new Layer3Ipv6SessionEvent(time, message, severity, ipv6Session);
            this.eventManager.persistIdEntity((BaseEntity)event);
        }
    }

    public void onDHCPPerformFailed(RuntimeLayer3Configuration rtL3Config, String errorMessage) {
        Date time = new Date();
        RuntimePort rtPort = rtL3Config.getRuntimePort();
        String portName = rtPort.getName();
        Port port = this.getCachedPortEntity(rtPort);
        if (rtPort.isRuntimeLayer3Ipv4()) {
            Layer3Ipv4 layer3Ipv4 = (Layer3Ipv4)port.getLayer3();
            Layer3Ipv4Session ipv4Session = layer3Ipv4.getSession();
            if (ipv4Session != null) {
                throw new IllegalStateException("Found unexpected Layer3Ipv4Session entity for port '" + layer3Ipv4.getPort().getName() + "' at PortHandle.onDHCPPerformFailed");
            }
            ipv4Session = new Layer3Ipv4Session(layer3Ipv4);
            this.layer3Ipv4SessionManager.persistIdEntity((BaseEntity)ipv4Session);
            String message = "DHCPv4 performed by port '" + portName + "' failed to provide IPv4 address due to following error\n" + errorMessage;
            EventSeverity severity = EventSeverity.NETWORK_WARNING;
            Layer3Ipv4SessionEvent event = new Layer3Ipv4SessionEvent(time, message, severity, ipv4Session);
            this.eventManager.persistIdEntity((BaseEntity)event);
        } else if (rtPort.isRuntimeLayer3Ipv6()) {
            RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)rtL3Config;
            Layer3Ipv6 layer3Ipv6 = (Layer3Ipv6)port.getLayer3();
            Layer3Ipv6Session ipv6Session = layer3Ipv6.getSession();
            if (ipv6Session != null) {
                throw new IllegalStateException("Found unexpected Layer3Ipv6Session entity for port '" + layer3Ipv6.getPort().getName() + "' at PortHandle.onDHCPPerformFailed");
            }
            Ipv6Address linkLocalAddress = this.ipv6AddressManager.findOrCreate(rtIpv6Config.getLinkLocalAddress());
            ipv6Session = new Layer3Ipv6Session(layer3Ipv6, linkLocalAddress);
            this.layer3Ipv6SessionManager.persistIdEntity((BaseEntity)ipv6Session);
            String message = "DHCPv6 performed by port '" + portName + "' failed to provide IPv6 address due to following error\n" + errorMessage;
            EventSeverity severity = EventSeverity.NETWORK_WARNING;
            Layer3Ipv6SessionEvent event = new Layer3Ipv6SessionEvent(time, message, severity, ipv6Session);
            this.eventManager.persistIdEntity((BaseEntity)event);
        }
    }

    public void onStatelessAutoconfigurationPerformed(RuntimeLayer3Configuration rtL3Config) {
        Date time = new Date();
        RuntimePort rtPort = rtL3Config.getRuntimePort();
        String portName = rtPort.getName();
        Port port = this.getCachedPortEntity(rtPort);
        if (rtPort.isRuntimeLayer3Ipv6()) {
            RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)rtL3Config;
            Layer3Ipv6 layer3Ipv6 = (Layer3Ipv6)port.getLayer3();
            Layer3Ipv6Session layer3Ipv6Session = this.fillIpv6SessionWithSingleAddress(layer3Ipv6, rtIpv6Config, "onStatelessAutoconfigurationPerformed");
            String message = "SLAAC performed by port '" + portName + "' provided IPv6 address " + rtIpv6Config.getFullStatelessIPAddress()[0];
            EventSeverity severity = EventSeverity.NETWORK_LOG;
            Layer3Ipv6SessionEvent event = new Layer3Ipv6SessionEvent(time, message, severity, layer3Ipv6Session);
            this.eventManager.persistIdEntity((BaseEntity)event);
        }
    }

    public void onStatelessAutoconfigurationFailed(RuntimeLayer3Configuration rtL3Config, String errorMessage) {
        Date time = new Date();
        RuntimePort rtPort = rtL3Config.getRuntimePort();
        String portName = rtPort.getName();
        Port port = this.getCachedPortEntity(rtPort);
        if (rtPort.isRuntimeLayer3Ipv6()) {
            RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)rtL3Config;
            Layer3Ipv6 layer3Ipv6 = (Layer3Ipv6)port.getLayer3();
            Layer3Ipv6Session ipv6Session = layer3Ipv6.getSession();
            if (ipv6Session != null) {
                throw new IllegalStateException("Found unexpected Layer3Ipv6Session entity for port '" + layer3Ipv6.getPort().getName() + "' at PortHandle.onStatelessAutoconfigurationFailed");
            }
            Ipv6Address linkLocalAddress = this.ipv6AddressManager.findOrCreate(rtIpv6Config.getLinkLocalAddress());
            ipv6Session = new Layer3Ipv6Session(layer3Ipv6, linkLocalAddress);
            this.layer3Ipv6SessionManager.persistIdEntity((BaseEntity)ipv6Session);
            String message = "SLAAC performed by port '" + portName + "' failed to provide IPv6 address due to following error\n" + errorMessage;
            EventSeverity severity = EventSeverity.NETWORK_WARNING;
            Layer3Ipv6SessionEvent event = new Layer3Ipv6SessionEvent(time, message, severity, ipv6Session);
            this.eventManager.persistIdEntity((BaseEntity)event);
        }
    }

    public void onLayer3Configured(RuntimeLayer3Configuration rtL3Config) {
        if (!rtL3Config.getRuntimePort().isMobile() && (rtL3Config.getRuntimePort().getModelPortReader().usesDHCP() || rtL3Config.getRuntimePort().getModelPortReader().usesStatelessAutoconfiguration()) && !(rtL3Config instanceof RuntimeMobileL3IPv4Configuation)) {
            return;
        }
        RuntimePort rtPort = rtL3Config.getRuntimePort();
        Port port = this.getCachedPortEntity(rtPort);
        Layer3 layer3 = port.getLayer3();
        if (rtPort.isRuntimeLayer3Ipv4() && layer3 instanceof Layer3Ipv4 && rtL3Config instanceof RuntimeIPv4Configuration) {
            RuntimeIPv4Configuration rtIpv4Config = (RuntimeIPv4Configuration)rtL3Config;
            Layer3Ipv4 layer3Ipv4 = (Layer3Ipv4)layer3;
            this.fillIpv4Session(layer3Ipv4, rtIpv4Config, "onLayer3Configured");
        } else if (rtPort.isRuntimeLayer3Ipv6() && layer3 instanceof Layer3Ipv6 && rtL3Config instanceof RuntimeIPv6Configuration) {
            RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)rtL3Config;
            Layer3Ipv6 layer3Ipv6 = (Layer3Ipv6)layer3;
            this.fillIpv6SessionWithSingleAddress(layer3Ipv6, rtIpv6Config, "onLayer3Configured");
        }
    }

    private Layer3Ipv4Session fillIpv4Session(Layer3Ipv4 layer3Ipv4, RuntimeIPv4Configuration rtIpv4Config, String callingMethodName) {
        Layer3Ipv4Session ipv4Session = layer3Ipv4.getSession();
        if (ipv4Session != null) {
            throw new IllegalStateException("Found unexpected Layer3Ipv4Session entity for port '" + layer3Ipv4.getPort().getName() + "' at PortHandle." + callingMethodName);
        }
        ipv4Session = new Layer3Ipv4Session(layer3Ipv4);
        this.layer3Ipv4SessionManager.persistIdEntity((BaseEntity)ipv4Session);
        String addressString = rtIpv4Config.getIPAddress();
        String gatewayAddressString = rtIpv4Config.getGateway();
        String netmaskString = rtIpv4Config.getPrefix();
        Ipv4Address address = this.ipv4AddressManager.findOrCreate(addressString);
        Ipv4Address gatewayAddress = this.ipv4AddressManager.findOrCreate(gatewayAddressString);
        Integer prefixLength = Ipv4AddressUtility.convertIpv4NetmaskToPrefixLength((String)netmaskString);
        ipv4Session.setAddress(address);
        ipv4Session.setGatewayAddress(gatewayAddress);
        ipv4Session.setNetmaskValue(prefixLength);
        this.layer3Ipv4SessionManager.persistIdEntity((BaseEntity)ipv4Session);
        return ipv4Session;
    }

    private Layer3Ipv6Session fillIpv6SessionWithSingleAddress(Layer3Ipv6 layer3Ipv6, RuntimeIPv6Configuration rtIpv6Config, String callingMethodName) {
        int globalPrefixLength;
        String globalAddressString;
        Ipv6AddressType addressType;
        Ipv6GatewayType gatewayType;
        Layer3Ipv6Session ipv6Session = layer3Ipv6.getSession();
        if (ipv6Session != null) {
            throw new IllegalStateException("Found unexpected Layer3Ipv6Session entity for port '" + layer3Ipv6.getPort().getName() + "' at PortHandle." + callingMethodName);
        }
        Ipv6Address linkLocalAddress = this.ipv6AddressManager.findOrCreate(rtIpv6Config.getLinkLocalAddress());
        ipv6Session = new Layer3Ipv6Session(layer3Ipv6, linkLocalAddress);
        this.layer3Ipv6SessionManager.persistIdEntity((BaseEntity)ipv6Session);
        if (rtIpv6Config.getRuntimePort().isMobile()) {
            gatewayType = Ipv6GatewayType.FIXED;
            addressType = Ipv6AddressType.FIXED;
            globalAddressString = rtIpv6Config.getFullFixedIPAddress()[0];
            globalPrefixLength = Integer.parseInt(rtIpv6Config.getFullFixedIPAddress()[1]);
        } else if (rtIpv6Config.getRuntimePort().getModelPortReader().usesDHCP()) {
            gatewayType = Ipv6GatewayType.AUTO;
            addressType = Ipv6AddressType.DHCP_FORCED;
            globalAddressString = rtIpv6Config.getFullDhcpIPAddress()[0];
            globalPrefixLength = Integer.parseInt(rtIpv6Config.getFullDhcpIPAddress()[1]);
        } else if (rtIpv6Config.getRuntimePort().getModelPortReader().usesStatelessAutoconfiguration()) {
            gatewayType = Ipv6GatewayType.AUTO;
            addressType = Ipv6AddressType.SLAAC_FORCED_MAC;
            globalAddressString = rtIpv6Config.getFullStatelessIPAddress()[0];
            globalPrefixLength = Integer.parseInt(rtIpv6Config.getFullStatelessIPAddress()[1]);
        } else {
            gatewayType = Ipv6GatewayType.FIXED;
            addressType = Ipv6AddressType.FIXED;
            globalAddressString = rtIpv6Config.getFullFixedIPAddress()[0];
            globalPrefixLength = Integer.parseInt(rtIpv6Config.getFullFixedIPAddress()[1]);
        }
        String gatewayAddressString = rtIpv6Config.getGateway();
        String globalPrefixString = Ipv6AddressUtility.retrieveIpv6PrefixFromIpv6Address((String)globalAddressString, (int)globalPrefixLength);
        Ipv6Address globalAddress = this.ipv6AddressManager.findOrCreate(globalAddressString);
        Ipv6Address globalPrefixAddress = this.ipv6AddressManager.findOrCreate(globalPrefixString);
        Ipv6Address gatewayAddress = this.ipv6AddressManager.findOrCreate(gatewayAddressString);
        Layer3Ipv6SessionGateway sessionGateway = new Layer3Ipv6SessionGateway(ipv6Session, gatewayAddress, gatewayType);
        this.layer3Ipv6SessionGatewayManager.persistIdEntity((BaseEntity)sessionGateway);
        Layer3Ipv6SessionPrefix sessionPrefix = new Layer3Ipv6SessionPrefix(ipv6Session, globalPrefixAddress, Integer.valueOf(globalPrefixLength));
        this.layer3Ipv6SessionPrefixManager.persistIdEntity((BaseEntity)sessionPrefix);
        Layer3Ipv6SessionAddress sessionAddress = new Layer3Ipv6SessionAddress(sessionPrefix, globalAddress, addressType);
        this.layer3Ipv6SessionAddressManager.persistIdEntity((BaseEntity)sessionAddress);
        return ipv6Session;
    }

    public void onPortConfigured(RuntimePort rtPort) {
        Date time = new Date();
        String portName = rtPort.getName();
        Port port = this.getCachedPortEntity(rtPort);
        port.setStatus(PortStatus.ACTIVE);
        this.portManager.persistIdEntity((BaseEntity)port);
        String message = "Port '" + portName + "' is configured.";
        EventSeverity severity = EventSeverity.TEST_LOG;
        PortEvent event = new PortEvent(time, message, severity, port);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    public void onPortConfigurationFailed(RuntimePort rtPort, String errorMessage) {
        Date time = new Date();
        String portName = rtPort.getName();
        Port port = this.getCachedPortEntity(rtPort);
        port.setStatus(PortStatus.CONFIGURATION_ERROR);
        this.portManager.persistIdEntity((BaseEntity)port);
        String message = "Failed to configure port '" + portName + "' due to following error:\n" + errorMessage;
        EventSeverity severity = EventSeverity.TEST_ERROR;
        PortEvent event = new PortEvent(time, message, severity, port);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    public void onPortsConfigured(RuntimeScenario rtScenario) {
    }

    public void onScenarioStopped(RuntimeScenario rtScenario) {
        Date time = new Date();
        for (RuntimePort rtPort : rtScenario.getRuntimePorts()) {
            String portName = rtPort.getName();
            Port port = this.getCachedPortEntity(rtPort);
            port.setStatus(PortStatus.STOPPED);
            this.portManager.persistIdEntity((BaseEntity)port);
            String message = "Port '" + portName + "' is destroyed.";
            EventSeverity severity = EventSeverity.TEST_LOG;
            PortEvent event = new PortEvent(time, message, severity, port);
            this.eventManager.persistIdEntity((BaseEntity)event);
        }
    }

    private DhcpRetransmissionPolicy convertDhcpRetransmissionPolicy(RetransmissionPolicy modelRetransmissionPolicy) {
        switch (modelRetransmissionPolicy) {
            case FIXED_TIMING: {
                return DhcpRetransmissionPolicy.FIXED_TIMING;
            }
            case RFC_SUGGESTED: {
                return DhcpRetransmissionPolicy.RFC_2131_SUGGESTED;
            }
        }
        return null;
    }

    private ServerConnectionState convertServerConnectionState(CreateServer.Listener.ErrorType errorType) {
        switch (errorType) {
            case INCOMPATIBLE_VERSION: {
                return ServerConnectionState.SERVER_INCOMPATIBLE_VERSION;
            }
        }
        return ServerConnectionState.SERVER_UNKNOWN_ERROR;
    }

    private Port getCachedPortEntity(RuntimePort rtPort) {
        String portName = rtPort.getName();
        Port port = this.portCache.get(rtPort);
        if (port == null) {
            throw new IllegalStateException("Could not find cached Port entity for port '" + portName + "'");
        }
        return port;
    }
}

